/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableSchema;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.ValueInSingleWindow;

public abstract class DynamicDestinations<T, DestinationT>
implements Serializable {
    private SideInputAccessor sideInputAccessor;

    public List<PCollectionView<?>> getSideInputs() {
        return Lists.newArrayList();
    }

    protected <SideInputT> SideInputT sideInput(PCollectionView<SideInputT> view) {
        Preconditions.checkArgument((boolean)this.getSideInputs().contains(view), (String)"View %s not declared in getSideInputs() (%s)", view, this.getSideInputs());
        return this.sideInputAccessor.sideInput(view);
    }

    void setSideInputAccessor(SideInputAccessor sideInputAccessor) {
        this.sideInputAccessor = sideInputAccessor;
    }

    void setSideInputAccessorFromProcessContext(DoFn.ProcessContext context) {
        this.sideInputAccessor = new SideInputAccessorViaProcessContext(context);
    }

    public abstract DestinationT getDestination(ValueInSingleWindow<T> var1);

    @Nullable
    public Coder<DestinationT> getDestinationCoder() {
        return null;
    }

    public abstract TableDestination getTable(DestinationT var1);

    public abstract TableSchema getSchema(DestinationT var1);

    Coder<DestinationT> getDestinationCoderWithDefault(CoderRegistry registry) throws CannotProvideCoderException {
        Coder<DestinationT> destinationCoder = this.getDestinationCoder();
        if (destinationCoder != null) {
            return destinationCoder;
        }
        Type superclass = this.getClass().getGenericSuperclass();
        while (superclass != null) {
            ParameterizedType parameterized;
            if (superclass instanceof ParameterizedType && (parameterized = (ParameterizedType)superclass).getRawType() == DynamicDestinations.class) {
                Type parameter = parameterized.getActualTypeArguments()[1];
                Class parameterClass = (Class)parameter;
                return registry.getCoder(parameterClass);
            }
            superclass = ((Class)superclass).getGenericSuperclass();
        }
        throw new AssertionError((Object)("Couldn't find the DynamicDestinations superclass of " + this.getClass()));
    }

    static class SideInputAccessorViaProcessContext
    implements SideInputAccessor {
        private DoFn.ProcessContext processContext;

        SideInputAccessorViaProcessContext(DoFn.ProcessContext processContext) {
            this.processContext = processContext;
        }

        @Override
        public <SideInputT> SideInputT sideInput(PCollectionView<SideInputT> view) {
            return (SideInputT)this.processContext.sideInput(view);
        }
    }

    static interface SideInputAccessor {
        public <SideInputT> SideInputT sideInput(PCollectionView<SideInputT> var1);
    }
}

