/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.options.ValueProvider;

final class AutoValue_BigQueryIO_Read
extends BigQueryIO.Read {
    private final ValueProvider<String> jsonTableRef;
    private final ValueProvider<String> query;
    private final boolean validate;
    private final Boolean flattenResults;
    private final Boolean useLegacySql;
    private final BigQueryServices bigQueryServices;

    private AutoValue_BigQueryIO_Read(@Nullable ValueProvider<String> jsonTableRef, @Nullable ValueProvider<String> query, boolean validate, @Nullable Boolean flattenResults, @Nullable Boolean useLegacySql, BigQueryServices bigQueryServices) {
        this.jsonTableRef = jsonTableRef;
        this.query = query;
        this.validate = validate;
        this.flattenResults = flattenResults;
        this.useLegacySql = useLegacySql;
        this.bigQueryServices = bigQueryServices;
    }

    @Override
    @Nullable
    ValueProvider<String> getJsonTableRef() {
        return this.jsonTableRef;
    }

    @Override
    @Nullable
    ValueProvider<String> getQuery() {
        return this.query;
    }

    @Override
    boolean getValidate() {
        return this.validate;
    }

    @Override
    @Nullable
    Boolean getFlattenResults() {
        return this.flattenResults;
    }

    @Override
    @Nullable
    Boolean getUseLegacySql() {
        return this.useLegacySql;
    }

    @Override
    BigQueryServices getBigQueryServices() {
        return this.bigQueryServices;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BigQueryIO.Read) {
            BigQueryIO.Read that = (BigQueryIO.Read)((Object)o);
            return (this.jsonTableRef == null ? that.getJsonTableRef() == null : this.jsonTableRef.equals(that.getJsonTableRef())) && (this.query == null ? that.getQuery() == null : this.query.equals(that.getQuery())) && this.validate == that.getValidate() && (this.flattenResults == null ? that.getFlattenResults() == null : this.flattenResults.equals(that.getFlattenResults())) && (this.useLegacySql == null ? that.getUseLegacySql() == null : this.useLegacySql.equals(that.getUseLegacySql())) && this.bigQueryServices.equals(that.getBigQueryServices());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.jsonTableRef == null ? 0 : this.jsonTableRef.hashCode();
        h *= 1000003;
        h ^= this.query == null ? 0 : this.query.hashCode();
        h *= 1000003;
        h ^= this.validate ? 1231 : 1237;
        h *= 1000003;
        h ^= this.flattenResults == null ? 0 : this.flattenResults.hashCode();
        h *= 1000003;
        h ^= this.useLegacySql == null ? 0 : this.useLegacySql.hashCode();
        h *= 1000003;
        return h ^= this.bigQueryServices.hashCode();
    }

    @Override
    BigQueryIO.Read.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends BigQueryIO.Read.Builder {
        private ValueProvider<String> jsonTableRef;
        private ValueProvider<String> query;
        private Boolean validate;
        private Boolean flattenResults;
        private Boolean useLegacySql;
        private BigQueryServices bigQueryServices;

        Builder() {
        }

        private Builder(BigQueryIO.Read source) {
            this.jsonTableRef = source.getJsonTableRef();
            this.query = source.getQuery();
            this.validate = source.getValidate();
            this.flattenResults = source.getFlattenResults();
            this.useLegacySql = source.getUseLegacySql();
            this.bigQueryServices = source.getBigQueryServices();
        }

        @Override
        BigQueryIO.Read.Builder setJsonTableRef(@Nullable ValueProvider<String> jsonTableRef) {
            this.jsonTableRef = jsonTableRef;
            return this;
        }

        @Override
        BigQueryIO.Read.Builder setQuery(@Nullable ValueProvider<String> query) {
            this.query = query;
            return this;
        }

        @Override
        BigQueryIO.Read.Builder setValidate(boolean validate) {
            this.validate = validate;
            return this;
        }

        @Override
        BigQueryIO.Read.Builder setFlattenResults(@Nullable Boolean flattenResults) {
            this.flattenResults = flattenResults;
            return this;
        }

        @Override
        BigQueryIO.Read.Builder setUseLegacySql(@Nullable Boolean useLegacySql) {
            this.useLegacySql = useLegacySql;
            return this;
        }

        @Override
        BigQueryIO.Read.Builder setBigQueryServices(BigQueryServices bigQueryServices) {
            if (bigQueryServices == null) {
                throw new NullPointerException("Null bigQueryServices");
            }
            this.bigQueryServices = bigQueryServices;
            return this;
        }

        @Override
        BigQueryIO.Read build() {
            String missing = "";
            if (this.validate == null) {
                missing = missing + " validate";
            }
            if (this.bigQueryServices == null) {
                missing = missing + " bigQueryServices";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_BigQueryIO_Read(this.jsonTableRef, this.query, this.validate, this.flattenResults, this.useLegacySql, this.bigQueryServices);
        }
    }
}

