/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableReference;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;

public class TableDestination
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String tableSpec;
    @Nullable
    private final String tableDescription;

    public TableDestination(String tableSpec, @Nullable String tableDescription) {
        this.tableSpec = tableSpec;
        this.tableDescription = tableDescription;
    }

    public TableDestination(TableReference tableReference, @Nullable String tableDescription) {
        this.tableSpec = BigQueryHelpers.toTableSpec(tableReference);
        this.tableDescription = tableDescription;
    }

    public String getTableSpec() {
        return this.tableSpec;
    }

    public TableReference getTableReference() {
        return BigQueryHelpers.parseTableSpec(this.tableSpec);
    }

    @Nullable
    public String getTableDescription() {
        return this.tableDescription;
    }

    public String toString() {
        String toString = "tableSpec: " + this.tableSpec;
        if (this.tableDescription != null) {
            toString = toString + " tableDescription: " + this.tableDescription;
        }
        return toString;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TableDestination)) {
            return false;
        }
        TableDestination other = (TableDestination)o;
        return Objects.equals(this.tableSpec, other.tableSpec) && Objects.equals(this.tableDescription, other.tableDescription);
    }

    public int hashCode() {
        return Objects.hash(this.tableSpec, this.tableDescription);
    }
}

