/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

class BigQueryAvroUtils {
    private static final DateTimeFormatter DATE_AND_SECONDS_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss").withZoneUTC();

    BigQueryAvroUtils() {
    }

    static String formatTimestamp(String timestamp) {
        double timestampDoubleMicros = Double.parseDouble(timestamp) * 1000000.0;
        long timestampMicros = (long)timestampDoubleMicros;
        long seconds = timestampMicros / 1000000L;
        int micros = (int)(timestampMicros % 1000000L);
        String dayAndTime = DATE_AND_SECONDS_FORMATTER.print(seconds * 1000L);
        if (micros == 0) {
            return String.format("%s UTC", dayAndTime);
        }
        int digits = 6;
        int subsecond = micros;
        while (subsecond % 10 == 0) {
            --digits;
            subsecond /= 10;
        }
        String formatString = String.format("%%0%dd", digits);
        String fractionalSeconds = String.format(formatString, subsecond);
        return String.format("%s.%s UTC", dayAndTime, fractionalSeconds);
    }

    static TableRow convertGenericRecordToTableRow(GenericRecord record, TableSchema schema) {
        return BigQueryAvroUtils.convertGenericRecordToTableRow(record, schema.getFields());
    }

    private static TableRow convertGenericRecordToTableRow(GenericRecord record, List<TableFieldSchema> fields) {
        TableRow row = new TableRow();
        for (TableFieldSchema subSchema : fields) {
            Schema.Field field = record.getSchema().getField(subSchema.getName());
            Object convertedValue = BigQueryAvroUtils.getTypedCellValue(field.schema(), subSchema, record.get(field.name()));
            if (convertedValue == null) continue;
            row.set(field.name(), convertedValue);
        }
        return row;
    }

    @Nullable
    private static Object getTypedCellValue(Schema schema, TableFieldSchema fieldSchema, Object v) {
        String mode;
        switch (mode = (String)MoreObjects.firstNonNull((Object)fieldSchema.getMode(), (Object)"NULLABLE")) {
            case "REQUIRED": {
                return BigQueryAvroUtils.convertRequiredField(schema.getType(), fieldSchema, v);
            }
            case "REPEATED": {
                return BigQueryAvroUtils.convertRepeatedField(schema, fieldSchema, v);
            }
            case "NULLABLE": {
                return BigQueryAvroUtils.convertNullableField(schema, fieldSchema, v);
            }
        }
        throw new UnsupportedOperationException("Parsing a field with BigQuery field schema mode " + fieldSchema.getMode());
    }

    private static List<Object> convertRepeatedField(Schema schema, TableFieldSchema fieldSchema, Object v) {
        Schema.Type arrayType = schema.getType();
        Verify.verify((arrayType == Schema.Type.ARRAY ? 1 : 0) != 0, (String)"BigQuery REPEATED field %s should be Avro ARRAY, not %s", (Object[])new Object[]{fieldSchema.getName(), arrayType});
        if (v == null) {
            return ImmutableList.of();
        }
        List elements = (List)v;
        ImmutableList.Builder values = ImmutableList.builder();
        Schema.Type elementType = schema.getElementType().getType();
        for (Object element : elements) {
            values.add(BigQueryAvroUtils.convertRequiredField(elementType, fieldSchema, element));
        }
        return values.build();
    }

    private static Object convertRequiredField(Schema.Type avroType, TableFieldSchema fieldSchema, Object v) {
        Preconditions.checkNotNull((Object)v, (String)"REQUIRED field %s should not be null", (Object[])new Object[]{fieldSchema.getName()});
        ImmutableMap fieldMap = ImmutableMap.builder().put((Object)"STRING", (Object)Schema.Type.STRING).put((Object)"INTEGER", (Object)Schema.Type.LONG).put((Object)"FLOAT", (Object)Schema.Type.DOUBLE).put((Object)"BOOLEAN", (Object)Schema.Type.BOOLEAN).put((Object)"TIMESTAMP", (Object)Schema.Type.LONG).put((Object)"RECORD", (Object)Schema.Type.RECORD).build();
        String bqType = fieldSchema.getType();
        Schema.Type expectedAvroType = (Schema.Type)fieldMap.get((Object)bqType);
        Verify.verify((avroType == expectedAvroType ? 1 : 0) != 0, (String)"Expected Avro schema type %s, not %s, for BigQuery %s field %s", (Object[])new Object[]{expectedAvroType, avroType, bqType, fieldSchema.getName()});
        switch (fieldSchema.getType()) {
            case "STRING": {
                Verify.verify((boolean)(v instanceof CharSequence), (String)"Expected CharSequence (String), got %s", (Object[])new Object[]{v.getClass()});
                return v.toString();
            }
            case "INTEGER": {
                Verify.verify((boolean)(v instanceof Long), (String)"Expected Long, got %s", (Object[])new Object[]{v.getClass()});
                return ((Long)v).toString();
            }
            case "FLOAT": {
                Verify.verify((boolean)(v instanceof Double), (String)"Expected Double, got %s", (Object[])new Object[]{v.getClass()});
                return v;
            }
            case "BOOLEAN": {
                Verify.verify((boolean)(v instanceof Boolean), (String)"Expected Boolean, got %s", (Object[])new Object[]{v.getClass()});
                return v;
            }
            case "TIMESTAMP": {
                Verify.verify((boolean)(v instanceof Long), (String)"Expected Long, got %s", (Object[])new Object[]{v.getClass()});
                Double doubleValue = (double)((Long)v).longValue() / 1000000.0;
                return BigQueryAvroUtils.formatTimestamp(doubleValue.toString());
            }
            case "RECORD": {
                Verify.verify((boolean)(v instanceof GenericRecord), (String)"Expected GenericRecord, got %s", (Object[])new Object[]{v.getClass()});
                return BigQueryAvroUtils.convertGenericRecordToTableRow((GenericRecord)v, fieldSchema.getFields());
            }
        }
        throw new UnsupportedOperationException(String.format("Unexpected BigQuery field schema type %s for field named %s", fieldSchema.getType(), fieldSchema.getName()));
    }

    @Nullable
    private static Object convertNullableField(Schema avroSchema, TableFieldSchema fieldSchema, Object v) {
        Verify.verify((avroSchema.getType() == Schema.Type.UNION ? 1 : 0) != 0, (String)"Expected Avro schema type UNION, not %s, for BigQuery NULLABLE field %s", (Object[])new Object[]{avroSchema.getType(), fieldSchema.getName()});
        List unionTypes = avroSchema.getTypes();
        Verify.verify((unionTypes.size() == 2 ? 1 : 0) != 0, (String)"BigQuery NULLABLE field %s should be an Avro UNION of NULL and another type, not %s", (Object[])new Object[]{fieldSchema.getName(), unionTypes});
        if (v == null) {
            return null;
        }
        Schema.Type firstType = ((Schema)unionTypes.get(0)).getType();
        if (!firstType.equals((Object)Schema.Type.NULL)) {
            return BigQueryAvroUtils.convertRequiredField(firstType, fieldSchema, v);
        }
        return BigQueryAvroUtils.convertRequiredField(((Schema)unionTypes.get(1)).getType(), fieldSchema, v);
    }
}

