/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.elasticsearch;

import org.apache.beam.sdk.io.elasticsearch.ElasticsearchIO;
import org.apache.beam.sdk.options.ValueProvider;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_ElasticsearchIO_Read
extends ElasticsearchIO.Read {
    private final @Nullable ElasticsearchIO.ConnectionConfiguration connectionConfiguration;
    private final @Nullable ValueProvider<String> query;
    private final boolean withMetadata;
    private final String scrollKeepalive;
    private final long batchSize;
    private final boolean usePITSearch;
    private final @Nullable String PITSortConfig;
    private final @Nullable String PITSortTimestampProperty;

    private AutoValue_ElasticsearchIO_Read(@Nullable ElasticsearchIO.ConnectionConfiguration connectionConfiguration, @Nullable ValueProvider<String> query, boolean withMetadata, String scrollKeepalive, long batchSize, boolean usePITSearch, @Nullable String PITSortConfig, @Nullable String PITSortTimestampProperty) {
        this.connectionConfiguration = connectionConfiguration;
        this.query = query;
        this.withMetadata = withMetadata;
        this.scrollKeepalive = scrollKeepalive;
        this.batchSize = batchSize;
        this.usePITSearch = usePITSearch;
        this.PITSortConfig = PITSortConfig;
        this.PITSortTimestampProperty = PITSortTimestampProperty;
    }

    @Override
    @Nullable ElasticsearchIO.ConnectionConfiguration getConnectionConfiguration() {
        return this.connectionConfiguration;
    }

    @Override
    @Nullable ValueProvider<String> getQuery() {
        return this.query;
    }

    @Override
    boolean isWithMetadata() {
        return this.withMetadata;
    }

    @Override
    String getScrollKeepalive() {
        return this.scrollKeepalive;
    }

    @Override
    long getBatchSize() {
        return this.batchSize;
    }

    @Override
    boolean getUsePITSearch() {
        return this.usePITSearch;
    }

    @Override
    @Nullable String getPITSortConfig() {
        return this.PITSortConfig;
    }

    @Override
    @Nullable String getPITSortTimestampProperty() {
        return this.PITSortTimestampProperty;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ElasticsearchIO.Read) {
            ElasticsearchIO.Read that = (ElasticsearchIO.Read)((Object)o);
            return (this.connectionConfiguration == null ? that.getConnectionConfiguration() == null : this.connectionConfiguration.equals(that.getConnectionConfiguration())) && (this.query == null ? that.getQuery() == null : this.query.equals(that.getQuery())) && this.withMetadata == that.isWithMetadata() && this.scrollKeepalive.equals(that.getScrollKeepalive()) && this.batchSize == that.getBatchSize() && this.usePITSearch == that.getUsePITSearch() && (this.PITSortConfig == null ? that.getPITSortConfig() == null : this.PITSortConfig.equals(that.getPITSortConfig())) && (this.PITSortTimestampProperty == null ? that.getPITSortTimestampProperty() == null : this.PITSortTimestampProperty.equals(that.getPITSortTimestampProperty()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.connectionConfiguration == null ? 0 : this.connectionConfiguration.hashCode();
        h$ *= 1000003;
        h$ ^= this.query == null ? 0 : this.query.hashCode();
        h$ *= 1000003;
        h$ ^= this.withMetadata ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.scrollKeepalive.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.batchSize >>> 32 ^ this.batchSize);
        h$ *= 1000003;
        h$ ^= this.usePITSearch ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.PITSortConfig == null ? 0 : this.PITSortConfig.hashCode();
        h$ *= 1000003;
        return h$ ^= this.PITSortTimestampProperty == null ? 0 : this.PITSortTimestampProperty.hashCode();
    }

    @Override
    ElasticsearchIO.Read.Builder builder() {
        return new Builder(this);
    }

    static final class Builder
    extends ElasticsearchIO.Read.Builder {
        private @Nullable ElasticsearchIO.ConnectionConfiguration connectionConfiguration;
        private @Nullable ValueProvider<String> query;
        private Boolean withMetadata;
        private String scrollKeepalive;
        private Long batchSize;
        private Boolean usePITSearch;
        private @Nullable String PITSortConfig;
        private @Nullable String PITSortTimestampProperty;

        Builder() {
        }

        private Builder(ElasticsearchIO.Read source) {
            this.connectionConfiguration = source.getConnectionConfiguration();
            this.query = source.getQuery();
            this.withMetadata = source.isWithMetadata();
            this.scrollKeepalive = source.getScrollKeepalive();
            this.batchSize = source.getBatchSize();
            this.usePITSearch = source.getUsePITSearch();
            this.PITSortConfig = source.getPITSortConfig();
            this.PITSortTimestampProperty = source.getPITSortTimestampProperty();
        }

        @Override
        ElasticsearchIO.Read.Builder setConnectionConfiguration(ElasticsearchIO.ConnectionConfiguration connectionConfiguration) {
            this.connectionConfiguration = connectionConfiguration;
            return this;
        }

        @Override
        ElasticsearchIO.Read.Builder setQuery(ValueProvider<String> query) {
            this.query = query;
            return this;
        }

        @Override
        ElasticsearchIO.Read.Builder setWithMetadata(boolean withMetadata) {
            this.withMetadata = withMetadata;
            return this;
        }

        @Override
        ElasticsearchIO.Read.Builder setScrollKeepalive(String scrollKeepalive) {
            if (scrollKeepalive == null) {
                throw new NullPointerException("Null scrollKeepalive");
            }
            this.scrollKeepalive = scrollKeepalive;
            return this;
        }

        @Override
        ElasticsearchIO.Read.Builder setBatchSize(long batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        @Override
        ElasticsearchIO.Read.Builder setUsePITSearch(boolean usePITSearch) {
            this.usePITSearch = usePITSearch;
            return this;
        }

        @Override
        ElasticsearchIO.Read.Builder setPITSortConfig(String PITSortConfig) {
            this.PITSortConfig = PITSortConfig;
            return this;
        }

        @Override
        ElasticsearchIO.Read.Builder setPITSortTimestampProperty(String PITSortTimestampProperty) {
            this.PITSortTimestampProperty = PITSortTimestampProperty;
            return this;
        }

        @Override
        ElasticsearchIO.Read build() {
            if (this.withMetadata == null || this.scrollKeepalive == null || this.batchSize == null || this.usePITSearch == null) {
                StringBuilder missing = new StringBuilder();
                if (this.withMetadata == null) {
                    missing.append(" withMetadata");
                }
                if (this.scrollKeepalive == null) {
                    missing.append(" scrollKeepalive");
                }
                if (this.batchSize == null) {
                    missing.append(" batchSize");
                }
                if (this.usePITSearch == null) {
                    missing.append(" usePITSearch");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ElasticsearchIO_Read(this.connectionConfiguration, this.query, this.withMetadata, this.scrollKeepalive, this.batchSize, this.usePITSearch, this.PITSortConfig, this.PITSortTimestampProperty);
        }
    }
}

