/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.elasticsearch;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.auto.value.AutoValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLContext;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.BooleanCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.elasticsearch.AutoValue_ElasticsearchIO_BulkIO;
import org.apache.beam.sdk.io.elasticsearch.AutoValue_ElasticsearchIO_ConnectionConfiguration;
import org.apache.beam.sdk.io.elasticsearch.AutoValue_ElasticsearchIO_DocToBulk;
import org.apache.beam.sdk.io.elasticsearch.AutoValue_ElasticsearchIO_Document;
import org.apache.beam.sdk.io.elasticsearch.AutoValue_ElasticsearchIO_Read;
import org.apache.beam.sdk.io.elasticsearch.AutoValue_ElasticsearchIO_RetryConfiguration;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupIntoBatches;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.BackOffUtils;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Streams;
import org.apache.http.ConnectionClosedException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class ElasticsearchIO {
    private static final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> VALID_CLUSTER_VERSIONS = Arrays.asList(5, 6, 7, 8);
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Integer> DEPRECATED_CLUSTER_VERSIONS = new HashSet<Integer>(Arrays.asList(5, 6));
    private static final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> VERSION_TYPES = Arrays.asList("internal", "external", "external_gt", "external_gte");
    private static final @UnknownKeyFor @NonNull @Initialized String VERSION_CONFLICT_ERROR = "version_conflict_engine_exception";
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ElasticsearchIO.class);
    private static final @UnknownKeyFor @NonNull @Initialized ObjectMapper mapper = new ObjectMapper();

    public static @UnknownKeyFor @NonNull @Initialized Read read() {
        return new AutoValue_ElasticsearchIO_Read.Builder().setWithMetadata(false).setScrollKeepalive("5m").setBatchSize(100L).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized DocToBulk docToBulk() {
        return new AutoValue_ElasticsearchIO_DocToBulk.Builder().build();
    }

    public static @UnknownKeyFor @NonNull @Initialized BulkIO bulkIO() {
        return new AutoValue_ElasticsearchIO_BulkIO.Builder().setMaxBatchSize(1000L).setMaxBatchSizeBytes(0x500000L).setUseStatefulBatches(false).setMaxParallelRequests(1).setThrowWriteErrors(true).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Write write() {
        return new Write();
    }

    private ElasticsearchIO() {
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized JsonNode parseResponse(@UnknownKeyFor @NonNull @Initialized HttpEntity responseEntity) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return (JsonNode)mapper.readValue(responseEntity.getContent(), JsonNode.class);
    }

    static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Document> createWriteReport(@UnknownKeyFor @NonNull @Initialized HttpEntity responseEntity, @Nullable @UnknownKeyFor @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> allowedErrorTypes, @UnknownKeyFor @NonNull @Initialized boolean throwWriteErrors) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ArrayList<Document> responses = new ArrayList<Document>();
        int numErrors = 0;
        JsonNode searchResult = ElasticsearchIO.parseResponse(responseEntity);
        StringBuilder errorMessages = new StringBuilder("Error writing to Elasticsearch, some elements could not be inserted:");
        JsonNode items = searchResult.path("items");
        if (items.isMissingNode() || items.size() == 0) {
            errorMessages.append(searchResult);
            LOG.warn("'items' missing from Elasticsearch response: {}", (Object)errorMessages);
        }
        for (JsonNode item : items) {
            Document result = Document.create().withResponseItemJson(item.toString());
            JsonNode error = item.findValue("error");
            if (error != null) {
                String type = error.path("type").asText();
                String reason = error.path("reason").asText();
                String docId = item.findValue("_id").asText();
                JsonNode causedBy = error.path("caused_by");
                String cbReason = causedBy.path("reason").asText();
                String cbType = causedBy.path("type").asText();
                if (allowedErrorTypes == null || !allowedErrorTypes.contains(type) && !allowedErrorTypes.contains(cbType)) {
                    result = result.withHasError(true);
                    ++numErrors;
                    errorMessages.append(String.format("%nDocument id %s: %s (%s)", docId, reason, type));
                    if (!causedBy.isMissingNode()) {
                        errorMessages.append(String.format("%nCaused by: %s (%s)", cbReason, cbType));
                    }
                }
            }
            responses.add(result);
        }
        if (numErrors > 0) {
            LOG.error(errorMessages.toString());
            if (throwWriteErrors) {
                throw new IOException(errorMessages.toString());
            }
        }
        return responses;
    }

    private static void maybeLogVersionDeprecationWarning(@UnknownKeyFor @NonNull @Initialized int clusterVersion) {
        if (DEPRECATED_CLUSTER_VERSIONS.contains(clusterVersion)) {
            LOG.warn("Support for Elasticsearch cluster version {} will be dropped in a future release of the Apache Beam SDK", (Object)clusterVersion);
        }
    }

    static @UnknownKeyFor @NonNull @Initialized int getBackendVersion(@UnknownKeyFor @NonNull @Initialized RestClient restClient) {
        try {
            Request request = new Request("GET", "");
            Response response = restClient.performRequest(request);
            JsonNode jsonNode = ElasticsearchIO.parseResponse(response.getEntity());
            int backendVersion = Integer.parseInt(jsonNode.path("version").path("number").asText().substring(0, 1));
            Preconditions.checkArgument((boolean)VALID_CLUSTER_VERSIONS.contains(backendVersion), (String)("The Elasticsearch version to connect to is %s.x. This version of the ElasticsearchIO is only compatible with Elasticsearch " + VALID_CLUSTER_VERSIONS), (int)backendVersion);
            ElasticsearchIO.maybeLogVersionDeprecationWarning(backendVersion);
            return backendVersion;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot get Elasticsearch version", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static @UnknownKeyFor @NonNull @Initialized int getBackendVersion(@UnknownKeyFor @NonNull @Initialized ConnectionConfiguration connectionConfiguration) {
        try (RestClient restClient = connectionConfiguration.createClient();){
            int n = ElasticsearchIO.getBackendVersion(restClient);
            return n;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot get Elasticsearch version", e);
        }
    }

    @AutoValue
    public static abstract class BulkIO
    extends PTransform<PCollection<Document>, PCollectionTuple> {
        @VisibleForTesting
        static final @UnknownKeyFor @NonNull @Initialized String RETRY_ATTEMPT_LOG = "Error writing to Elasticsearch. Retry attempt[{}]";
        @VisibleForTesting
        static final @UnknownKeyFor @NonNull @Initialized String RETRY_FAILED_LOG = "Error writing to ES after %d attempt(s). No more attempts allowed";

        abstract @Nullable @UnknownKeyFor @Initialized ConnectionConfiguration getConnectionConfiguration();

        abstract @UnknownKeyFor @NonNull @Initialized long getMaxBatchSize();

        abstract @UnknownKeyFor @NonNull @Initialized long getMaxBatchSizeBytes();

        abstract @Nullable @UnknownKeyFor @Initialized Duration getMaxBufferingDuration();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getUseStatefulBatches();

        abstract @Nullable @UnknownKeyFor @Initialized Integer getMaxParallelRequestsPerWindow();

        abstract @UnknownKeyFor @NonNull @Initialized int getMaxParallelRequests();

        abstract @Nullable @UnknownKeyFor @Initialized RetryConfiguration getRetryConfiguration();

        abstract @Nullable @UnknownKeyFor @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getAllowedResponseErrors();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getThrowWriteErrors();

        abstract @UnknownKeyFor @NonNull @Initialized Builder builder();

        public @UnknownKeyFor @NonNull @Initialized BulkIO withConnectionConfiguration(@UnknownKeyFor @NonNull @Initialized ConnectionConfiguration connectionConfiguration) {
            Preconditions.checkArgument((connectionConfiguration != null ? 1 : 0) != 0, (Object)"connectionConfiguration can not be null");
            return this.builder().setConnectionConfiguration(connectionConfiguration).build();
        }

        public @UnknownKeyFor @NonNull @Initialized BulkIO withMaxBatchSize(@UnknownKeyFor @NonNull @Initialized long batchSize) {
            Preconditions.checkArgument((batchSize > 0L ? 1 : 0) != 0, (String)"batchSize must be > 0, but was %s", (long)batchSize);
            return this.builder().setMaxBatchSize(batchSize).build();
        }

        public @UnknownKeyFor @NonNull @Initialized BulkIO withMaxBatchSizeBytes(@UnknownKeyFor @NonNull @Initialized long batchSizeBytes) {
            Preconditions.checkArgument((batchSizeBytes > 0L ? 1 : 0) != 0, (String)"batchSizeBytes must be > 0, but was %s", (long)batchSizeBytes);
            return this.builder().setMaxBatchSizeBytes(batchSizeBytes).build();
        }

        public @UnknownKeyFor @NonNull @Initialized BulkIO withRetryConfiguration(@UnknownKeyFor @NonNull @Initialized RetryConfiguration retryConfiguration) {
            Preconditions.checkArgument((retryConfiguration != null ? 1 : 0) != 0, (Object)"retryConfiguration is required");
            return this.builder().setRetryConfiguration(retryConfiguration).build();
        }

        public @UnknownKeyFor @NonNull @Initialized BulkIO withIgnoreVersionConflicts(@UnknownKeyFor @NonNull @Initialized boolean ignoreVersionConflicts) {
            Set<String> allowedResponseErrors = this.getAllowedResponseErrors();
            if (allowedResponseErrors == null) {
                allowedResponseErrors = new HashSet<String>();
            }
            if (ignoreVersionConflicts) {
                allowedResponseErrors.add(ElasticsearchIO.VERSION_CONFLICT_ERROR);
            }
            return this.builder().setAllowedResponseErrors(allowedResponseErrors).build();
        }

        public @UnknownKeyFor @NonNull @Initialized BulkIO withAllowableResponseErrors(@Nullable @UnknownKeyFor @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> allowableResponseErrorTypes) {
            if (allowableResponseErrorTypes == null) {
                allowableResponseErrorTypes = new HashSet<String>();
            }
            return this.builder().setAllowedResponseErrors(allowableResponseErrorTypes).build();
        }

        public @UnknownKeyFor @NonNull @Initialized BulkIO withMaxBufferingDuration(@UnknownKeyFor @NonNull @Initialized Duration maxBufferingDuration) {
            LOG.warn("Use of withMaxBufferingDuration requires withUseStatefulBatches(true). Setting that automatically.");
            return this.builder().setUseStatefulBatches(true).setMaxBufferingDuration(maxBufferingDuration).build();
        }

        public @UnknownKeyFor @NonNull @Initialized BulkIO withUseStatefulBatches(@UnknownKeyFor @NonNull @Initialized boolean useStatefulBatches) {
            return this.builder().setUseStatefulBatches(useStatefulBatches).build();
        }

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized BulkIO withMaxParallelRequestsPerWindow(@UnknownKeyFor @NonNull @Initialized int maxParallelRequests) {
            Preconditions.checkArgument((maxParallelRequests > 0 ? 1 : 0) != 0, (Object)"maxParallelRequestsPerWindow value must be a positive integer");
            return this.builder().setMaxParallelRequests(maxParallelRequests).build();
        }

        public @UnknownKeyFor @NonNull @Initialized BulkIO withMaxParallelRequests(@UnknownKeyFor @NonNull @Initialized int maxParallelRequests) {
            Preconditions.checkArgument((maxParallelRequests > 0 ? 1 : 0) != 0, (Object)"maxParallelRequests value must be a positive integer");
            return this.builder().setMaxParallelRequests(maxParallelRequests).build();
        }

        public @UnknownKeyFor @NonNull @Initialized BulkIO withThrowWriteErrors(@UnknownKeyFor @NonNull @Initialized boolean throwWriteErrors) {
            return this.builder().setThrowWriteErrors(throwWriteErrors).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionTuple expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Document> input) {
            ConnectionConfiguration connectionConfiguration = this.getConnectionConfiguration();
            Preconditions.checkState((connectionConfiguration != null ? 1 : 0) != 0, (Object)"withConnectionConfiguration() is required");
            WindowFn originalWindowFn = input.getWindowingStrategy().getWindowFn();
            PCollection globalDocs = (PCollection)input.apply("Window inputs globally", (PTransform)Window.into((WindowFn)new GlobalWindows()));
            PCollection docResults = this.getUseStatefulBatches() ? (PCollection)((PCollection)globalDocs.apply((PTransform)StatefulBatching.fromSpec(this))).apply((PTransform)ParDo.of((DoFn)new BulkIOStatefulFn(this))) : (PCollection)globalDocs.apply((PTransform)ParDo.of((DoFn)new BulkIOBundleFn(this)));
            return (PCollectionTuple)((PCollection)docResults.apply("Restore original windows", (PTransform)Window.into((WindowFn)originalWindowFn))).apply((PTransform)ParDo.of((DoFn)new ResultFilteringFn()).withOutputTags(Write.SUCCESSFUL_WRITES, TupleTagList.of(Write.FAILED_WRITES)));
        }

        @VisibleForTesting
        private static abstract class BulkIOBaseFn<@UnknownKeyFor T>
        extends DoFn<T, Document> {
            private static final @UnknownKeyFor @NonNull @Initialized Duration RETRY_INITIAL_BACKOFF = Duration.standardSeconds((long)5L);
            private transient @UnknownKeyFor @NonNull @Initialized FluentBackoff retryBackoff;
            private @UnknownKeyFor @NonNull @Initialized BulkIO spec;
            private transient @UnknownKeyFor @NonNull @Initialized RestClient restClient;
            private transient @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Document> batch;
            @UnknownKeyFor @NonNull @Initialized long currentBatchSizeBytes;

            protected BulkIOBaseFn(@UnknownKeyFor @NonNull @Initialized BulkIO bulkSpec) {
                this.spec = bulkSpec;
            }

            public @UnknownKeyFor @NonNull @Initialized Duration getAllowedTimestampSkew() {
                return Duration.millis((long)Long.MAX_VALUE);
            }

            @DoFn.Setup
            public void setup() throws @UnknownKeyFor @NonNull @Initialized IOException {
                ConnectionConfiguration connectionConfiguration = this.spec.getConnectionConfiguration();
                this.restClient = connectionConfiguration.createClient();
                this.retryBackoff = FluentBackoff.DEFAULT.withMaxRetries(0).withInitialBackoff(RETRY_INITIAL_BACKOFF);
                if (this.spec.getRetryConfiguration() != null) {
                    this.retryBackoff = FluentBackoff.DEFAULT.withInitialBackoff(RETRY_INITIAL_BACKOFF).withMaxRetries(this.spec.getRetryConfiguration().getMaxAttempts() - 1).withMaxCumulativeBackoff(this.spec.getRetryConfiguration().getMaxDuration());
                }
            }

            @DoFn.StartBundle
            public void startBundle(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized StartBundleContext context) {
                this.batch = new ArrayList<Document>();
                this.currentBatchSizeBytes = 0L;
            }

            @DoFn.FinishBundle
            public void finishBundle(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext context) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
                this.flushAndOutputResults(new FinishBundleContextAdapter(context));
            }

            private void flushAndOutputResults(@UnknownKeyFor @NonNull @Initialized ContextAdapter context) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
                for (Document timedDoc : this.flushBatch()) {
                    context.output(timedDoc);
                }
            }

            protected void addAndMaybeFlush(@UnknownKeyFor @NonNull @Initialized Document doc, /*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
                this.batch.add(doc);
                this.currentBatchSizeBytes += (long)doc.getBulkDirective().getBytes(StandardCharsets.UTF_8).length;
                if ((long)this.batch.size() >= this.spec.getMaxBatchSize() || this.currentBatchSizeBytes >= this.spec.getMaxBatchSizeBytes()) {
                    this.flushAndOutputResults(new ProcessContextAdapter(context));
                }
            }

            private @UnknownKeyFor @NonNull @Initialized boolean isRetryableClientException(@UnknownKeyFor @NonNull @Initialized Throwable t) {
                return t.getCause() instanceof ConnectTimeoutException || t.getCause() instanceof SocketTimeoutException || t.getCause() instanceof ConnectionClosedException || t.getCause() instanceof ConnectException;
            }

            private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Document> flushBatch() throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
                if (this.batch.isEmpty()) {
                    return new ArrayList<Document>();
                }
                LOG.debug("ElasticsearchIO batch size: {}, batch size bytes: {}", (Object)this.batch.size(), (Object)this.currentBatchSizeBytes);
                StringBuilder bulkRequest = new StringBuilder();
                ArrayList<Document> inputEntries = new ArrayList<Document>(this.batch);
                this.batch.clear();
                this.currentBatchSizeBytes = 0L;
                for (Document doc : inputEntries) {
                    bulkRequest.append(doc.getBulkDirective());
                }
                Response response = null;
                BufferedHttpEntity responseEntity = null;
                String endPoint = this.spec.getConnectionConfiguration().getBulkEndPoint();
                NStringEntity requestBody = new NStringEntity(bulkRequest.toString(), ContentType.APPLICATION_JSON);
                try {
                    Request request = new Request("POST", endPoint);
                    request.addParameters(Collections.emptyMap());
                    request.setEntity((HttpEntity)requestBody);
                    response = this.restClient.performRequest(request);
                    responseEntity = new BufferedHttpEntity(response.getEntity());
                }
                catch (IOException ex) {
                    if (this.spec.getRetryConfiguration() == null || !this.isRetryableClientException(ex)) {
                        throw ex;
                    }
                    LOG.error("Caught ES timeout, retrying", (Throwable)ex);
                }
                if (this.spec.getRetryConfiguration() != null && (response == null || responseEntity == null || this.spec.getRetryConfiguration().getRetryPredicate().test(responseEntity))) {
                    if (responseEntity != null && this.spec.getRetryConfiguration().getRetryPredicate().test(responseEntity)) {
                        LOG.warn("ES Cluster is responding with HTP 429 - TOO_MANY_REQUESTS.");
                    }
                    responseEntity = this.handleRetry("POST", endPoint, Collections.emptyMap(), (HttpEntity)requestBody);
                }
                List<Document> responses = ElasticsearchIO.createWriteReport((HttpEntity)responseEntity, this.spec.getAllowedResponseErrors(), this.spec.getThrowWriteErrors());
                return Streams.zip(inputEntries.stream(), responses.stream(), (inputTimedDoc, responseDoc) -> inputTimedDoc.withHasError(responseDoc.getHasError()).withResponseItemJson(responseDoc.getResponseItemJson())).collect(Collectors.toList());
            }

            private @UnknownKeyFor @NonNull @Initialized HttpEntity handleRetry(@UnknownKeyFor @NonNull @Initialized String method, @UnknownKeyFor @NonNull @Initialized String endpoint, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> params, @UnknownKeyFor @NonNull @Initialized HttpEntity requestBody) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
                BufferedHttpEntity responseEntity = null;
                Sleeper sleeper = Sleeper.DEFAULT;
                BackOff backoff = this.retryBackoff.backoff();
                int attempt = 0;
                while (BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff)) {
                    block4: {
                        LOG.warn(BulkIO.RETRY_ATTEMPT_LOG, (Object)(++attempt));
                        try {
                            Request request = new Request(method, endpoint);
                            request.addParameters(params);
                            request.setEntity(requestBody);
                            Response response = this.restClient.performRequest(request);
                            responseEntity = new BufferedHttpEntity(response.getEntity());
                        }
                        catch (IOException ex) {
                            if (!this.isRetryableClientException(ex)) break block4;
                            LOG.error("Caught ES timeout, retrying", (Throwable)ex);
                            continue;
                        }
                    }
                    if (!Objects.requireNonNull(this.spec.getRetryConfiguration()).getRetryPredicate().test(responseEntity)) {
                        return responseEntity;
                    }
                    LOG.warn("ES Cluster is responding with HTP 429 - TOO_MANY_REQUESTS.");
                }
                throw new IOException(String.format(BulkIO.RETRY_FAILED_LOG, attempt));
            }

            @DoFn.Teardown
            public void closeClient() throws @UnknownKeyFor @NonNull @Initialized IOException {
                if (this.restClient != null) {
                    this.restClient.close();
                }
            }

            private static final class FinishBundleContextAdapter<@UnknownKeyFor T>
            implements ContextAdapter {
                private final /*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext context;

                private FinishBundleContextAdapter(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext context) {
                    this.context = context;
                }

                @Override
                public void output(@UnknownKeyFor @NonNull @Initialized Document timedDoc) {
                    this.context.output((Object)timedDoc, timedDoc.getTimestamp(), (BoundedWindow)GlobalWindow.INSTANCE);
                }
            }

            private static final class ProcessContextAdapter<@UnknownKeyFor T>
            implements ContextAdapter {
                private final /*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context;

                private ProcessContextAdapter(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) {
                    this.context = context;
                }

                @Override
                public void output(@UnknownKeyFor @NonNull @Initialized Document timedDoc) {
                    this.context.outputWithTimestamp((Object)timedDoc, timedDoc.getTimestamp());
                }
            }

            static interface ContextAdapter {
                public void output(@UnknownKeyFor @NonNull @Initialized Document var1);
            }
        }

        static class BulkIOStatefulFn
        extends BulkIOBaseFn<KV<Integer, Iterable<Document>>> {
            @VisibleForTesting
            BulkIOStatefulFn(@UnknownKeyFor @NonNull @Initialized BulkIO bulkSpec) {
                super(bulkSpec);
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
                for (Document timedDoc : (Iterable)((KV)context.element()).getValue()) {
                    this.addAndMaybeFlush(timedDoc, context);
                }
            }
        }

        static class BulkIOBundleFn
        extends BulkIOBaseFn<Document> {
            @VisibleForTesting
            BulkIOBundleFn(@UnknownKeyFor @NonNull @Initialized BulkIO bulkSpec) {
                super(bulkSpec);
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
                this.addAndMaybeFlush((Document)context.element(), context);
            }
        }

        private static class ResultFilteringFn
        extends DoFn<Document, Document> {
            private ResultFilteringFn() {
            }

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Document doc, // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver out) {
                if (doc.getHasError().booleanValue()) {
                    out.get(Write.FAILED_WRITES).output((Object)doc);
                } else {
                    out.get(Write.SUCCESSFUL_WRITES).output((Object)doc);
                }
            }
        }

        @VisibleForTesting
        static class StatefulBatching
        extends PTransform<PCollection<Document>, PCollection<KV<Integer, Iterable<Document>>>> {
            final @UnknownKeyFor @NonNull @Initialized BulkIO spec;

            private StatefulBatching(@UnknownKeyFor @NonNull @Initialized BulkIO bulkSpec) {
                this.spec = bulkSpec;
            }

            public static @UnknownKeyFor @NonNull @Initialized StatefulBatching fromSpec(@UnknownKeyFor @NonNull @Initialized BulkIO spec) {
                return new StatefulBatching(spec);
            }

            public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Document>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Document> input) {
                GroupIntoBatches groupIntoBatches = GroupIntoBatches.ofSize((long)this.spec.getMaxBatchSize());
                if (this.spec.getMaxBufferingDuration() != null) {
                    groupIntoBatches = groupIntoBatches.withMaxBufferingDuration(this.spec.getMaxBufferingDuration());
                }
                return (PCollection)((PCollection)input.apply((PTransform)ParDo.of((DoFn)new Reshuffle.AssignShardFn(Integer.valueOf(this.spec.getMaxParallelRequests()))))).apply((PTransform)groupIntoBatches);
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setConnectionConfiguration(@UnknownKeyFor @NonNull @Initialized ConnectionConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxBatchSize(@UnknownKeyFor @NonNull @Initialized long var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxBatchSizeBytes(@UnknownKeyFor @NonNull @Initialized long var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setRetryConfiguration(@UnknownKeyFor @NonNull @Initialized RetryConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setAllowedResponseErrors(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxBufferingDuration(@UnknownKeyFor @NonNull @Initialized Duration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setUseStatefulBatches(@UnknownKeyFor @NonNull @Initialized boolean var1);

            @Deprecated
            abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxParallelRequestsPerWindow(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxParallelRequests(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setThrowWriteErrors(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized BulkIO build();
        }
    }

    public static class Write
    extends PTransform<PCollection<String>, PCollectionTuple> {
        public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Document> SUCCESSFUL_WRITES = new TupleTag<Document>(){};
        public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Document> FAILED_WRITES = new TupleTag<Document>(){};
        private @UnknownKeyFor @NonNull @Initialized DocToBulk docToBulk = new AutoValue_ElasticsearchIO_DocToBulk.Builder().build();
        private @UnknownKeyFor @NonNull @Initialized BulkIO bulkIO = new AutoValue_ElasticsearchIO_BulkIO.Builder().setMaxBatchSize(1000L).setMaxBatchSizeBytes(0x500000L).setUseStatefulBatches(false).setMaxParallelRequests(1).setThrowWriteErrors(true).build();

        public @UnknownKeyFor @NonNull @Initialized DocToBulk getDocToBulk() {
            return this.docToBulk;
        }

        public @UnknownKeyFor @NonNull @Initialized BulkIO getBulkIO() {
            return this.bulkIO;
        }

        public @UnknownKeyFor @NonNull @Initialized Write withIdFn(@UnknownKeyFor @NonNull @Initialized FieldValueExtractFn idFn) {
            this.docToBulk = this.docToBulk.withIdFn(idFn);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Write withIndexFn(@UnknownKeyFor @NonNull @Initialized FieldValueExtractFn indexFn) {
            this.docToBulk = this.docToBulk.withIndexFn(indexFn);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Write withRoutingFn(@UnknownKeyFor @NonNull @Initialized FieldValueExtractFn routingFn) {
            this.docToBulk = this.docToBulk.withRoutingFn(routingFn);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Write withTypeFn(@UnknownKeyFor @NonNull @Initialized FieldValueExtractFn typeFn) {
            this.docToBulk = this.docToBulk.withTypeFn(typeFn);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Write withDocVersionFn(@UnknownKeyFor @NonNull @Initialized FieldValueExtractFn docVersionFn) {
            this.docToBulk = this.docToBulk.withDocVersionFn(docVersionFn);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Write withDocVersionType(@UnknownKeyFor @NonNull @Initialized String docVersionType) {
            this.docToBulk = this.docToBulk.withDocVersionType(docVersionType);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Write withUsePartialUpdate(@UnknownKeyFor @NonNull @Initialized boolean usePartialUpdate) {
            this.docToBulk = this.docToBulk.withUsePartialUpdate(usePartialUpdate);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Write withAppendOnly(@UnknownKeyFor @NonNull @Initialized boolean appendOnly) {
            this.docToBulk = this.docToBulk.withAppendOnly(appendOnly);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Write withUpsertScript(@UnknownKeyFor @NonNull @Initialized String source) {
            this.docToBulk = this.docToBulk.withUpsertScript(source);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Write withBackendVersion(@UnknownKeyFor @NonNull @Initialized int backendVersion) {
            this.docToBulk = this.docToBulk.withBackendVersion(backendVersion);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Write withIsDeleteFn(@UnknownKeyFor @NonNull @Initialized BooleanFieldValueExtractFn isDeleteFn) {
            this.docToBulk = this.docToBulk.withIsDeleteFn(isDeleteFn);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Write withConnectionConfiguration(@UnknownKeyFor @NonNull @Initialized ConnectionConfiguration connectionConfiguration) {
            Preconditions.checkArgument((connectionConfiguration != null ? 1 : 0) != 0, (Object)"connectionConfiguration can not be null");
            this.docToBulk = this.docToBulk.withConnectionConfiguration(connectionConfiguration);
            this.bulkIO = this.bulkIO.withConnectionConfiguration(connectionConfiguration);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Write withMaxBatchSize(@UnknownKeyFor @NonNull @Initialized long batchSize) {
            this.bulkIO = this.bulkIO.withMaxBatchSize(batchSize);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Write withMaxBatchSizeBytes(@UnknownKeyFor @NonNull @Initialized long batchSizeBytes) {
            this.bulkIO = this.bulkIO.withMaxBatchSizeBytes(batchSizeBytes);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Write withRetryConfiguration(@UnknownKeyFor @NonNull @Initialized RetryConfiguration retryConfiguration) {
            this.bulkIO = this.bulkIO.withRetryConfiguration(retryConfiguration);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Write withIgnoreVersionConflicts(@UnknownKeyFor @NonNull @Initialized boolean ignoreVersionConflicts) {
            this.bulkIO = this.bulkIO.withIgnoreVersionConflicts(ignoreVersionConflicts);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Write withUseStatefulBatches(@UnknownKeyFor @NonNull @Initialized boolean useStatefulBatches) {
            this.bulkIO = this.bulkIO.withUseStatefulBatches(useStatefulBatches);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Write withMaxBufferingDuration(@UnknownKeyFor @NonNull @Initialized Duration maxBufferingDuration) {
            this.bulkIO = this.bulkIO.withMaxBufferingDuration(maxBufferingDuration);
            return this;
        }

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized Write withMaxParallelRequestsPerWindow(@UnknownKeyFor @NonNull @Initialized int maxParallelRequestsPerWindow) {
            this.bulkIO = this.bulkIO.withMaxParallelRequestsPerWindow(maxParallelRequestsPerWindow);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Write withMaxParallelRequests(@UnknownKeyFor @NonNull @Initialized int maxParallelRequests) {
            this.bulkIO = this.bulkIO.withMaxParallelRequests(maxParallelRequests);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Write withAllowableResponseErrors(@Nullable @UnknownKeyFor @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> allowableResponseErrors) {
            if (allowableResponseErrors == null) {
                allowableResponseErrors = new HashSet<String>();
            }
            this.bulkIO = this.bulkIO.withAllowableResponseErrors(allowableResponseErrors);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Write withThrowWriteErrors(@UnknownKeyFor @NonNull @Initialized boolean throwWriteErrors) {
            this.bulkIO = this.bulkIO.withThrowWriteErrors(throwWriteErrors);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionTuple expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> input) {
            return (PCollectionTuple)((PCollection)input.apply((PTransform)this.docToBulk)).apply((PTransform)this.bulkIO);
        }

        public static interface BooleanFieldValueExtractFn
        extends SerializableFunction<JsonNode, Boolean> {
        }

        public static interface FieldValueExtractFn
        extends SerializableFunction<JsonNode, String> {
        }
    }

    @DefaultCoder(value=DocumentCoder.class)
    @AutoValue
    public static abstract class Document
    implements Serializable {
        public abstract @Nullable @UnknownKeyFor @Initialized String getInputDoc();

        public abstract @Nullable @UnknownKeyFor @Initialized String getBulkDirective();

        public abstract @UnknownKeyFor @NonNull @Initialized Boolean getHasError();

        public abstract @Nullable @UnknownKeyFor @Initialized String getResponseItemJson();

        public abstract @Nullable @UnknownKeyFor @Initialized Instant getTimestamp();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public static @UnknownKeyFor @NonNull @Initialized Document create() {
            return new AutoValue_ElasticsearchIO_Document.Builder().setHasError(false).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Document withInputDoc(@UnknownKeyFor @NonNull @Initialized String inputDoc) {
            return this.toBuilder().setInputDoc(inputDoc).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Document withBulkDirective(@UnknownKeyFor @NonNull @Initialized String bulkDirective) {
            return this.toBuilder().setBulkDirective(bulkDirective).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Document withResponseItemJson(@UnknownKeyFor @NonNull @Initialized String responseItemJson) {
            return this.toBuilder().setResponseItemJson(responseItemJson).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Document withHasError(@UnknownKeyFor @NonNull @Initialized boolean hasError) {
            return this.toBuilder().setHasError(hasError).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Document withTimestamp(@UnknownKeyFor @NonNull @Initialized Instant timestamp) {
            return this.toBuilder().setTimestamp(timestamp).build();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setInputDoc(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setBulkDirective(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setHasError(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setResponseItemJson(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setTimestamp(@UnknownKeyFor @NonNull @Initialized Instant var1);

            abstract @UnknownKeyFor @NonNull @Initialized Document build();
        }
    }

    public static class DocumentCoder
    extends AtomicCoder<Document>
    implements Serializable {
        private static final @UnknownKeyFor @NonNull @Initialized DocumentCoder INSTANCE = new DocumentCoder();

        private DocumentCoder() {
        }

        public static @UnknownKeyFor @NonNull @Initialized DocumentCoder of() {
            return INSTANCE;
        }

        public void encode(@UnknownKeyFor @NonNull @Initialized Document value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            NullableCoder.of((Coder)StringUtf8Coder.of()).encode((Object)value.getInputDoc(), outStream);
            NullableCoder.of((Coder)StringUtf8Coder.of()).encode((Object)value.getBulkDirective(), outStream);
            BooleanCoder.of().encode(value.getHasError(), outStream);
            NullableCoder.of((Coder)StringUtf8Coder.of()).encode((Object)value.getResponseItemJson(), outStream);
            NullableCoder.of((Coder)InstantCoder.of()).encode((Object)value.getTimestamp(), outStream);
        }

        public @UnknownKeyFor @NonNull @Initialized Document decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            String inputDoc = (String)NullableCoder.of((Coder)StringUtf8Coder.of()).decode(inStream);
            String bulkDirective = (String)NullableCoder.of((Coder)StringUtf8Coder.of()).decode(inStream);
            boolean hasError = BooleanCoder.of().decode(inStream);
            String responseItemJson = (String)NullableCoder.of((Coder)StringUtf8Coder.of()).decode(inStream);
            Instant timestamp = (Instant)NullableCoder.of((Coder)InstantCoder.of()).decode(inStream);
            return Document.create().withInputDoc(inputDoc).withBulkDirective(bulkDirective).withHasError(hasError).withResponseItemJson(responseItemJson).withTimestamp(timestamp);
        }
    }

    @AutoValue
    public static abstract class DocToBulk
    extends PTransform<PCollection<String>, PCollection<Document>> {
        private static final @UnknownKeyFor @NonNull @Initialized ObjectMapper OBJECT_MAPPER = new ObjectMapper();
        private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_RETRY_ON_CONFLICT = 5;

        abstract @Nullable @UnknownKeyFor @Initialized ConnectionConfiguration getConnectionConfiguration();

        abstract @Nullable @UnknownKeyFor @Initialized Write.FieldValueExtractFn getIdFn();

        abstract @Nullable @UnknownKeyFor @Initialized Write.FieldValueExtractFn getIndexFn();

        abstract @Nullable @UnknownKeyFor @Initialized Write.FieldValueExtractFn getRoutingFn();

        abstract @Nullable @UnknownKeyFor @Initialized Write.FieldValueExtractFn getTypeFn();

        abstract @Nullable @UnknownKeyFor @Initialized Write.FieldValueExtractFn getDocVersionFn();

        abstract @Nullable @UnknownKeyFor @Initialized String getDocVersionType();

        abstract @Nullable @UnknownKeyFor @Initialized String getUpsertScript();

        abstract @Nullable @UnknownKeyFor @Initialized Boolean getUsePartialUpdate();

        abstract @Nullable @UnknownKeyFor @Initialized Boolean getAppendOnly();

        abstract @Nullable @UnknownKeyFor @Initialized Write.BooleanFieldValueExtractFn getIsDeleteFn();

        abstract @Nullable @UnknownKeyFor @Initialized Integer getBackendVersion();

        abstract @UnknownKeyFor @NonNull @Initialized Builder builder();

        public @UnknownKeyFor @NonNull @Initialized DocToBulk withConnectionConfiguration(@UnknownKeyFor @NonNull @Initialized ConnectionConfiguration connectionConfiguration) {
            Preconditions.checkArgument((connectionConfiguration != null ? 1 : 0) != 0, (Object)"connectionConfiguration can not be null");
            return this.builder().setConnectionConfiguration(connectionConfiguration).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DocToBulk withIdFn(@UnknownKeyFor @NonNull @Initialized Write.FieldValueExtractFn idFn) {
            Preconditions.checkArgument((idFn != null ? 1 : 0) != 0, (Object)"idFn must not be null");
            return this.builder().setIdFn(idFn).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DocToBulk withIndexFn(@UnknownKeyFor @NonNull @Initialized Write.FieldValueExtractFn indexFn) {
            Preconditions.checkArgument((indexFn != null ? 1 : 0) != 0, (Object)"indexFn must not be null");
            return this.builder().setIndexFn(indexFn).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DocToBulk withRoutingFn(@UnknownKeyFor @NonNull @Initialized Write.FieldValueExtractFn routingFn) {
            Preconditions.checkArgument((routingFn != null ? 1 : 0) != 0, (Object)"routingFn must not be null");
            return this.builder().setRoutingFn(routingFn).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DocToBulk withTypeFn(@UnknownKeyFor @NonNull @Initialized Write.FieldValueExtractFn typeFn) {
            Preconditions.checkArgument((typeFn != null ? 1 : 0) != 0, (Object)"typeFn must not be null");
            return this.builder().setTypeFn(typeFn).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DocToBulk withUsePartialUpdate(@UnknownKeyFor @NonNull @Initialized boolean usePartialUpdate) {
            return this.builder().setUsePartialUpdate(usePartialUpdate).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DocToBulk withAppendOnly(@UnknownKeyFor @NonNull @Initialized boolean appendOnly) {
            return this.builder().setAppendOnly(appendOnly).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DocToBulk withUpsertScript(@UnknownKeyFor @NonNull @Initialized String source) {
            if (this.getBackendVersion() == null || this.getBackendVersion() == 2) {
                LOG.warn("Painless scripts are not supported on Elasticsearch clusters before version 5.0");
            }
            return this.builder().setUsePartialUpdate(false).setUpsertScript(source).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DocToBulk withDocVersionFn(@UnknownKeyFor @NonNull @Initialized Write.FieldValueExtractFn docVersionFn) {
            Preconditions.checkArgument((docVersionFn != null ? 1 : 0) != 0, (Object)"docVersionFn must not be null");
            return this.builder().setDocVersionFn(docVersionFn).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DocToBulk withIsDeleteFn(@UnknownKeyFor @NonNull @Initialized Write.BooleanFieldValueExtractFn isDeleteFn) {
            Preconditions.checkArgument((isDeleteFn != null ? 1 : 0) != 0, (Object)"deleteFn is required");
            return this.builder().setIsDeleteFn(isDeleteFn).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DocToBulk withDocVersionType(@UnknownKeyFor @NonNull @Initialized String docVersionType) {
            Preconditions.checkArgument((boolean)VERSION_TYPES.contains(docVersionType), (String)"docVersionType must be one of %s", (Object)String.join((CharSequence)", ", VERSION_TYPES));
            return this.builder().setDocVersionType(docVersionType).build();
        }

        public @UnknownKeyFor @NonNull @Initialized DocToBulk withBackendVersion(@UnknownKeyFor @NonNull @Initialized int backendVersion) {
            Preconditions.checkArgument((boolean)VALID_CLUSTER_VERSIONS.contains(backendVersion), (String)"Backend version may only be one of %s", (Object)String.join((CharSequence)", ", VERSION_TYPES));
            ElasticsearchIO.maybeLogVersionDeprecationWarning(backendVersion);
            return this.builder().setBackendVersion(backendVersion).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Document> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> docs) {
            ConnectionConfiguration connectionConfiguration = this.getConnectionConfiguration();
            Integer backendVersion = this.getBackendVersion();
            Write.FieldValueExtractFn idFn = this.getIdFn();
            Write.BooleanFieldValueExtractFn isDeleteFn = this.getIsDeleteFn();
            Preconditions.checkState((backendVersion != null || connectionConfiguration != null ? 1 : 0) != 0, (Object)"withBackendVersion() or withConnectionConfiguration() is required");
            Preconditions.checkArgument((isDeleteFn == null || idFn != null ? 1 : 0) != 0, (Object)"Id needs to be specified by withIdFn for delete operation");
            return (PCollection)docs.apply((PTransform)ParDo.of((DoFn)new DocToBulkFn(this)));
        }

        @VisibleForTesting
        static @UnknownKeyFor @NonNull @Initialized String createBulkApiEntity(@UnknownKeyFor @NonNull @Initialized DocToBulk spec, @UnknownKeyFor @NonNull @Initialized String document, @UnknownKeyFor @NonNull @Initialized int backendVersion) throws @UnknownKeyFor @NonNull @Initialized IOException {
            String documentMetadata = "{}";
            boolean isDelete = false;
            if (spec.getIndexFn() != null || spec.getTypeFn() != null || spec.getIdFn() != null || spec.getRoutingFn() != null) {
                JsonNode parsedDocument = OBJECT_MAPPER.readTree(document);
                documentMetadata = DocToBulk.getDocumentMetadata(spec, parsedDocument, backendVersion);
                if (spec.getIsDeleteFn() != null) {
                    isDelete = (Boolean)spec.getIsDeleteFn().apply(parsedDocument);
                }
            }
            boolean isAppendOnly = Boolean.TRUE.equals(spec.getAppendOnly());
            if (isDelete) {
                Preconditions.checkState((!isAppendOnly ? 1 : 0) != 0, (Object)"No deletions allowed for append-only indices");
                return String.format("{ \"delete\" : %s }%n", documentMetadata);
            }
            if (isAppendOnly) {
                return String.format("{ \"create\" : %s }%n%s%n", documentMetadata, document);
            }
            if (Boolean.TRUE.equals(spec.getUsePartialUpdate())) {
                return String.format("{ \"update\" : %s }%n{ \"doc\" : %s, \"doc_as_upsert\" : true }%n", documentMetadata, document);
            }
            if (spec.getUpsertScript() != null) {
                return String.format("{ \"update\" : %s }%n{ \"script\" : {\"source\": \"%s\", \"params\": %s}, \"upsert\" : %s, \"scripted_upsert\": true}%n", documentMetadata, spec.getUpsertScript(), document, document);
            }
            return String.format("{ \"index\" : %s }%n%s%n", documentMetadata, document);
        }

        private static @UnknownKeyFor @NonNull @Initialized String lowerCaseOrNull(@UnknownKeyFor @NonNull @Initialized String input) {
            return input == null ? null : input.toLowerCase();
        }

        private static @UnknownKeyFor @NonNull @Initialized String getDocumentMetadata(@UnknownKeyFor @NonNull @Initialized DocToBulk spec, @UnknownKeyFor @NonNull @Initialized JsonNode parsedDocument, @UnknownKeyFor @NonNull @Initialized int backendVersion) throws @UnknownKeyFor @NonNull @Initialized IOException {
            DocumentMetadata metadata = new DocumentMetadata(spec.getIndexFn() != null ? DocToBulk.lowerCaseOrNull((String)spec.getIndexFn().apply(parsedDocument)) : null, spec.getTypeFn() != null ? (String)spec.getTypeFn().apply(parsedDocument) : null, spec.getIdFn() != null ? (String)spec.getIdFn().apply(parsedDocument) : null, Boolean.TRUE.equals(spec.getUsePartialUpdate()) || spec.getUpsertScript() != null && !spec.getUpsertScript().isEmpty() ? Integer.valueOf(5) : null, spec.getRoutingFn() != null ? (String)spec.getRoutingFn().apply(parsedDocument) : null, backendVersion, spec.getDocVersionFn() != null ? (String)spec.getDocVersionFn().apply(parsedDocument) : null, spec.getDocVersionType());
            return OBJECT_MAPPER.writeValueAsString((Object)metadata);
        }

        static {
            SimpleModule module = new SimpleModule();
            module.addSerializer(DocumentMetadata.class, (JsonSerializer)new DocumentMetadataSerializer());
            OBJECT_MAPPER.registerModule((Module)module);
        }

        @VisibleForTesting
        static class DocToBulkFn
        extends DoFn<String, Document> {
            private final @UnknownKeyFor @NonNull @Initialized DocToBulk spec;
            private @UnknownKeyFor @NonNull @Initialized int backendVersion;

            public DocToBulkFn(@UnknownKeyFor @NonNull @Initialized DocToBulk spec) {
                this.spec = spec;
            }

            @DoFn.Setup
            public void setup() throws @UnknownKeyFor @NonNull @Initialized IOException {
                this.backendVersion = this.spec.getBackendVersion() != null ? this.spec.getBackendVersion() : ElasticsearchIO.getBackendVersion(this.spec.getConnectionConfiguration());
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized IOException {
                String inputDoc = (String)c.element();
                String bulkDirective = DocToBulk.createBulkApiEntity(this.spec, inputDoc, this.backendVersion);
                c.output((Object)Document.create().withInputDoc(inputDoc).withBulkDirective(bulkDirective).withTimestamp(c.timestamp()));
            }
        }

        private static class DocumentMetadataSerializer
        extends StdSerializer<DocumentMetadata> {
            private DocumentMetadataSerializer() {
                super(DocumentMetadata.class);
            }

            public void serialize(@UnknownKeyFor @NonNull @Initialized DocumentMetadata value, @UnknownKeyFor @NonNull @Initialized JsonGenerator gen, @UnknownKeyFor @NonNull @Initialized SerializerProvider provider) throws @UnknownKeyFor @NonNull @Initialized IOException {
                gen.writeStartObject();
                if (value.index != null) {
                    gen.writeStringField("_index", value.index);
                }
                if (value.type != null) {
                    gen.writeStringField("_type", value.type);
                }
                if (value.id != null) {
                    gen.writeStringField("_id", value.id);
                }
                if (value.routing != null) {
                    gen.writeStringField("routing", value.routing);
                }
                if (value.retryOnConflict != null && value.backendVersion <= 6) {
                    gen.writeNumberField("_retry_on_conflict", value.retryOnConflict.intValue());
                }
                if (value.retryOnConflict != null && value.backendVersion >= 7) {
                    gen.writeNumberField("retry_on_conflict", value.retryOnConflict.intValue());
                }
                if (value.version != null) {
                    gen.writeStringField("version", value.version);
                }
                if (value.versionType != null) {
                    gen.writeStringField("version_type", value.versionType);
                }
                gen.writeEndObject();
            }
        }

        private static class DocumentMetadata
        implements Serializable {
            final @UnknownKeyFor @NonNull @Initialized String index;
            final @UnknownKeyFor @NonNull @Initialized String type;
            final @UnknownKeyFor @NonNull @Initialized String id;
            final @UnknownKeyFor @NonNull @Initialized Integer retryOnConflict;
            final @UnknownKeyFor @NonNull @Initialized String routing;
            final @UnknownKeyFor @NonNull @Initialized Integer backendVersion;
            final @UnknownKeyFor @NonNull @Initialized String version;
            final @UnknownKeyFor @NonNull @Initialized String versionType;

            DocumentMetadata(@UnknownKeyFor @NonNull @Initialized String index, @UnknownKeyFor @NonNull @Initialized String type, @UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized Integer retryOnConflict, @UnknownKeyFor @NonNull @Initialized String routing, @UnknownKeyFor @NonNull @Initialized Integer backendVersion, @UnknownKeyFor @NonNull @Initialized String version, @UnknownKeyFor @NonNull @Initialized String versionType) {
                this.index = index;
                this.id = id;
                this.type = type;
                this.retryOnConflict = retryOnConflict;
                this.routing = routing;
                this.backendVersion = backendVersion;
                this.version = version;
                this.versionType = versionType;
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setConnectionConfiguration(@UnknownKeyFor @NonNull @Initialized ConnectionConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setIdFn(@UnknownKeyFor @NonNull @Initialized Write.FieldValueExtractFn var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setIndexFn(@UnknownKeyFor @NonNull @Initialized Write.FieldValueExtractFn var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setRoutingFn(@UnknownKeyFor @NonNull @Initialized Write.FieldValueExtractFn var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setTypeFn(@UnknownKeyFor @NonNull @Initialized Write.FieldValueExtractFn var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setDocVersionFn(@UnknownKeyFor @NonNull @Initialized Write.FieldValueExtractFn var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setDocVersionType(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setIsDeleteFn(@UnknownKeyFor @NonNull @Initialized Write.BooleanFieldValueExtractFn var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setUsePartialUpdate(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setAppendOnly(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setUpsertScript(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setBackendVersion(@UnknownKeyFor @NonNull @Initialized Integer var1);

            abstract @UnknownKeyFor @NonNull @Initialized DocToBulk build();
        }
    }

    @AutoValue
    public static abstract class RetryConfiguration
    implements Serializable {
        @VisibleForTesting
        static final @UnknownKeyFor @NonNull @Initialized RetryPredicate DEFAULT_RETRY_PREDICATE = new DefaultRetryPredicate();

        abstract @UnknownKeyFor @NonNull @Initialized int getMaxAttempts();

        abstract @UnknownKeyFor @NonNull @Initialized Duration getMaxDuration();

        abstract @UnknownKeyFor @NonNull @Initialized RetryPredicate getRetryPredicate();

        abstract @UnknownKeyFor @NonNull @Initialized Builder builder();

        public static @UnknownKeyFor @NonNull @Initialized RetryConfiguration create(@UnknownKeyFor @NonNull @Initialized int maxAttempts, @UnknownKeyFor @NonNull @Initialized Duration maxDuration) {
            Preconditions.checkArgument((maxAttempts > 0 ? 1 : 0) != 0, (Object)"maxAttempts must be greater than 0");
            Preconditions.checkArgument((maxDuration != null && maxDuration.isLongerThan((ReadableDuration)Duration.ZERO) ? 1 : 0) != 0, (Object)"maxDuration must be greater than 0");
            return new AutoValue_ElasticsearchIO_RetryConfiguration.Builder().setMaxAttempts(maxAttempts).setMaxDuration(maxDuration).setRetryPredicate(DEFAULT_RETRY_PREDICATE).build();
        }

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized RetryConfiguration withRetryPredicate(@UnknownKeyFor @NonNull @Initialized RetryPredicate predicate) {
            Preconditions.checkArgument((predicate != null ? 1 : 0) != 0, (Object)"predicate must be provided");
            return this.builder().setRetryPredicate(predicate).build();
        }

        @VisibleForTesting
        static class DefaultRetryPredicate
        implements RetryPredicate {
            private @UnknownKeyFor @NonNull @Initialized int errorCode;

            DefaultRetryPredicate(@UnknownKeyFor @NonNull @Initialized int code) {
                this.errorCode = code;
            }

            DefaultRetryPredicate() {
                this(429);
            }

            private static @UnknownKeyFor @NonNull @Initialized boolean errorCodePresent(@UnknownKeyFor @NonNull @Initialized HttpEntity responseEntity, @UnknownKeyFor @NonNull @Initialized int errorCode) {
                try {
                    JsonNode json = ElasticsearchIO.parseResponse(responseEntity);
                    if (json.path("errors").asBoolean()) {
                        for (JsonNode item : json.path("items")) {
                            if (item.findValue("status").asInt() != errorCode) continue;
                            return true;
                        }
                    }
                }
                catch (IOException e) {
                    LOG.warn("Could not extract error codes from responseEntity {}", (Object)responseEntity);
                }
                return false;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean test(@UnknownKeyFor @NonNull @Initialized HttpEntity responseEntity) {
                return DefaultRetryPredicate.errorCodePresent(responseEntity, this.errorCode);
            }
        }

        @FunctionalInterface
        static interface RetryPredicate
        extends Predicate<HttpEntity>,
        Serializable {
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxAttempts(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxDuration(@UnknownKeyFor @NonNull @Initialized Duration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setRetryPredicate(@UnknownKeyFor @NonNull @Initialized RetryPredicate var1);

            abstract @UnknownKeyFor @NonNull @Initialized RetryConfiguration build();
        }
    }

    private static class BoundedElasticsearchReader
    extends BoundedSource.BoundedReader<String> {
        private final @UnknownKeyFor @NonNull @Initialized BoundedElasticsearchSource source;
        private @UnknownKeyFor @NonNull @Initialized RestClient restClient;
        private @UnknownKeyFor @NonNull @Initialized String current;
        private @UnknownKeyFor @NonNull @Initialized String scrollId;
        private @UnknownKeyFor @NonNull @Initialized ListIterator<@UnknownKeyFor @NonNull @Initialized String> batchIterator;

        private BoundedElasticsearchReader(@UnknownKeyFor @NonNull @Initialized BoundedElasticsearchSource source) {
            this.source = source;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean start() throws @UnknownKeyFor @NonNull @Initialized IOException {
            String query;
            this.restClient = this.source.spec.getConnectionConfiguration().createClient();
            String string = query = this.source.spec.getQuery() != null ? (String)this.source.spec.getQuery().get() : null;
            if (query == null) {
                query = "{\"query\": { \"match_all\": {} }}";
            }
            if (this.source.backendVersion >= 5 && this.source.numSlices != null && this.source.numSlices > 1) {
                String sliceQuery = String.format("\"slice\": {\"id\": %s,\"max\": %s}", this.source.sliceId, this.source.numSlices);
                query = query.replaceFirst("\\{", "{" + sliceQuery + ",");
            }
            String endPoint = this.source.spec.getConnectionConfiguration().getSearchEndPoint();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("scroll", this.source.spec.getScrollKeepalive());
            NStringEntity queryEntity = new NStringEntity(query, ContentType.APPLICATION_JSON);
            Request request = new Request("GET", endPoint);
            request.addParameters(params);
            request.setEntity((HttpEntity)queryEntity);
            Response response = this.restClient.performRequest(request);
            JsonNode searchResult = ElasticsearchIO.parseResponse(response.getEntity());
            this.updateScrollId(searchResult);
            return this.readNextBatchAndReturnFirstDocument(searchResult);
        }

        private void updateScrollId(@UnknownKeyFor @NonNull @Initialized JsonNode searchResult) {
            this.scrollId = searchResult.path("_scroll_id").asText();
        }

        public @UnknownKeyFor @NonNull @Initialized boolean advance() throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (this.batchIterator.hasNext()) {
                this.current = this.batchIterator.next();
                return true;
            }
            String requestBody = String.format("{\"scroll\" : \"%s\",\"scroll_id\" : \"%s\"}", this.source.spec.getScrollKeepalive(), this.scrollId);
            NStringEntity scrollEntity = new NStringEntity(requestBody, ContentType.APPLICATION_JSON);
            Request request = new Request("GET", "/_search/scroll");
            request.addParameters(Collections.emptyMap());
            request.setEntity((HttpEntity)scrollEntity);
            Response response = this.restClient.performRequest(request);
            JsonNode searchResult = ElasticsearchIO.parseResponse(response.getEntity());
            this.updateScrollId(searchResult);
            return this.readNextBatchAndReturnFirstDocument(searchResult);
        }

        private @UnknownKeyFor @NonNull @Initialized boolean readNextBatchAndReturnFirstDocument(@UnknownKeyFor @NonNull @Initialized JsonNode searchResult) {
            JsonNode hits = searchResult.path("hits").path("hits");
            if (hits.size() == 0) {
                this.current = null;
                this.batchIterator = null;
                return false;
            }
            ArrayList<String> batch = new ArrayList<String>();
            boolean withMetadata = this.source.spec.isWithMetadata();
            for (JsonNode hit : hits) {
                if (withMetadata) {
                    batch.add(hit.toString());
                    continue;
                }
                String document = hit.path("_source").toString();
                batch.add(document);
            }
            this.batchIterator = batch.listIterator();
            this.current = this.batchIterator.next();
            return true;
        }

        public @UnknownKeyFor @NonNull @Initialized String getCurrent() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            return this.current;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
            String requestBody = String.format("{\"scroll_id\" : [\"%s\"]}", this.scrollId);
            NStringEntity entity = new NStringEntity(requestBody, ContentType.APPLICATION_JSON);
            try {
                Request request = new Request("DELETE", "/_search/scroll");
                request.addParameters(Collections.emptyMap());
                request.setEntity((HttpEntity)entity);
                this.restClient.performRequest(request);
            }
            finally {
                if (this.restClient != null) {
                    this.restClient.close();
                }
            }
        }

        public @UnknownKeyFor @NonNull @Initialized BoundedSource<@UnknownKeyFor @NonNull @Initialized String> getCurrentSource() {
            return this.source;
        }
    }

    @VisibleForTesting
    public static class BoundedElasticsearchSource
    extends BoundedSource<String> {
        private @UnknownKeyFor @NonNull @Initialized int backendVersion;
        private final @UnknownKeyFor @NonNull @Initialized Read spec;
        private final @Nullable @UnknownKeyFor @Initialized Integer numSlices;
        private final @Nullable @UnknownKeyFor @Initialized Integer sliceId;
        private @Nullable @UnknownKeyFor @Initialized Long estimatedByteSize;

        private BoundedElasticsearchSource(@UnknownKeyFor @NonNull @Initialized Read spec, @Nullable @UnknownKeyFor @Initialized Integer numSlices, @Nullable @UnknownKeyFor @Initialized Integer sliceId, @Nullable @UnknownKeyFor @Initialized Long estimatedByteSize, @UnknownKeyFor @NonNull @Initialized int backendVersion) {
            this.backendVersion = backendVersion;
            this.spec = spec;
            this.numSlices = numSlices;
            this.estimatedByteSize = estimatedByteSize;
            this.sliceId = sliceId;
        }

        @VisibleForTesting
        BoundedElasticsearchSource(@UnknownKeyFor @NonNull @Initialized Read spec, @Nullable @UnknownKeyFor @Initialized Integer numSlices, @Nullable @UnknownKeyFor @Initialized Integer sliceId) {
            this.spec = spec;
            this.numSlices = numSlices;
            this.sliceId = sliceId;
        }

        public @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedSource<@UnknownKeyFor @NonNull @Initialized String>> split(@UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
            ConnectionConfiguration connectionConfiguration = this.spec.getConnectionConfiguration();
            this.backendVersion = ElasticsearchIO.getBackendVersion(connectionConfiguration);
            ArrayList<BoundedElasticsearchSource> sources = new ArrayList<BoundedElasticsearchSource>();
            long indexSize = this.getEstimatedSizeBytes(options);
            float nbBundlesFloat = (float)indexSize / (float)desiredBundleSizeBytes;
            int nbBundles = (int)Math.ceil(nbBundlesFloat);
            if (nbBundles > 1024) {
                nbBundles = 1024;
            }
            for (int i = 0; i < nbBundles; ++i) {
                long estimatedByteSizeForBundle = this.getEstimatedSizeBytes(options) / (long)nbBundles;
                sources.add(new BoundedElasticsearchSource(this.spec, nbBundles, i, estimatedByteSizeForBundle, this.backendVersion));
            }
            return sources;
        }

        public @UnknownKeyFor @NonNull @Initialized long getEstimatedSizeBytes(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException {
            String query;
            if (this.estimatedByteSize != null) {
                return this.estimatedByteSize;
            }
            ConnectionConfiguration connectionConfiguration = this.spec.getConnectionConfiguration();
            JsonNode statsJson = BoundedElasticsearchSource.getStats(connectionConfiguration);
            JsonNode indexStats = statsJson.path("_all").path("primaries");
            long indexSize = indexStats.path("store").path("size_in_bytes").asLong();
            LOG.debug("estimate source byte size: total index size {}", (Object)indexSize);
            String string = query = this.spec.getQuery() != null ? (String)this.spec.getQuery().get() : null;
            if (query == null || query.isEmpty()) {
                this.estimatedByteSize = indexSize;
                return this.estimatedByteSize;
            }
            long totalCount = indexStats.path("docs").path("count").asLong();
            LOG.debug("estimate source byte size: total document count {}", (Object)totalCount);
            if (totalCount == 0L) {
                this.estimatedByteSize = 1L;
                return this.estimatedByteSize;
            }
            String endPoint = connectionConfiguration.getCountEndPoint();
            try (RestClient restClient = connectionConfiguration.createClient();){
                long count = this.queryCount(restClient, endPoint, query);
                LOG.debug("estimate source byte size: query document count {}", (Object)count);
                this.estimatedByteSize = count == 0L ? Long.valueOf(1L) : Long.valueOf(indexSize / totalCount * count);
            }
            return this.estimatedByteSize;
        }

        private @UnknownKeyFor @NonNull @Initialized long queryCount(@Nonnull @UnknownKeyFor @NonNull @Initialized RestClient restClient, @Nonnull @UnknownKeyFor @NonNull @Initialized String endPoint, @Nonnull @UnknownKeyFor @NonNull @Initialized String query) throws @UnknownKeyFor @NonNull @Initialized IOException {
            Request request = new Request("GET", endPoint);
            request.setEntity((HttpEntity)new NStringEntity(query, ContentType.APPLICATION_JSON));
            JsonNode searchResult = ElasticsearchIO.parseResponse(restClient.performRequest(request).getEntity());
            return searchResult.path("count").asLong();
        }

        @VisibleForTesting
        static @UnknownKeyFor @NonNull @Initialized long estimateIndexSize(@UnknownKeyFor @NonNull @Initialized ConnectionConfiguration connectionConfiguration) throws @UnknownKeyFor @NonNull @Initialized IOException {
            JsonNode statsJson = BoundedElasticsearchSource.getStats(connectionConfiguration);
            JsonNode indexStats = statsJson.path("_all").path("primaries");
            JsonNode store = indexStats.path("store");
            return store.path("size_in_bytes").asLong();
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            this.spec.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"numSlices", (Integer)this.numSlices));
            builder.addIfNotNull(DisplayData.item((String)"sliceId", (Integer)this.sliceId));
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized BoundedSource.BoundedReader<@UnknownKeyFor @NonNull @Initialized String> createReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            return new BoundedElasticsearchReader(this);
        }

        public void validate() {
            this.spec.validate(null);
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized String> getOutputCoder() {
            return StringUtf8Coder.of();
        }

        private static @UnknownKeyFor @NonNull @Initialized JsonNode getStats(@UnknownKeyFor @NonNull @Initialized ConnectionConfiguration connectionConfiguration) throws @UnknownKeyFor @NonNull @Initialized IOException {
            HashMap params = new HashMap();
            String endpoint = String.format("/%s/_stats", connectionConfiguration.getIndex());
            try (RestClient restClient = connectionConfiguration.createClient();){
                Request request = new Request("GET", endpoint);
                request.addParameters(params);
                JsonNode jsonNode = ElasticsearchIO.parseResponse(restClient.performRequest(request).getEntity());
                return jsonNode;
            }
        }
    }

    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<String>> {
        private static final @UnknownKeyFor @NonNull @Initialized long MAX_BATCH_SIZE = 10000L;

        abstract @Nullable @UnknownKeyFor @Initialized ConnectionConfiguration getConnectionConfiguration();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getQuery();

        abstract @UnknownKeyFor @NonNull @Initialized boolean isWithMetadata();

        abstract @UnknownKeyFor @NonNull @Initialized String getScrollKeepalive();

        abstract @UnknownKeyFor @NonNull @Initialized long getBatchSize();

        abstract @UnknownKeyFor @NonNull @Initialized Builder builder();

        public @UnknownKeyFor @NonNull @Initialized Read withConnectionConfiguration(@UnknownKeyFor @NonNull @Initialized ConnectionConfiguration connectionConfiguration) {
            Preconditions.checkArgument((connectionConfiguration != null ? 1 : 0) != 0, (Object)"connectionConfiguration can not be null");
            return this.builder().setConnectionConfiguration(connectionConfiguration).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withQuery(@UnknownKeyFor @NonNull @Initialized String query) {
            Preconditions.checkArgument((query != null ? 1 : 0) != 0, (Object)"query can not be null");
            Preconditions.checkArgument((!query.isEmpty() ? 1 : 0) != 0, (Object)"query can not be empty");
            return this.withQuery((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)query));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withQuery(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> query) {
            Preconditions.checkArgument((query != null ? 1 : 0) != 0, (Object)"query can not be null");
            return this.builder().setQuery(query).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withMetadata() {
            return this.builder().setWithMetadata(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withScrollKeepalive(@UnknownKeyFor @NonNull @Initialized String scrollKeepalive) {
            Preconditions.checkArgument((scrollKeepalive != null ? 1 : 0) != 0, (Object)"scrollKeepalive can not be null");
            Preconditions.checkArgument((!"0m".equals(scrollKeepalive) ? 1 : 0) != 0, (Object)"scrollKeepalive can not be 0m");
            return this.builder().setScrollKeepalive(scrollKeepalive).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withBatchSize(@UnknownKeyFor @NonNull @Initialized long batchSize) {
            Preconditions.checkArgument((batchSize > 0L && batchSize <= 10000L ? 1 : 0) != 0, (String)"batchSize must be > 0 and <= %s, but was: %s", (long)10000L, (long)batchSize);
            return this.builder().setBatchSize(batchSize).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            ConnectionConfiguration connectionConfiguration = this.getConnectionConfiguration();
            Preconditions.checkState((connectionConfiguration != null ? 1 : 0) != 0, (Object)"withConnectionConfiguration() is required");
            return (PCollection)input.apply((PTransform)org.apache.beam.sdk.io.Read.from((BoundedSource)new BoundedElasticsearchSource(this, null, null)));
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"query", this.getQuery()));
            builder.addIfNotNull(DisplayData.item((String)"withMetadata", (Boolean)this.isWithMetadata()));
            builder.addIfNotNull(DisplayData.item((String)"batchSize", (Long)this.getBatchSize()));
            builder.addIfNotNull(DisplayData.item((String)"scrollKeepalive", (String)this.getScrollKeepalive()));
            this.getConnectionConfiguration().populateDisplayData(builder);
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setConnectionConfiguration(@UnknownKeyFor @NonNull @Initialized ConnectionConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setQuery(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setWithMetadata(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setScrollKeepalive(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setBatchSize(@UnknownKeyFor @NonNull @Initialized long var1);

            abstract @UnknownKeyFor @NonNull @Initialized Read build();
        }
    }

    @AutoValue
    public static abstract class ConnectionConfiguration
    implements Serializable {
        public abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getAddresses();

        public abstract @Nullable @UnknownKeyFor @Initialized String getUsername();

        public abstract @Nullable @UnknownKeyFor @Initialized String getPassword();

        public abstract @Nullable @UnknownKeyFor @Initialized String getApiKey();

        public abstract @Nullable @UnknownKeyFor @Initialized String getBearerToken();

        public abstract @Nullable @UnknownKeyFor @Initialized String getKeystorePath();

        public abstract @Nullable @UnknownKeyFor @Initialized String getKeystorePassword();

        public abstract @UnknownKeyFor @NonNull @Initialized String getIndex();

        public abstract @Nullable @UnknownKeyFor @Initialized String getType();

        public abstract @Nullable @UnknownKeyFor @Initialized Integer getSocketTimeout();

        public abstract @Nullable @UnknownKeyFor @Initialized Integer getConnectTimeout();

        public abstract @UnknownKeyFor @NonNull @Initialized boolean isTrustSelfSignedCerts();

        abstract @UnknownKeyFor @NonNull @Initialized Builder builder();

        public static @UnknownKeyFor @NonNull @Initialized ConnectionConfiguration create(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] addresses, @UnknownKeyFor @NonNull @Initialized String index, @UnknownKeyFor @NonNull @Initialized String type) {
            Preconditions.checkArgument((addresses != null ? 1 : 0) != 0, (Object)"addresses can not be null");
            Preconditions.checkArgument((addresses.length > 0 ? 1 : 0) != 0, (Object)"addresses can not be empty");
            Preconditions.checkArgument((index != null ? 1 : 0) != 0, (Object)"index can not be null");
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type can not be null");
            return new AutoValue_ElasticsearchIO_ConnectionConfiguration.Builder().setAddresses(Arrays.asList(addresses)).setIndex(index).setType(type).setTrustSelfSignedCerts(false).build();
        }

        public static @UnknownKeyFor @NonNull @Initialized ConnectionConfiguration create(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] addresses, @UnknownKeyFor @NonNull @Initialized String index) {
            Preconditions.checkArgument((addresses != null ? 1 : 0) != 0, (Object)"addresses can not be null");
            Preconditions.checkArgument((addresses.length > 0 ? 1 : 0) != 0, (Object)"addresses can not be empty");
            Preconditions.checkArgument((index != null ? 1 : 0) != 0, (Object)"index can not be null");
            return new AutoValue_ElasticsearchIO_ConnectionConfiguration.Builder().setAddresses(Arrays.asList(addresses)).setIndex(index).setType("").setTrustSelfSignedCerts(false).build();
        }

        public static @UnknownKeyFor @NonNull @Initialized ConnectionConfiguration create(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] addresses) {
            Preconditions.checkArgument((addresses != null ? 1 : 0) != 0, (Object)"addresses can not be null");
            Preconditions.checkArgument((addresses.length > 0 ? 1 : 0) != 0, (Object)"addresses can not be empty");
            return new AutoValue_ElasticsearchIO_ConnectionConfiguration.Builder().setAddresses(Arrays.asList(addresses)).setIndex("").setType("").setTrustSelfSignedCerts(false).build();
        }

        public @UnknownKeyFor @NonNull @Initialized String getApiPrefix() {
            StringBuilder sb = new StringBuilder();
            if (!Strings.isNullOrEmpty((String)this.getIndex())) {
                sb.append("/").append(this.getIndex());
            }
            if (!Strings.isNullOrEmpty((String)this.getType())) {
                sb.append("/").append(this.getType());
            }
            return sb.toString();
        }

        public @UnknownKeyFor @NonNull @Initialized String getPrefixedEndpoint(@UnknownKeyFor @NonNull @Initialized String endpoint) {
            return this.getApiPrefix() + "/" + endpoint;
        }

        public @UnknownKeyFor @NonNull @Initialized String getBulkEndPoint() {
            return this.getPrefixedEndpoint("_bulk");
        }

        public @UnknownKeyFor @NonNull @Initialized String getSearchEndPoint() {
            return this.getPrefixedEndpoint("_search");
        }

        public @UnknownKeyFor @NonNull @Initialized String getCountEndPoint() {
            return this.getPrefixedEndpoint("_count");
        }

        public @UnknownKeyFor @NonNull @Initialized ConnectionConfiguration withUsername(@UnknownKeyFor @NonNull @Initialized String username) {
            Preconditions.checkArgument((username != null ? 1 : 0) != 0, (Object)"username can not be null");
            Preconditions.checkArgument((!username.isEmpty() ? 1 : 0) != 0, (Object)"username can not be empty");
            return this.builder().setUsername(username).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ConnectionConfiguration withPassword(@UnknownKeyFor @NonNull @Initialized String password) {
            Preconditions.checkArgument((password != null ? 1 : 0) != 0, (Object)"password can not be null");
            Preconditions.checkArgument((!password.isEmpty() ? 1 : 0) != 0, (Object)"password can not be empty");
            return this.builder().setPassword(password).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ConnectionConfiguration withApiKey(@UnknownKeyFor @NonNull @Initialized String apiKey) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)apiKey) ? 1 : 0) != 0, (Object)"apiKey can not be null or empty");
            return this.builder().setApiKey(apiKey).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ConnectionConfiguration withBearerToken(@UnknownKeyFor @NonNull @Initialized String bearerToken) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bearerToken) ? 1 : 0) != 0, (Object)"bearerToken can not be null or empty");
            return this.builder().setBearerToken(bearerToken).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ConnectionConfiguration withKeystorePath(@UnknownKeyFor @NonNull @Initialized String keystorePath) {
            Preconditions.checkArgument((keystorePath != null ? 1 : 0) != 0, (Object)"keystorePath can not be null");
            Preconditions.checkArgument((!keystorePath.isEmpty() ? 1 : 0) != 0, (Object)"keystorePath can not be empty");
            return this.builder().setKeystorePath(keystorePath).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ConnectionConfiguration withKeystorePassword(@UnknownKeyFor @NonNull @Initialized String keystorePassword) {
            Preconditions.checkArgument((keystorePassword != null ? 1 : 0) != 0, (Object)"keystorePassword can not be null");
            return this.builder().setKeystorePassword(keystorePassword).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ConnectionConfiguration withTrustSelfSignedCerts(@UnknownKeyFor @NonNull @Initialized boolean trustSelfSignedCerts) {
            return this.builder().setTrustSelfSignedCerts(trustSelfSignedCerts).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ConnectionConfiguration withSocketTimeout(@UnknownKeyFor @NonNull @Initialized Integer socketTimeout) {
            Preconditions.checkArgument((socketTimeout != null ? 1 : 0) != 0, (Object)"socketTimeout can not be null");
            return this.builder().setSocketTimeout(socketTimeout).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ConnectionConfiguration withConnectTimeout(@UnknownKeyFor @NonNull @Initialized Integer connectTimeout) {
            Preconditions.checkArgument((connectTimeout != null ? 1 : 0) != 0, (Object)"connectTimeout can not be null");
            return this.builder().setConnectTimeout(connectTimeout).build();
        }

        private void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            builder.add(DisplayData.item((String)"address", (String)this.getAddresses().toString()));
            builder.add(DisplayData.item((String)"index", (String)this.getIndex()));
            builder.addIfNotNull(DisplayData.item((String)"type", (String)this.getType()));
            builder.addIfNotNull(DisplayData.item((String)"username", (String)this.getUsername()));
            builder.addIfNotNull(DisplayData.item((String)"keystore.path", (String)this.getKeystorePath()));
            builder.addIfNotNull(DisplayData.item((String)"socketTimeout", (Integer)this.getSocketTimeout()));
            builder.addIfNotNull(DisplayData.item((String)"connectTimeout", (Integer)this.getConnectTimeout()));
            builder.addIfNotNull(DisplayData.item((String)"trustSelfSignedCerts", (Boolean)this.isTrustSelfSignedCerts()));
        }

        private @UnknownKeyFor @NonNull @Initialized SSLContext getSSLContext() throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (this.getKeystorePath() != null && !this.getKeystorePath().isEmpty()) {
                try {
                    KeyStore keyStore = KeyStore.getInstance("jks");
                    try (FileInputStream is = new FileInputStream(new File(this.getKeystorePath()));){
                        String keystorePassword = this.getKeystorePassword();
                        keyStore.load(is, keystorePassword == null ? null : keystorePassword.toCharArray());
                    }
                    TrustSelfSignedStrategy trustStrategy = this.isTrustSelfSignedCerts() ? new TrustSelfSignedStrategy() : null;
                    return SSLContexts.custom().loadTrustMaterial(keyStore, (TrustStrategy)trustStrategy).build();
                }
                catch (Exception e) {
                    throw new IOException("Can't load the client certificate from the keystore", e);
                }
            }
            return null;
        }

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized RestClient createClient() throws @UnknownKeyFor @NonNull @Initialized IOException {
            HttpHost[] hosts = new HttpHost[this.getAddresses().size()];
            int i = 0;
            for (String address : this.getAddresses()) {
                URL url = new URL(address);
                hosts[i] = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
                ++i;
            }
            RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])hosts);
            SSLContext sslContext = this.getSSLContext();
            if (this.getApiKey() != null) {
                restClientBuilder.setDefaultHeaders(new Header[]{new BasicHeader("Authorization", "ApiKey " + this.getApiKey())});
            }
            if (this.getBearerToken() != null) {
                restClientBuilder.setDefaultHeaders(new Header[]{new BasicHeader("Authorization", "Bearer " + this.getBearerToken())});
            }
            restClientBuilder.setHttpClientConfigCallback(httpClientBuilder -> {
                if (this.getUsername() != null) {
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.getUsername(), this.getPassword()));
                    httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                }
                if (sslContext != null) {
                    SSLIOSessionStrategy sessionStrategy = new SSLIOSessionStrategy(sslContext);
                    httpClientBuilder.setSSLContext(sslContext).setSSLStrategy((SchemeIOSessionStrategy)sessionStrategy);
                }
                return httpClientBuilder;
            });
            restClientBuilder.setRequestConfigCallback(new RestClientBuilder.RequestConfigCallback(){

                public // Could not load outer class - annotation placement on inner may be incorrect
                 @UnknownKeyFor @NonNull @Initialized RequestConfig.Builder customizeRequestConfig(// Could not load outer class - annotation placement on inner may be incorrect
                 @UnknownKeyFor @NonNull @Initialized RequestConfig.Builder requestConfigBuilder) {
                    if (this.getConnectTimeout() != null) {
                        requestConfigBuilder.setConnectTimeout(this.getConnectTimeout().intValue());
                    }
                    if (this.getSocketTimeout() != null) {
                        requestConfigBuilder.setSocketTimeout(this.getSocketTimeout().intValue());
                    }
                    return requestConfigBuilder;
                }
            });
            return restClientBuilder.build();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setAddresses(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setUsername(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setPassword(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setApiKey(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setBearerToken(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setKeystorePath(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setKeystorePassword(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setIndex(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setType(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setSocketTimeout(@UnknownKeyFor @NonNull @Initialized Integer var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setConnectTimeout(@UnknownKeyFor @NonNull @Initialized Integer var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setTrustSelfSignedCerts(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized ConnectionConfiguration build();
        }
    }
}

