/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.elasticsearch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.auto.value.AutoValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.elasticsearch.AutoValue_ElasticsearchIO_ConnectionConfiguration;
import org.apache.beam.sdk.io.elasticsearch.AutoValue_ElasticsearchIO_Read;
import org.apache.beam.sdk.io.elasticsearch.AutoValue_ElasticsearchIO_Write;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdks.java.io.elasticsearch.repackaged.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.sdks.java.io.elasticsearch.repackaged.com.google.common.base.Preconditions;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class ElasticsearchIO {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static Read read() {
        return new AutoValue_ElasticsearchIO_Read.Builder().setScrollKeepalive("5m").setBatchSize(100L).build();
    }

    public static Write write() {
        return new AutoValue_ElasticsearchIO_Write.Builder().setMaxBatchSize(1000L).setMaxBatchSizeBytes(0x500000L).build();
    }

    private ElasticsearchIO() {
    }

    @VisibleForTesting
    static JsonNode parseResponse(Response response) throws IOException {
        return (JsonNode)mapper.readValue(response.getEntity().getContent(), JsonNode.class);
    }

    static void checkForErrors(Response response, int backendVersion) throws IOException {
        JsonNode searchResult = ElasticsearchIO.parseResponse(response);
        boolean errors = searchResult.path("errors").asBoolean();
        if (errors) {
            StringBuilder errorMessages = new StringBuilder("Error writing to Elasticsearch, some elements could not be inserted:");
            JsonNode items = searchResult.path("items");
            for (JsonNode item : items) {
                JsonNode errorRoot;
                JsonNode error;
                String errorRootName = "";
                if (backendVersion == 2) {
                    errorRootName = "create";
                } else if (backendVersion == 5) {
                    errorRootName = "index";
                }
                if ((error = (errorRoot = item.path(errorRootName)).get("error")) == null) continue;
                String type = error.path("type").asText();
                String reason = error.path("reason").asText();
                String docId = errorRoot.path("_id").asText();
                errorMessages.append(String.format("%nDocument id %s: %s (%s)", docId, reason, type));
                JsonNode causedBy = error.get("caused_by");
                if (causedBy == null) continue;
                String cbReason = causedBy.path("reason").asText();
                String cbType = causedBy.path("type").asText();
                errorMessages.append(String.format("%nCaused by: %s (%s)", cbReason, cbType));
            }
            throw new IOException(errorMessages.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int getBackendVersion(ConnectionConfiguration connectionConfiguration) {
        try (RestClient restClient = connectionConfiguration.createClient();){
            Response response = restClient.performRequest("GET", "", new Header[0]);
            JsonNode jsonNode = ElasticsearchIO.parseResponse(response);
            int backendVersion = Integer.parseInt(jsonNode.path("version").path("number").asText().substring(0, 1));
            Preconditions.checkArgument(backendVersion == 2 || backendVersion == 5, "The Elasticsearch version to connect to is %s.x. This version of the ElasticsearchIO is only compatible with Elasticsearch v5.x and v2.x", backendVersion);
            int n = backendVersion;
            return n;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot get Elasticsearch version");
        }
    }

    @AutoValue
    public static abstract class Write
    extends PTransform<PCollection<String>, PDone> {
        @Nullable
        abstract ConnectionConfiguration getConnectionConfiguration();

        abstract long getMaxBatchSize();

        abstract long getMaxBatchSizeBytes();

        abstract Builder builder();

        public Write withConnectionConfiguration(ConnectionConfiguration connectionConfiguration) {
            Preconditions.checkArgument(connectionConfiguration != null, "connectionConfiguration can not be null");
            return this.builder().setConnectionConfiguration(connectionConfiguration).build();
        }

        public Write withMaxBatchSize(long batchSize) {
            Preconditions.checkArgument(batchSize > 0L, "batchSize must be > 0, but was %d", batchSize);
            return this.builder().setMaxBatchSize(batchSize).build();
        }

        public Write withMaxBatchSizeBytes(long batchSizeBytes) {
            Preconditions.checkArgument(batchSizeBytes > 0L, "batchSizeBytes must be > 0, but was %d", batchSizeBytes);
            return this.builder().setMaxBatchSizeBytes(batchSizeBytes).build();
        }

        public PDone expand(PCollection<String> input) {
            ConnectionConfiguration connectionConfiguration = this.getConnectionConfiguration();
            Preconditions.checkState(connectionConfiguration != null, "withConnectionConfiguration() is required");
            input.apply((PTransform)ParDo.of((DoFn)new WriteFn(this)));
            return PDone.in((Pipeline)input.getPipeline());
        }

        @VisibleForTesting
        static class WriteFn
        extends DoFn<String, Void> {
            private int backendVersion;
            private final Write spec;
            private transient RestClient restClient;
            private ArrayList<String> batch;
            private long currentBatchSizeBytes;

            @VisibleForTesting
            WriteFn(Write spec) {
                this.spec = spec;
            }

            @DoFn.Setup
            public void setup() throws Exception {
                ConnectionConfiguration connectionConfiguration = this.spec.getConnectionConfiguration();
                this.backendVersion = ElasticsearchIO.getBackendVersion(connectionConfiguration);
                this.restClient = connectionConfiguration.createClient();
            }

            @DoFn.StartBundle
            public void startBundle(DoFn.StartBundleContext context) throws Exception {
                this.batch = new ArrayList();
                this.currentBatchSizeBytes = 0L;
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext context) throws Exception {
                String document = (String)context.element();
                this.batch.add(String.format("{ \"index\" : {} }%n%s%n", document));
                this.currentBatchSizeBytes += (long)document.getBytes(StandardCharsets.UTF_8).length;
                if ((long)this.batch.size() >= this.spec.getMaxBatchSize() || this.currentBatchSizeBytes >= this.spec.getMaxBatchSizeBytes()) {
                    this.flushBatch();
                }
            }

            @DoFn.FinishBundle
            public void finishBundle(DoFn.FinishBundleContext context) throws Exception {
                this.flushBatch();
            }

            private void flushBatch() throws IOException {
                if (this.batch.isEmpty()) {
                    return;
                }
                StringBuilder bulkRequest = new StringBuilder();
                for (String json : this.batch) {
                    bulkRequest.append(json);
                }
                this.batch.clear();
                this.currentBatchSizeBytes = 0L;
                String endPoint = String.format("/%s/%s/_bulk", this.spec.getConnectionConfiguration().getIndex(), this.spec.getConnectionConfiguration().getType());
                NStringEntity requestBody = new NStringEntity(bulkRequest.toString(), ContentType.APPLICATION_JSON);
                Response response = this.restClient.performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)requestBody, new Header[0]);
                ElasticsearchIO.checkForErrors(response, this.backendVersion);
            }

            @DoFn.Teardown
            public void closeClient() throws Exception {
                if (this.restClient != null) {
                    this.restClient.close();
                }
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setConnectionConfiguration(ConnectionConfiguration var1);

            abstract Builder setMaxBatchSize(long var1);

            abstract Builder setMaxBatchSizeBytes(long var1);

            abstract Write build();
        }
    }

    private static class BoundedElasticsearchReader
    extends BoundedSource.BoundedReader<String> {
        private final BoundedElasticsearchSource source;
        private RestClient restClient;
        private String current;
        private String scrollId;
        private ListIterator<String> batchIterator;

        private BoundedElasticsearchReader(BoundedElasticsearchSource source) {
            this.source = source;
        }

        public boolean start() throws IOException {
            this.restClient = this.source.spec.getConnectionConfiguration().createClient();
            String query = this.source.spec.getQuery();
            if (query == null) {
                query = "{\"query\": { \"match_all\": {} }}";
            }
            if (this.source.backendVersion == 5 && this.source.numSlices != null && this.source.numSlices > 1) {
                String sliceQuery = String.format("\"slice\": {\"id\": %s,\"max\": %s}", this.source.sliceId, this.source.numSlices);
                query = query.replaceFirst("\\{", "{" + sliceQuery + ",");
            }
            String endPoint = String.format("/%s/%s/_search", this.source.spec.getConnectionConfiguration().getIndex(), this.source.spec.getConnectionConfiguration().getType());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("scroll", this.source.spec.getScrollKeepalive());
            if (this.source.backendVersion == 2) {
                params.put("size", String.valueOf(this.source.spec.getBatchSize()));
                if (this.source.shardPreference != null) {
                    params.put("preference", "_shards:" + this.source.shardPreference);
                }
            }
            NStringEntity queryEntity = new NStringEntity(query, ContentType.APPLICATION_JSON);
            Response response = this.restClient.performRequest("GET", endPoint, params, (HttpEntity)queryEntity, new Header[0]);
            JsonNode searchResult = ElasticsearchIO.parseResponse(response);
            this.updateScrollId(searchResult);
            return this.readNextBatchAndReturnFirstDocument(searchResult);
        }

        private void updateScrollId(JsonNode searchResult) {
            this.scrollId = searchResult.path("_scroll_id").asText();
        }

        public boolean advance() throws IOException {
            if (this.batchIterator.hasNext()) {
                this.current = this.batchIterator.next();
                return true;
            }
            String requestBody = String.format("{\"scroll\" : \"%s\",\"scroll_id\" : \"%s\"}", this.source.spec.getScrollKeepalive(), this.scrollId);
            NStringEntity scrollEntity = new NStringEntity(requestBody, ContentType.APPLICATION_JSON);
            Response response = this.restClient.performRequest("GET", "/_search/scroll", Collections.emptyMap(), (HttpEntity)scrollEntity, new Header[0]);
            JsonNode searchResult = ElasticsearchIO.parseResponse(response);
            this.updateScrollId(searchResult);
            return this.readNextBatchAndReturnFirstDocument(searchResult);
        }

        private boolean readNextBatchAndReturnFirstDocument(JsonNode searchResult) {
            JsonNode hits = searchResult.path("hits").path("hits");
            if (hits.size() == 0) {
                this.current = null;
                this.batchIterator = null;
                return false;
            }
            ArrayList<String> batch = new ArrayList<String>();
            for (JsonNode hit : hits) {
                String document = hit.path("_source").toString();
                batch.add(document);
            }
            this.batchIterator = batch.listIterator();
            this.current = this.batchIterator.next();
            return true;
        }

        public String getCurrent() throws NoSuchElementException {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            return this.current;
        }

        public void close() throws IOException {
            String requestBody = String.format("{\"scroll_id\" : [\"%s\"]}", this.scrollId);
            NStringEntity entity = new NStringEntity(requestBody, ContentType.APPLICATION_JSON);
            try {
                this.restClient.performRequest("DELETE", "/_search/scroll", Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            }
            finally {
                if (this.restClient != null) {
                    this.restClient.close();
                }
            }
        }

        public BoundedSource<String> getCurrentSource() {
            return this.source;
        }
    }

    @VisibleForTesting
    public static class BoundedElasticsearchSource
    extends BoundedSource<String> {
        private int backendVersion;
        private final Read spec;
        @Nullable
        private final String shardPreference;
        @Nullable
        private final Integer numSlices;
        @Nullable
        private final Integer sliceId;

        private BoundedElasticsearchSource(Read spec, @Nullable String shardPreference, @Nullable Integer numSlices, @Nullable Integer sliceId, int backendVersion) {
            this.backendVersion = backendVersion;
            this.spec = spec;
            this.shardPreference = shardPreference;
            this.numSlices = numSlices;
            this.sliceId = sliceId;
        }

        @VisibleForTesting
        BoundedElasticsearchSource(Read spec, @Nullable String shardPreference, @Nullable Integer numSlices, @Nullable Integer sliceId) {
            this.spec = spec;
            this.shardPreference = shardPreference;
            this.numSlices = numSlices;
            this.sliceId = sliceId;
        }

        public List<? extends BoundedSource<String>> split(long desiredBundleSizeBytes, PipelineOptions options) throws Exception {
            ConnectionConfiguration connectionConfiguration = this.spec.getConnectionConfiguration();
            this.backendVersion = ElasticsearchIO.getBackendVersion(connectionConfiguration);
            ArrayList<BoundedElasticsearchSource> sources = new ArrayList<BoundedElasticsearchSource>();
            if (this.backendVersion == 2) {
                JsonNode statsJson = BoundedElasticsearchSource.getStats(connectionConfiguration, true);
                JsonNode shardsJson = statsJson.path("indices").path(connectionConfiguration.getIndex()).path("shards");
                Iterator shards = shardsJson.fields();
                while (shards.hasNext()) {
                    Map.Entry shardJson = (Map.Entry)shards.next();
                    String shardId = (String)shardJson.getKey();
                    sources.add(new BoundedElasticsearchSource(this.spec, shardId, null, null, this.backendVersion));
                }
                Preconditions.checkArgument(!sources.isEmpty(), "No shard found");
            } else if (this.backendVersion == 5) {
                long indexSize = BoundedElasticsearchSource.estimateIndexSize(connectionConfiguration);
                float nbBundlesFloat = (float)indexSize / (float)desiredBundleSizeBytes;
                int nbBundles = (int)Math.ceil(nbBundlesFloat);
                if (nbBundles > 1024) {
                    nbBundles = 1024;
                }
                for (int i = 0; i < nbBundles; ++i) {
                    sources.add(new BoundedElasticsearchSource(this.spec, null, nbBundles, i, this.backendVersion));
                }
            }
            return sources;
        }

        public long getEstimatedSizeBytes(PipelineOptions options) throws IOException {
            return BoundedElasticsearchSource.estimateIndexSize(this.spec.getConnectionConfiguration());
        }

        @VisibleForTesting
        static long estimateIndexSize(ConnectionConfiguration connectionConfiguration) throws IOException {
            JsonNode statsJson = BoundedElasticsearchSource.getStats(connectionConfiguration, false);
            JsonNode indexStats = statsJson.path("indices").path(connectionConfiguration.getIndex()).path("primaries");
            JsonNode store = indexStats.path("store");
            return store.path("size_in_bytes").asLong();
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            this.spec.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"shard", (String)this.shardPreference));
            builder.addIfNotNull(DisplayData.item((String)"numSlices", (Integer)this.numSlices));
            builder.addIfNotNull(DisplayData.item((String)"sliceId", (Integer)this.sliceId));
        }

        public BoundedSource.BoundedReader<String> createReader(PipelineOptions options) throws IOException {
            return new BoundedElasticsearchReader(this);
        }

        public void validate() {
            this.spec.validate(null);
        }

        public Coder<String> getOutputCoder() {
            return StringUtf8Coder.of();
        }

        private static JsonNode getStats(ConnectionConfiguration connectionConfiguration, boolean shardLevel) throws IOException {
            HashMap<String, String> params = new HashMap<String, String>();
            if (shardLevel) {
                params.put("level", "shards");
            }
            String endpoint = String.format("/%s/_stats", connectionConfiguration.getIndex());
            try (RestClient restClient = connectionConfiguration.createClient();){
                JsonNode jsonNode = ElasticsearchIO.parseResponse(restClient.performRequest("GET", endpoint, params, new Header[0]));
                return jsonNode;
            }
        }
    }

    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<String>> {
        private static final long MAX_BATCH_SIZE = 10000L;

        @Nullable
        abstract ConnectionConfiguration getConnectionConfiguration();

        @Nullable
        abstract String getQuery();

        abstract String getScrollKeepalive();

        abstract long getBatchSize();

        abstract Builder builder();

        public Read withConnectionConfiguration(ConnectionConfiguration connectionConfiguration) {
            Preconditions.checkArgument(connectionConfiguration != null, "connectionConfiguration can not be null");
            return this.builder().setConnectionConfiguration(connectionConfiguration).build();
        }

        public Read withQuery(String query) {
            Preconditions.checkArgument(query != null, "query can not be null");
            Preconditions.checkArgument(!query.isEmpty(), "query can not be empty");
            return this.builder().setQuery(query).build();
        }

        public Read withScrollKeepalive(String scrollKeepalive) {
            Preconditions.checkArgument(scrollKeepalive != null, "scrollKeepalive can not be null");
            Preconditions.checkArgument(!scrollKeepalive.equals("0m"), "scrollKeepalive can not be 0m");
            return this.builder().setScrollKeepalive(scrollKeepalive).build();
        }

        public Read withBatchSize(long batchSize) {
            Preconditions.checkArgument(batchSize > 0L && batchSize <= 10000L, "batchSize must be > 0 and <= %d, but was: %d", 10000L, batchSize);
            return this.builder().setBatchSize(batchSize).build();
        }

        public PCollection<String> expand(PBegin input) {
            ConnectionConfiguration connectionConfiguration = this.getConnectionConfiguration();
            Preconditions.checkState(connectionConfiguration != null, "withConnectionConfiguration() is required");
            return (PCollection)input.apply((PTransform)org.apache.beam.sdk.io.Read.from((BoundedSource)new BoundedElasticsearchSource(this, null, null, null)));
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"query", (String)this.getQuery()));
            builder.addIfNotNull(DisplayData.item((String)"batchSize", (Long)this.getBatchSize()));
            builder.addIfNotNull(DisplayData.item((String)"scrollKeepalive", (String)this.getScrollKeepalive()));
            this.getConnectionConfiguration().populateDisplayData(builder);
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setConnectionConfiguration(ConnectionConfiguration var1);

            abstract Builder setQuery(String var1);

            abstract Builder setScrollKeepalive(String var1);

            abstract Builder setBatchSize(long var1);

            abstract Read build();
        }
    }

    @AutoValue
    public static abstract class ConnectionConfiguration
    implements Serializable {
        public abstract List<String> getAddresses();

        @Nullable
        public abstract String getUsername();

        @Nullable
        public abstract String getPassword();

        @Nullable
        public abstract String getKeystorePath();

        @Nullable
        public abstract String getKeystorePassword();

        public abstract String getIndex();

        public abstract String getType();

        abstract Builder builder();

        public static ConnectionConfiguration create(String[] addresses, String index, String type) {
            Preconditions.checkArgument(addresses != null, "addresses can not be null");
            Preconditions.checkArgument(addresses.length > 0, "addresses can not be empty");
            Preconditions.checkArgument(index != null, "index can not be null");
            Preconditions.checkArgument(type != null, "type can not be null");
            ConnectionConfiguration connectionConfiguration = new AutoValue_ElasticsearchIO_ConnectionConfiguration.Builder().setAddresses(Arrays.asList(addresses)).setIndex(index).setType(type).build();
            return connectionConfiguration;
        }

        public ConnectionConfiguration withUsername(String username) {
            Preconditions.checkArgument(username != null, "username can not be null");
            Preconditions.checkArgument(!username.isEmpty(), "username can not be empty");
            return this.builder().setUsername(username).build();
        }

        public ConnectionConfiguration withPassword(String password) {
            Preconditions.checkArgument(password != null, "password can not be null");
            Preconditions.checkArgument(!password.isEmpty(), "password can not be empty");
            return this.builder().setPassword(password).build();
        }

        public ConnectionConfiguration withKeystorePath(String keystorePath) {
            Preconditions.checkArgument(keystorePath != null, "keystorePath can not be null");
            Preconditions.checkArgument(!keystorePath.isEmpty(), "keystorePath can not be empty");
            return this.builder().setKeystorePath(keystorePath).build();
        }

        public ConnectionConfiguration withKeystorePassword(String keystorePassword) {
            Preconditions.checkArgument(keystorePassword != null, "keystorePassword can not be null");
            return this.builder().setKeystorePassword(keystorePassword).build();
        }

        private void populateDisplayData(DisplayData.Builder builder) {
            builder.add(DisplayData.item((String)"address", (String)this.getAddresses().toString()));
            builder.add(DisplayData.item((String)"index", (String)this.getIndex()));
            builder.add(DisplayData.item((String)"type", (String)this.getType()));
            builder.addIfNotNull(DisplayData.item((String)"username", (String)this.getUsername()));
            builder.addIfNotNull(DisplayData.item((String)"keystore.path", (String)this.getKeystorePath()));
        }

        @VisibleForTesting
        RestClient createClient() throws IOException {
            HttpHost[] hosts = new HttpHost[this.getAddresses().size()];
            int i = 0;
            for (String address : this.getAddresses()) {
                URL url = new URL(address);
                hosts[i] = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
                ++i;
            }
            RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])hosts);
            if (this.getUsername() != null) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.getUsername(), this.getPassword()));
                restClientBuilder.setHttpClientConfigCallback(arg_0 -> ConnectionConfiguration.lambda$createClient$0((CredentialsProvider)credentialsProvider, arg_0));
            }
            if (this.getKeystorePath() != null && !this.getKeystorePath().isEmpty()) {
                try {
                    KeyStore keyStore = KeyStore.getInstance("jks");
                    try (FileInputStream is = new FileInputStream(new File(this.getKeystorePath()));){
                        String keystorePassword = this.getKeystorePassword();
                        keyStore.load(is, keystorePassword == null ? null : keystorePassword.toCharArray());
                    }
                    SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(keyStore, (TrustStrategy)new TrustSelfSignedStrategy()).build();
                    SSLIOSessionStrategy sessionStrategy = new SSLIOSessionStrategy(sslContext);
                    restClientBuilder.setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setSSLContext(sslContext).setSSLStrategy((SchemeIOSessionStrategy)sessionStrategy));
                }
                catch (Exception e) {
                    throw new IOException("Can't load the client certificate from the keystore", e);
                }
            }
            return restClientBuilder.build();
        }

        private static /* synthetic */ HttpAsyncClientBuilder lambda$createClient$0(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpAsyncClientBuilder) {
            return httpAsyncClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setAddresses(List<String> var1);

            abstract Builder setUsername(String var1);

            abstract Builder setPassword(String var1);

            abstract Builder setKeystorePath(String var1);

            abstract Builder setKeystorePassword(String var1);

            abstract Builder setIndex(String var1);

            abstract Builder setType(String var1);

            abstract ConnectionConfiguration build();
        }
    }
}

