/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.elasticsearch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.elasticsearch.AutoValue_ElasticsearchIO_ConnectionConfiguration;
import org.apache.beam.sdk.io.elasticsearch.AutoValue_ElasticsearchIO_Read;
import org.apache.beam.sdk.io.elasticsearch.AutoValue_ElasticsearchIO_Write;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdks.java.io.elasticsearch.repackaged.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.sdks.java.io.elasticsearch.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.sdks.java.io.elasticsearch.repackaged.com.google.common.base.Strings;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.entity.NStringEntity;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;

@Experimental
public class ElasticsearchIO {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static Read read() {
        return new AutoValue_ElasticsearchIO_Read.Builder().setScrollKeepalive("5m").setBatchSize(100L).build();
    }

    public static Write write() {
        return new AutoValue_ElasticsearchIO_Write.Builder().setMaxBatchSize(1000L).setMaxBatchSizeBytes(0x500000L).build();
    }

    private ElasticsearchIO() {
    }

    private static JsonNode parseResponse(Response response) throws IOException {
        return (JsonNode)mapper.readValue(response.getEntity().getContent(), JsonNode.class);
    }

    public static abstract class Write
    extends PTransform<PCollection<String>, PDone> {
        @Nullable
        abstract ConnectionConfiguration getConnectionConfiguration();

        abstract long getMaxBatchSize();

        abstract long getMaxBatchSizeBytes();

        abstract Builder builder();

        public Write withConnectionConfiguration(ConnectionConfiguration connectionConfiguration) {
            Preconditions.checkArgument(connectionConfiguration != null, "ElasticsearchIO.write().withConnectionConfiguration(configuration) called with null configuration");
            return this.builder().setConnectionConfiguration(connectionConfiguration).build();
        }

        public Write withMaxBatchSize(long batchSize) {
            Preconditions.checkArgument(batchSize > 0L, "ElasticsearchIO.write().withMaxBatchSize(batchSize) called with incorrect <= 0 value");
            return this.builder().setMaxBatchSize(batchSize).build();
        }

        public Write withMaxBatchSizeBytes(long batchSizeBytes) {
            Preconditions.checkArgument(batchSizeBytes > 0L, "ElasticsearchIO.write().withMaxBatchSizeBytes(batchSizeBytes) called with incorrect <= 0 value");
            return this.builder().setMaxBatchSizeBytes(batchSizeBytes).build();
        }

        public void validate(PipelineOptions options) {
            Preconditions.checkState(this.getConnectionConfiguration() != null, "ElasticsearchIO.write() requires a connection configuration to be set via withConnectionConfiguration(configuration)");
        }

        public PDone expand(PCollection<String> input) {
            input.apply((PTransform)ParDo.of((DoFn)new WriteFn(this)));
            return PDone.in((Pipeline)input.getPipeline());
        }

        @VisibleForTesting
        static class WriteFn
        extends DoFn<String, Void> {
            private final Write spec;
            private transient RestClient restClient;
            private ArrayList<String> batch;
            private long currentBatchSizeBytes;

            WriteFn(Write spec) {
                this.spec = spec;
            }

            @DoFn.Setup
            public void createClient() throws Exception {
                this.restClient = this.spec.getConnectionConfiguration().createClient();
            }

            @DoFn.StartBundle
            public void startBundle(DoFn.StartBundleContext context) throws Exception {
                this.batch = new ArrayList();
                this.currentBatchSizeBytes = 0L;
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext context) throws Exception {
                String document = (String)context.element();
                this.batch.add(String.format("{ \"index\" : {} }%n%s%n", document));
                this.currentBatchSizeBytes += (long)document.getBytes().length;
                if ((long)this.batch.size() >= this.spec.getMaxBatchSize() || this.currentBatchSizeBytes >= this.spec.getMaxBatchSizeBytes()) {
                    this.flushBatch();
                }
            }

            @DoFn.FinishBundle
            public void finishBundle(DoFn.FinishBundleContext context) throws Exception {
                this.flushBatch();
            }

            private void flushBatch() throws IOException {
                if (this.batch.isEmpty()) {
                    return;
                }
                StringBuilder bulkRequest = new StringBuilder();
                for (String json : this.batch) {
                    bulkRequest.append(json);
                }
                this.batch.clear();
                this.currentBatchSizeBytes = 0L;
                String endPoint = String.format("/%s/%s/_bulk", this.spec.getConnectionConfiguration().getIndex(), this.spec.getConnectionConfiguration().getType());
                NStringEntity requestBody = new NStringEntity(bulkRequest.toString(), ContentType.APPLICATION_JSON);
                Response response = this.restClient.performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)requestBody, new Header[]{new BasicHeader("", "")});
                JsonNode searchResult = ElasticsearchIO.parseResponse(response);
                boolean errors = searchResult.path("errors").asBoolean();
                if (errors) {
                    StringBuilder errorMessages = new StringBuilder("Error writing to Elasticsearch, some elements could not be inserted:");
                    JsonNode items = searchResult.path("items");
                    for (JsonNode item : items) {
                        JsonNode creationObject = item.path("create");
                        JsonNode error = creationObject.get("error");
                        if (error == null) continue;
                        String type = error.path("type").asText();
                        String reason = error.path("reason").asText();
                        String docId = creationObject.path("_id").asText();
                        errorMessages.append(String.format("%nDocument id %s: %s (%s)", docId, reason, type));
                        JsonNode causedBy = error.get("caused_by");
                        if (causedBy == null) continue;
                        String cbReason = causedBy.path("reason").asText();
                        String cbType = causedBy.path("type").asText();
                        errorMessages.append(String.format("%nCaused by: %s (%s)", cbReason, cbType));
                    }
                    throw new IOException(errorMessages.toString());
                }
            }

            @DoFn.Teardown
            public void closeClient() throws Exception {
                if (this.restClient != null) {
                    this.restClient.close();
                }
            }
        }

        static abstract class Builder {
            Builder() {
            }

            abstract Builder setConnectionConfiguration(ConnectionConfiguration var1);

            abstract Builder setMaxBatchSize(long var1);

            abstract Builder setMaxBatchSizeBytes(long var1);

            abstract Write build();
        }
    }

    private static class BoundedElasticsearchReader
    extends BoundedSource.BoundedReader<String> {
        private final BoundedElasticsearchSource source;
        private RestClient restClient;
        private String current;
        private String scrollId;
        private ListIterator<String> batchIterator;

        private BoundedElasticsearchReader(BoundedElasticsearchSource source) {
            this.source = source;
        }

        public boolean start() throws IOException {
            this.restClient = this.source.spec.getConnectionConfiguration().createClient();
            String query = this.source.spec.getQuery();
            if (query == null) {
                query = "{ \"query\": { \"match_all\": {} } }";
            }
            String endPoint = String.format("/%s/%s/_search", this.source.spec.getConnectionConfiguration().getIndex(), this.source.spec.getConnectionConfiguration().getType());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("scroll", this.source.spec.getScrollKeepalive());
            params.put("size", String.valueOf(this.source.spec.getBatchSize()));
            if (this.source.shardPreference != null) {
                params.put("preference", "_shards:" + this.source.shardPreference);
            }
            NStringEntity queryEntity = new NStringEntity(query, ContentType.APPLICATION_JSON);
            Response response = this.restClient.performRequest("GET", endPoint, params, (HttpEntity)queryEntity, new Header[]{new BasicHeader("", "")});
            JsonNode searchResult = ElasticsearchIO.parseResponse(response);
            this.updateScrollId(searchResult);
            return this.readNextBatchAndReturnFirstDocument(searchResult);
        }

        private void updateScrollId(JsonNode searchResult) {
            this.scrollId = searchResult.path("_scroll_id").asText();
        }

        public boolean advance() throws IOException {
            if (this.batchIterator.hasNext()) {
                this.current = this.batchIterator.next();
                return true;
            }
            String requestBody = String.format("{\"scroll\" : \"%s\",\"scroll_id\" : \"%s\"}", this.source.spec.getScrollKeepalive(), this.scrollId);
            NStringEntity scrollEntity = new NStringEntity(requestBody, ContentType.APPLICATION_JSON);
            Response response = this.restClient.performRequest("GET", "/_search/scroll", Collections.emptyMap(), (HttpEntity)scrollEntity, new Header[]{new BasicHeader("", "")});
            JsonNode searchResult = ElasticsearchIO.parseResponse(response);
            this.updateScrollId(searchResult);
            return this.readNextBatchAndReturnFirstDocument(searchResult);
        }

        private boolean readNextBatchAndReturnFirstDocument(JsonNode searchResult) {
            JsonNode hits = searchResult.path("hits").path("hits");
            if (hits.size() == 0) {
                this.current = null;
                this.batchIterator = null;
                return false;
            }
            ArrayList<String> batch = new ArrayList<String>();
            for (JsonNode hit : hits) {
                String document = hit.path("_source").toString();
                batch.add(document);
            }
            this.batchIterator = batch.listIterator();
            this.current = this.batchIterator.next();
            return true;
        }

        public String getCurrent() throws NoSuchElementException {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            return this.current;
        }

        public void close() throws IOException {
            String requestBody = String.format("{\"scroll_id\" : [\"%s\"]}", this.scrollId);
            NStringEntity entity = new NStringEntity(requestBody, ContentType.APPLICATION_JSON);
            try {
                this.restClient.performRequest("DELETE", "/_search/scroll", Collections.emptyMap(), (HttpEntity)entity, new Header[]{new BasicHeader("", "")});
            }
            finally {
                if (this.restClient != null) {
                    this.restClient.close();
                }
            }
        }

        public BoundedSource<String> getCurrentSource() {
            return this.source;
        }
    }

    @VisibleForTesting
    static class BoundedElasticsearchSource
    extends BoundedSource<String> {
        private final Read spec;
        @Nullable
        private final String shardPreference;

        BoundedElasticsearchSource(Read spec, @Nullable String shardPreference) {
            this.spec = spec;
            this.shardPreference = shardPreference;
        }

        public List<? extends BoundedSource<String>> split(long desiredBundleSizeBytes, PipelineOptions options) throws Exception {
            ArrayList<BoundedElasticsearchSource> sources = new ArrayList<BoundedElasticsearchSource>();
            JsonNode statsJson = this.getStats(true);
            JsonNode shardsJson = statsJson.path("indices").path(this.spec.getConnectionConfiguration().getIndex()).path("shards");
            Iterator shards = shardsJson.fields();
            while (shards.hasNext()) {
                Map.Entry shardJson = (Map.Entry)shards.next();
                String shardId = (String)shardJson.getKey();
                JsonNode value = (JsonNode)shardJson.getValue();
                boolean isPrimaryShard = value.path(0).path("routing").path("primary").asBoolean();
                if (!isPrimaryShard) continue;
                sources.add(new BoundedElasticsearchSource(this.spec, shardId));
            }
            Preconditions.checkArgument(!sources.isEmpty(), "No primary shard found");
            return sources;
        }

        public long getEstimatedSizeBytes(PipelineOptions options) throws IOException {
            JsonNode statsJson = this.getStats(false);
            JsonNode indexStats = statsJson.path("indices").path(this.spec.getConnectionConfiguration().getIndex()).path("primaries");
            JsonNode store = indexStats.path("store");
            return store.path("size_in_bytes").asLong();
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            this.spec.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"shard", (String)this.shardPreference));
        }

        public BoundedSource.BoundedReader<String> createReader(PipelineOptions options) throws IOException {
            return new BoundedElasticsearchReader(this);
        }

        public void validate() {
            this.spec.validate(null);
        }

        public Coder<String> getDefaultOutputCoder() {
            return StringUtf8Coder.of();
        }

        private JsonNode getStats(boolean shardLevel) throws IOException {
            HashMap<String, String> params = new HashMap<String, String>();
            if (shardLevel) {
                params.put("level", "shards");
            }
            String endpoint = String.format("/%s/_stats", this.spec.getConnectionConfiguration().getIndex());
            try (RestClient restClient = this.spec.getConnectionConfiguration().createClient();){
                JsonNode jsonNode = ElasticsearchIO.parseResponse(restClient.performRequest("GET", endpoint, params, new Header[]{new BasicHeader("", "")}));
                return jsonNode;
            }
        }
    }

    public static abstract class Read
    extends PTransform<PBegin, PCollection<String>> {
        private static final long MAX_BATCH_SIZE = 10000L;

        @Nullable
        abstract ConnectionConfiguration getConnectionConfiguration();

        @Nullable
        abstract String getQuery();

        abstract String getScrollKeepalive();

        abstract long getBatchSize();

        abstract Builder builder();

        public Read withConnectionConfiguration(ConnectionConfiguration connectionConfiguration) {
            Preconditions.checkArgument(connectionConfiguration != null, "ElasticsearchIO.read().withConnectionConfiguration(configuration) called with null configuration");
            return this.builder().setConnectionConfiguration(connectionConfiguration).build();
        }

        public Read withQuery(String query) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(query), "ElasticsearchIO.read().withQuery(query) called with null or empty query");
            return this.builder().setQuery(query).build();
        }

        public Read withScrollKeepalive(String scrollKeepalive) {
            Preconditions.checkArgument(scrollKeepalive != null && !scrollKeepalive.equals("0m"), "ElasticsearchIO.read().withScrollKeepalive(keepalive) called with null or \"0m\" keepalive");
            return this.builder().setScrollKeepalive(scrollKeepalive).build();
        }

        public Read withBatchSize(long batchSize) {
            Preconditions.checkArgument(batchSize > 0L, "ElasticsearchIO.read().withBatchSize(batchSize) called with a negative or equal to 0 value: %s", batchSize);
            Preconditions.checkArgument(batchSize <= 10000L, "ElasticsearchIO.read().withBatchSize(batchSize) called with a too large value (over %s): %s", 10000L, batchSize);
            return this.builder().setBatchSize(batchSize).build();
        }

        public PCollection<String> expand(PBegin input) {
            return (PCollection)input.apply((PTransform)org.apache.beam.sdk.io.Read.from((BoundedSource)new BoundedElasticsearchSource(this, null)));
        }

        public void validate(PipelineOptions options) {
            Preconditions.checkState(this.getConnectionConfiguration() != null, "ElasticsearchIO.read() requires a connection configuration to be set via withConnectionConfiguration(configuration)");
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"query", (String)this.getQuery()));
            this.getConnectionConfiguration().populateDisplayData(builder);
        }

        static abstract class Builder {
            Builder() {
            }

            abstract Builder setConnectionConfiguration(ConnectionConfiguration var1);

            abstract Builder setQuery(String var1);

            abstract Builder setScrollKeepalive(String var1);

            abstract Builder setBatchSize(long var1);

            abstract Read build();
        }
    }

    public static abstract class ConnectionConfiguration
    implements Serializable {
        abstract List<String> getAddresses();

        @Nullable
        abstract String getUsername();

        @Nullable
        abstract String getPassword();

        abstract String getIndex();

        abstract String getType();

        abstract Builder builder();

        public static ConnectionConfiguration create(String[] addresses, String index, String type) throws IOException {
            Preconditions.checkArgument(addresses != null, "ConnectionConfiguration.create(addresses, index, type) called with null address");
            Preconditions.checkArgument(addresses.length != 0, "ConnectionConfiguration.create(addresses, index, type) called with empty addresses");
            Preconditions.checkArgument(index != null, "ConnectionConfiguration.create(addresses, index, type) called with null index");
            Preconditions.checkArgument(type != null, "ConnectionConfiguration.create(addresses, index, type) called with null type");
            ConnectionConfiguration connectionConfiguration = new AutoValue_ElasticsearchIO_ConnectionConfiguration.Builder().setAddresses(Arrays.asList(addresses)).setIndex(index).setType(type).build();
            ConnectionConfiguration.checkVersion(connectionConfiguration);
            return connectionConfiguration;
        }

        private static void checkVersion(ConnectionConfiguration connectionConfiguration) throws IOException {
            RestClient restClient = connectionConfiguration.createClient();
            Response response = restClient.performRequest("GET", "", new Header[]{new BasicHeader("", "")});
            JsonNode jsonNode = ElasticsearchIO.parseResponse(response);
            String version = jsonNode.path("version").path("number").asText();
            boolean version2x = version.startsWith("2.");
            restClient.close();
            Preconditions.checkArgument(version2x, "ConnectionConfiguration.create(addresses, index, type): the Elasticsearch version to connect to is different of 2.x. This version of the ElasticsearchIO is only compatible with Elasticsearch v2.x");
        }

        public ConnectionConfiguration withUsername(String username) {
            Preconditions.checkArgument(username != null, "ConnectionConfiguration.create().withUsername(username) called with null username");
            Preconditions.checkArgument(!username.isEmpty(), "ConnectionConfiguration.create().withUsername(username) called with empty username");
            return this.builder().setUsername(username).build();
        }

        public ConnectionConfiguration withPassword(String password) {
            Preconditions.checkArgument(password != null, "ConnectionConfiguration.create().withPassword(password) called with null password");
            Preconditions.checkArgument(!password.isEmpty(), "ConnectionConfiguration.create().withPassword(password) called with empty password");
            return this.builder().setPassword(password).build();
        }

        private void populateDisplayData(DisplayData.Builder builder) {
            builder.add(DisplayData.item((String)"address", (String)this.getAddresses().toString()));
            builder.add(DisplayData.item((String)"index", (String)this.getIndex()));
            builder.add(DisplayData.item((String)"type", (String)this.getType()));
            builder.addIfNotNull(DisplayData.item((String)"username", (String)this.getUsername()));
        }

        private RestClient createClient() throws MalformedURLException {
            HttpHost[] hosts = new HttpHost[this.getAddresses().size()];
            int i = 0;
            for (String address : this.getAddresses()) {
                URL url = new URL(address);
                hosts[i] = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
                ++i;
            }
            RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])hosts);
            if (this.getUsername() != null) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.getUsername(), this.getPassword()));
                restClientBuilder.setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback((CredentialsProvider)credentialsProvider){
                    final /* synthetic */ CredentialsProvider val$credentialsProvider;
                    {
                        this.val$credentialsProvider = credentialsProvider;
                    }

                    public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpAsyncClientBuilder) {
                        return httpAsyncClientBuilder.setDefaultCredentialsProvider(this.val$credentialsProvider);
                    }
                });
            }
            return restClientBuilder.build();
        }

        static abstract class Builder {
            Builder() {
            }

            abstract Builder setAddresses(List<String> var1);

            abstract Builder setUsername(String var1);

            abstract Builder setPassword(String var1);

            abstract Builder setIndex(String var1);

            abstract Builder setType(String var1);

            abstract ConnectionConfiguration build();
        }
    }
}

