/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.stream;

import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.beam.sdk.fn.stream.OutboundObserverFactory;
import org.apache.beam.sdk.options.ExecutorOptions;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public abstract class HarnessStreamObserverFactories {
    public static @UnknownKeyFor @NonNull @Initialized OutboundObserverFactory fromOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        List experiments = ((ExperimentalOptions)options.as(ExperimentalOptions.class)).getExperiments();
        if (experiments != null && experiments.contains("beam_fn_api_buffered_stream")) {
            int bufferSize = HarnessStreamObserverFactories.getBufferSize(experiments);
            if (bufferSize > 0) {
                return OutboundObserverFactory.clientBuffered((ExecutorService)((ExecutorOptions)options.as(ExecutorOptions.class)).getScheduledExecutorService(), (int)bufferSize);
            }
            return OutboundObserverFactory.clientBuffered((ExecutorService)((ExecutorOptions)options.as(ExecutorOptions.class)).getScheduledExecutorService());
        }
        return OutboundObserverFactory.clientDirect();
    }

    private static @UnknownKeyFor @NonNull @Initialized int getBufferSize(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> experiments) {
        for (String experiment : experiments) {
            if (!experiment.startsWith("beam_fn_api_buffered_stream_buffer_size=")) continue;
            return Integer.parseInt(experiment.substring("beam_fn_api_buffered_stream_buffer_size=".length()));
        }
        return -1;
    }
}

