/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import org.apache.beam.fn.harness.PTransformRunnerFactory;
import org.apache.beam.fn.harness.state.FnApiStateAccessor;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.reflect.DoFnInvoker;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.beam.sdk.util.construction.ParDoTranslation;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.sdk.values.WindowedValues;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

@Internal
public class SplittableSplitAndSizeRestrictionsDoFnRunner<@UnknownKeyFor InputT, @UnknownKeyFor RestrictionT, @UnknownKeyFor PositionT, @UnknownKeyFor WatermarkEstimatorStateT, @UnknownKeyFor OutputT>
implements FnApiStateAccessor.MutatingStateContext<Void, BoundedWindow> {
    private final @UnknownKeyFor @NonNull @Initialized boolean observesWindow;
    private final @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions;
    private final @UnknownKeyFor @NonNull @Initialized DoFnInvoker<InputT, OutputT> doFnInvoker;
    private final @UnknownKeyFor @NonNull @Initialized FnDataReceiver<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized KV<InputT, @UnknownKeyFor @NonNull @Initialized KV<RestrictionT, WatermarkEstimatorStateT>>, @UnknownKeyFor @NonNull @Initialized Double>>> mainOutputConsumer;
    private final @UnknownKeyFor @NonNull @Initialized FnApiStateAccessor<@UnknownKeyFor @Nullable @Initialized Void> stateAccessor;
    private final @UnknownKeyFor @NonNull @Initialized SplittableSplitAndSizeRestrictionsDoFnRunner. @UnknownKeyFor @NonNull @Initialized SplitRestrictionArgumentProvider mutableArgumentProvider;
    private final @UnknownKeyFor @NonNull @Initialized DoFnSchemaInformation doFnSchemaInformation;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputMapping;
    private @Nullable RestrictionT currentRestriction = null;
    private @Nullable WatermarkEstimatorStateT currentWatermarkEstimatorState = null;
    private @Nullable @UnknownKeyFor @Initialized RestrictionTracker<RestrictionT, PositionT> currentTracker;
    private @Nullable @UnknownKeyFor @Initialized WindowedValue<InputT> currentElement;
    private @Nullable @UnknownKeyFor @Initialized BoundedWindow currentWindow;

    SplittableSplitAndSizeRestrictionsDoFnRunner(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform pTransform, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized FnDataReceiver<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> getPCollectionConsumer, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DoFn.BundleFinalizer bundleFinalizer, @UnknownKeyFor @NonNull @Initialized FnApiStateAccessor<@UnknownKeyFor @Nullable @Initialized Void> stateAccessor) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.pipelineOptions = pipelineOptions;
        RunnerApi.ParDoPayload parDoPayload = RunnerApi.ParDoPayload.parseFrom((ByteString)pTransform.getSpec().getPayload());
        DoFn doFn = ParDoTranslation.getDoFn((RunnerApi.ParDoPayload)parDoPayload);
        DoFnSignature doFnSignature = DoFnSignatures.signatureForDoFn((DoFn)doFn);
        this.doFnInvoker = DoFnInvokers.tryInvokeSetupFor((DoFn)doFn, (PipelineOptions)pipelineOptions);
        this.doFnSchemaInformation = ParDoTranslation.getSchemaInformation((RunnerApi.ParDoPayload)parDoPayload);
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((pTransform.getOutputsMap().size() == 1 ? 1 : 0) != 0, (String)"SplitAndSizeRestrictions expects exact one output, but got: ", (int)pTransform.getOutputsMap().size());
        TupleTag mainOutputTag = new TupleTag((String)Iterables.getOnlyElement(pTransform.getOutputsMap().keySet()));
        FnDataReceiver<WindowedValue<?>> mainOutputConsumer = getPCollectionConsumer.apply(pTransform.getOutputsOrThrow(mainOutputTag.getId()));
        this.mainOutputConsumer = mainOutputConsumer;
        this.sideInputMapping = ParDoTranslation.getSideInputMapping((RunnerApi.ParDoPayload)parDoPayload);
        this.observesWindow = doFnSignature.splitRestriction() != null && doFnSignature.splitRestriction().observesWindow() || doFnSignature.newTracker() != null && doFnSignature.newTracker().observesWindow() || doFnSignature.getSize() != null && doFnSignature.getSize().observesWindow() || !this.sideInputMapping.isEmpty();
        this.mutableArgumentProvider = this.observesWindow ? new SizedRestrictionWindowObservingArgumentProvider() : new SizedRestrictionNonWindowObservingArgumentProvider();
        this.stateAccessor = stateAccessor;
    }

    @Override
    public @UnknownKeyFor @Nullable @Initialized Void getCurrentKey() {
        return null;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BoundedWindow getCurrentWindow() {
        return (BoundedWindow)Preconditions.checkStateNotNull((Object)this.currentWindow, (Object)"Attempt to access window outside windowed element processing context.");
    }

    private @UnknownKeyFor @NonNull @Initialized WindowedValue<InputT> getCurrentElement() {
        return (WindowedValue)Preconditions.checkStateNotNull(this.currentElement, (Object)"Attempt to access element outside element processing context.");
    }

    private @UnknownKeyFor @NonNull @Initialized Object getCurrentRestriction() {
        return Preconditions.checkStateNotNull(this.currentRestriction, (Object)"Attempt to access restriction outside element processing context.");
    }

    private WatermarkEstimatorStateT getCurrentWatermarkEstimatorState() {
        Preconditions.checkStateNotNull(this.currentElement, (Object)"Attempt to access watermark estimator state outside element processing context.");
        return this.currentWatermarkEstimatorState;
    }

    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized RestrictionTracker<RestrictionT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getCurrentTracker() {
        return (RestrictionTracker)Preconditions.checkStateNotNull(this.currentTracker, (Object)"Attempt to access restriction tracker state outside element processing context.");
    }

    void processElement(@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<InputT, @UnknownKeyFor @NonNull @Initialized KV<RestrictionT, WatermarkEstimatorStateT>>> elem) {
        if (this.observesWindow) {
            this.processElementForWindowObservingSplitRestriction(elem);
        } else {
            this.processElementForSplitRestriction(elem);
        }
    }

    private void processElementForSplitRestriction(@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<InputT, @UnknownKeyFor @NonNull @Initialized KV<RestrictionT, WatermarkEstimatorStateT>>> elem) {
        this.currentElement = elem.withValue(((KV)elem.getValue()).getKey());
        this.currentRestriction = ((KV)((KV)elem.getValue()).getValue()).getKey();
        this.currentWatermarkEstimatorState = ((KV)((KV)elem.getValue()).getValue()).getValue();
        this.currentTracker = this.doFnInvoker.invokeNewTracker((DoFnInvoker.ArgumentProvider)this.mutableArgumentProvider);
        try {
            this.doFnInvoker.invokeSplitRestriction((DoFnInvoker.ArgumentProvider)this.mutableArgumentProvider);
        }
        finally {
            this.currentElement = null;
            this.currentRestriction = null;
            this.currentWatermarkEstimatorState = null;
            this.currentTracker = null;
        }
        this.stateAccessor.finalizeState();
    }

    private void processElementForWindowObservingSplitRestriction(@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<InputT, @UnknownKeyFor @NonNull @Initialized KV<RestrictionT, WatermarkEstimatorStateT>>> elem) {
        this.currentElement = elem.withValue(((KV)elem.getValue()).getKey());
        this.currentRestriction = ((KV)((KV)elem.getValue()).getValue()).getKey();
        this.currentWatermarkEstimatorState = ((KV)((KV)elem.getValue()).getValue()).getValue();
        try {
            for (BoundedWindow this.currentWindow : elem.getWindows()) {
                this.currentTracker = this.doFnInvoker.invokeNewTracker((DoFnInvoker.ArgumentProvider)this.mutableArgumentProvider);
                this.doFnInvoker.invokeSplitRestriction((DoFnInvoker.ArgumentProvider)this.mutableArgumentProvider);
            }
        }
        finally {
            this.currentElement = null;
            this.currentRestriction = null;
            this.currentWatermarkEstimatorState = null;
            this.currentWindow = null;
            this.currentTracker = null;
        }
        this.stateAccessor.finalizeState();
    }

    private void tearDown() {
        this.doFnInvoker.invokeTeardown();
    }

    private <T> void outputTo(@UnknownKeyFor @NonNull @Initialized FnDataReceiver<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> consumer, @UnknownKeyFor @NonNull @Initialized WindowedValue<T> output) {
        try {
            consumer.accept(output);
        }
        catch (Throwable t) {
            throw UserCodeException.wrap((Throwable)t);
        }
    }

    private abstract class SplitRestrictionArgumentProvider
    extends DoFnInvoker.BaseArgumentProvider<InputT, OutputT>
    implements DoFn.OutputReceiver<RestrictionT> {
        private SplitRestrictionArgumentProvider() {
        }

        public @UnknownKeyFor @NonNull @Initialized String getErrorContext() {
            return "SplitAndSizeRestriction";
        }

        protected @UnknownKeyFor @NonNull @Initialized double getSize(final RestrictionT subrestriction) {
            return SplittableSplitAndSizeRestrictionsDoFnRunner.this.doFnInvoker.invokeGetSize((DoFnInvoker.ArgumentProvider)new DoFnInvoker.DelegatingArgumentProvider<InputT, OutputT>((DoFnInvoker.ArgumentProvider)this, this.getErrorContext() + "/GetSize"){

                public @UnknownKeyFor @NonNull @Initialized Object restriction() {
                    return subrestriction;
                }

                public @UnknownKeyFor @NonNull @Initialized Instant timestamp(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                    return SplittableSplitAndSizeRestrictionsDoFnRunner.this.getCurrentElement().getTimestamp();
                }

                public /*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> restrictionTracker() {
                    return SplittableSplitAndSizeRestrictionsDoFnRunner.this.doFnInvoker.invokeNewTracker((DoFnInvoker.ArgumentProvider)this);
                }
            });
        }

        public @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            return SplittableSplitAndSizeRestrictionsDoFnRunner.this.getCurrentElement().getPaneInfo();
        }

        public InputT element(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            return SplittableSplitAndSizeRestrictionsDoFnRunner.this.getCurrentElement().getValue();
        }

        public @UnknownKeyFor @NonNull @Initialized Object schemaElement(@UnknownKeyFor @NonNull @Initialized int index) {
            SerializableFunction converter = (SerializableFunction)SplittableSplitAndSizeRestrictionsDoFnRunner.this.doFnSchemaInformation.getElementConverters().get(index);
            return converter.apply(SplittableSplitAndSizeRestrictionsDoFnRunner.this.getCurrentElement().getValue());
        }

        public @UnknownKeyFor @NonNull @Initialized Instant timestamp(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            return SplittableSplitAndSizeRestrictionsDoFnRunner.this.getCurrentElement().getTimestamp();
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<OutputT> outputReceiver(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Object restriction() {
            return SplittableSplitAndSizeRestrictionsDoFnRunner.this.getCurrentRestriction();
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> restrictionTracker() {
            return SplittableSplitAndSizeRestrictionsDoFnRunner.this.getCurrentTracker();
        }

        public @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions() {
            return SplittableSplitAndSizeRestrictionsDoFnRunner.this.pipelineOptions;
        }

        public void outputWithTimestamp(RestrictionT output, @UnknownKeyFor @NonNull @Initialized Instant timestamp) {
            throw new UnsupportedOperationException("Cannot outputWithTimestamp from SplitRestriction");
        }
    }

    private class SizedRestrictionNonWindowObservingArgumentProvider
    extends SplitRestrictionArgumentProvider {
        private SizedRestrictionNonWindowObservingArgumentProvider() {
        }

        public void output(RestrictionT subrestriction) {
            double size = this.getSize(subrestriction);
            SplittableSplitAndSizeRestrictionsDoFnRunner.this.outputTo(SplittableSplitAndSizeRestrictionsDoFnRunner.this.mainOutputConsumer, SplittableSplitAndSizeRestrictionsDoFnRunner.this.getCurrentElement().withValue((Object)KV.of((Object)KV.of((Object)SplittableSplitAndSizeRestrictionsDoFnRunner.this.getCurrentElement().getValue(), (Object)KV.of(subrestriction, (Object)SplittableSplitAndSizeRestrictionsDoFnRunner.this.getCurrentWatermarkEstimatorState())), (Object)size)));
        }
    }

    private class SizedRestrictionWindowObservingArgumentProvider
    extends SplitRestrictionArgumentProvider {
        private SizedRestrictionWindowObservingArgumentProvider() {
        }

        public @UnknownKeyFor @NonNull @Initialized BoundedWindow window() {
            return SplittableSplitAndSizeRestrictionsDoFnRunner.this.getCurrentWindow();
        }

        public @UnknownKeyFor @NonNull @Initialized Object sideInput(@UnknownKeyFor @NonNull @Initialized String tagId) {
            PCollectionView pCollectionView = (PCollectionView)Preconditions.checkStateNotNull((Object)((PCollectionView)SplittableSplitAndSizeRestrictionsDoFnRunner.this.sideInputMapping.get(tagId)), (String)"Side input tag not found: %s", (Object)tagId);
            return SplittableSplitAndSizeRestrictionsDoFnRunner.this.stateAccessor.get(pCollectionView, SplittableSplitAndSizeRestrictionsDoFnRunner.this.getCurrentWindow());
        }

        public void output(RestrictionT subrestriction) {
            double size = this.getSize(subrestriction);
            SplittableSplitAndSizeRestrictionsDoFnRunner.this.outputTo(SplittableSplitAndSizeRestrictionsDoFnRunner.this.mainOutputConsumer, WindowedValues.of((Object)KV.of((Object)KV.of((Object)SplittableSplitAndSizeRestrictionsDoFnRunner.this.getCurrentElement().getValue(), (Object)KV.of(subrestriction, (Object)SplittableSplitAndSizeRestrictionsDoFnRunner.this.getCurrentWatermarkEstimatorState())), (Object)size), (Instant)SplittableSplitAndSizeRestrictionsDoFnRunner.this.getCurrentElement().getTimestamp(), (BoundedWindow)SplittableSplitAndSizeRestrictionsDoFnRunner.this.getCurrentWindow(), (PaneInfo)SplittableSplitAndSizeRestrictionsDoFnRunner.this.getCurrentElement().getPaneInfo()));
        }
    }

    static class Factory
    implements PTransformRunnerFactory {
        Factory() {
        }

        @Override
        public final void addRunnerForPTransform(@UnknownKeyFor @NonNull @Initialized PTransformRunnerFactory.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.addRunnerForSplitAndSizeRestriction(context);
        }

        private <InputT, RestrictionT, PositionT, WatermarkEstimatorStateT, OutputT> void addRunnerForSplitAndSizeRestriction(@UnknownKeyFor @NonNull @Initialized PTransformRunnerFactory.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException {
            FnApiStateAccessor<Void> stateAccessor = FnApiStateAccessor.Factory.factoryForPTransformContext(context).create();
            SplittableSplitAndSizeRestrictionsDoFnRunner runner = new SplittableSplitAndSizeRestrictionsDoFnRunner(context.getPipelineOptions(), context.getPTransform(), context.getComponents(), context::getPCollectionConsumer, context.getBundleFinalizer(), stateAccessor);
            stateAccessor.setKeyAndWindowContext(runner);
            context.addPCollectionConsumer(context.getPTransform().getInputsOrThrow(ParDoTranslation.getMainInputName((RunnerApi.PTransformOrBuilder)context.getPTransform())), runner::processElement);
            context.addTearDownFunction(() -> runner.tearDown());
        }
    }

    @AutoService(value={PTransformRunnerFactory.Registrar.class})
    public static class Registrar
    implements PTransformRunnerFactory.Registrar {
        @Override
        public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PTransformRunnerFactory> getPTransformRunnerFactories() {
            return ImmutableMap.builder().put((Object)"beam:transform:sdf_split_and_size_restrictions:v1", (Object)new Factory()).build();
        }
    }
}

