/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date;

import java.math.BigDecimal;
import java.util.Map;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableMap;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.util.TimeUnit;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.joda.time.DurationFieldType;

public abstract class TimeUnitUtils {
    public static final Map<SqlTypeName, DurationFieldType> INTERVALS_DURATIONS_TYPES = ImmutableMap.builder().put(SqlTypeName.INTERVAL_SECOND, DurationFieldType.seconds()).put(SqlTypeName.INTERVAL_MINUTE, DurationFieldType.minutes()).put(SqlTypeName.INTERVAL_HOUR, DurationFieldType.hours()).put(SqlTypeName.INTERVAL_DAY, DurationFieldType.days()).put(SqlTypeName.INTERVAL_MONTH, DurationFieldType.months()).put(SqlTypeName.INTERVAL_YEAR, DurationFieldType.years()).build();

    public static BigDecimal timeUnitInternalMultiplier(SqlTypeName sqlIntervalType) {
        switch (sqlIntervalType) {
            case INTERVAL_SECOND: {
                return TimeUnit.SECOND.multiplier;
            }
            case INTERVAL_MINUTE: {
                return TimeUnit.MINUTE.multiplier;
            }
            case INTERVAL_HOUR: {
                return TimeUnit.HOUR.multiplier;
            }
            case INTERVAL_DAY: {
                return TimeUnit.DAY.multiplier;
            }
            case INTERVAL_MONTH: {
                return TimeUnit.MONTH.multiplier;
            }
            case INTERVAL_YEAR: {
                return TimeUnit.YEAR.multiplier;
            }
        }
        throw new IllegalArgumentException("Interval " + (Object)((Object)sqlIntervalType) + " cannot be converted to TimeUnit");
    }
}

