/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.tree;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.tree.Evaluator;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.tree.Expression;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.tree.ExpressionWriter;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.tree.Shuttle;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.tree.Types;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.tree.Visitor;

public class ParameterExpression
extends Expression {
    private static final AtomicInteger SEQ = new AtomicInteger();
    public final int modifier;
    public final String name;

    public ParameterExpression(Type type) {
        this(0, type, "p" + SEQ.getAndIncrement());
    }

    public ParameterExpression(int modifier, Type type, String name) {
        super(ExpressionType.Parameter, type);
        assert (name != null) : "name should not be null";
        assert (Character.isJavaIdentifierStart(name.charAt(0))) : "parameter name should be valid java identifier: " + name + ". The first character is invalid.";
        this.modifier = modifier;
        this.name = name;
    }

    @Override
    public Expression accept(Shuttle shuttle) {
        return shuttle.visit(this);
    }

    @Override
    public <R> R accept(Visitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Object evaluate(Evaluator evaluator) {
        return evaluator.peek(this);
    }

    @Override
    void accept(ExpressionWriter writer, int lprec, int rprec) {
        writer.append(this.name);
    }

    String declString() {
        return this.declString(this.type);
    }

    String declString(Type type) {
        String modifiers = Modifier.toString(this.modifier);
        return modifiers + (modifiers.isEmpty() ? "" : " ") + Types.className(type) + " " + this.name;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }
}

