/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.sql.impl.AutoValue_TableName;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Splitter;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@AutoValue
public abstract class TableName {
    public abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getPath();

    public abstract @UnknownKeyFor @NonNull @Initialized String getTableName();

    public static @UnknownKeyFor @NonNull @Initialized TableName create(@UnknownKeyFor @NonNull @Initialized String path) {
        ArrayList components = Lists.newArrayList((Iterable)Splitter.on((String)".").split((CharSequence)path));
        return TableName.create(components);
    }

    public static @UnknownKeyFor @NonNull @Initialized TableName create(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> fullPath) {
        Preconditions.checkNotNull(fullPath, (Object)"Full table path cannot be null");
        Preconditions.checkArgument((fullPath.size() > 0 ? 1 : 0) != 0, (Object)"Full table path has to have at least one element");
        return TableName.create(fullPath.subList(0, fullPath.size() - 1), fullPath.get(fullPath.size() - 1));
    }

    public static @UnknownKeyFor @NonNull @Initialized TableName create(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> path, @UnknownKeyFor @NonNull @Initialized String tableName) {
        Preconditions.checkNotNull((Object)tableName, (Object)"Table name cannot be null");
        return new AutoValue_TableName(path == null ? Collections.emptyList() : path, tableName);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isCompound() {
        return this.getPath().size() > 0;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isSimple() {
        return this.getPath().size() == 0;
    }

    public @UnknownKeyFor @NonNull @Initialized String getPrefix() {
        Preconditions.checkState((boolean)this.isCompound());
        return this.getPath().get(0);
    }

    public @UnknownKeyFor @NonNull @Initialized TableName removePrefix() {
        List<String> pathPostfix = this.getPath().stream().skip(1L).collect(Collectors.toList());
        return TableName.create(pathPostfix, this.getTableName());
    }

    @Pure
    public @Nullable @UnknownKeyFor @Initialized String database() {
        return this.isCompound() ? (String)Iterables.getLast(this.getPath()) : null;
    }

    @Pure
    public @Nullable @UnknownKeyFor @Initialized String catalog() {
        return this.getPath().size() > 1 ? this.getPath().get(0) : null;
    }

    @SideEffectFree
    public final @UnknownKeyFor @NonNull @Initialized String toString() {
        ImmutableList components = ImmutableList.builder().addAll(this.getPath()).add((Object)this.getTableName()).build();
        return String.join((CharSequence)".", (Iterable<? extends CharSequence>)components);
    }
}

