/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class TableUtils {
    private static final @UnknownKeyFor @NonNull @Initialized ObjectMapper objectMapper = JsonMapper.builder().enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, JsonReadFeature.ALLOW_JAVA_COMMENTS, JsonReadFeature.ALLOW_MISSING_VALUES, JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS, JsonReadFeature.ALLOW_LEADING_ZEROS_FOR_NUMBERS, JsonReadFeature.ALLOW_SINGLE_QUOTES, JsonReadFeature.ALLOW_TRAILING_COMMA, JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS, JsonReadFeature.ALLOW_UNQUOTED_FIELD_NAMES}).build();

    private TableUtils() {
    }

    @VisibleForTesting
    public static @UnknownKeyFor @NonNull @Initialized ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static @UnknownKeyFor @NonNull @Initialized ObjectNode emptyProperties() {
        return objectMapper.createObjectNode();
    }

    public static @UnknownKeyFor @NonNull @Initialized ObjectNode parseProperties(@UnknownKeyFor @NonNull @Initialized String json) {
        try {
            return (ObjectNode)objectMapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("illegal table properties: " + json);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized ObjectNode parseProperties(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> map) {
        return (ObjectNode)objectMapper.valueToTree(map);
    }

    public static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> convertNode2Map(@UnknownKeyFor @NonNull @Initialized JsonNode jsonNode) {
        return (Map)objectMapper.convertValue((Object)jsonNode, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }
}

