/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelMetadataQuery;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSetOperatorRelBase;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rel.core.SetOp;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rel.core.Union;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BeamUnionRel
extends Union
implements BeamRelNode {
    public BeamUnionRel(@UnknownKeyFor @NonNull @Initialized RelOptCluster cluster, @UnknownKeyFor @NonNull @Initialized RelTraitSet traits, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RelNode> inputs, @UnknownKeyFor @NonNull @Initialized boolean all) {
        super(cluster, traits, inputs, all);
    }

    public @UnknownKeyFor @NonNull @Initialized SetOp copy(@UnknownKeyFor @NonNull @Initialized RelTraitSet traitSet, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RelNode> inputs, @UnknownKeyFor @NonNull @Initialized boolean all) {
        return new BeamUnionRel(this.getCluster(), traitSet, inputs, all);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> buildPTransform() {
        return new BeamSetOperatorRelBase(this, BeamSetOperatorRelBase.OpType.UNION, this.all);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized NodeStats estimateNodeStats(@UnknownKeyFor @NonNull @Initialized BeamRelMetadataQuery mq) {
        NodeStats summationOfEstimates = this.inputs.stream().map(input -> BeamSqlRelUtils.getNodeStats(input, mq)).reduce(NodeStats.create(0.0, 0.0, 0.0), NodeStats::plus);
        summationOfEstimates = this.all ? summationOfEstimates : summationOfEstimates.multiply(0.5);
        return summationOfEstimates;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BeamCostModel beamComputeSelfCost(@UnknownKeyFor @NonNull @Initialized RelOptPlanner planner, @UnknownKeyFor @NonNull @Initialized BeamRelMetadataQuery mq) {
        NodeStats summationOfEstimates = this.inputs.stream().map(input -> BeamSqlRelUtils.getNodeStats(input, mq)).reduce(NodeStats.create(0.0, 0.0, 0.0), NodeStats::plus);
        return BeamCostModel.FACTORY.makeCost(summationOfEstimates.getRowCount(), summationOfEstimates.getRate());
    }
}

