/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelMetadataQuery;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSortRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.transform.BeamBuiltinAnalyticFunctions;
import org.apache.beam.sdk.extensions.sql.impl.transform.agg.AggregationCombineFnAdapter;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.Group;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rel.RelFieldCollation;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rel.core.Window;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rex.RexInputRef;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BeamWindowRel
extends Window
implements BeamRelNode {
    public BeamWindowRel(@UnknownKeyFor @NonNull @Initialized RelOptCluster cluster, @UnknownKeyFor @NonNull @Initialized RelTraitSet traitSet, @UnknownKeyFor @NonNull @Initialized RelNode input, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RexLiteral> constants, @UnknownKeyFor @NonNull @Initialized RelDataType rowType, @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Window.Group> groups) {
        super(cluster, traitSet, input, constants, rowType, groups);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> buildPTransform() {
        Schema outputSchema = CalciteUtils.toSchema(this.getRowType());
        ArrayList analyticFields = Lists.newArrayList();
        this.groups.stream().forEach(anAnalyticGroup -> {
            List partitionKeysDef = anAnalyticGroup.keys.toList();
            ArrayList orderByKeys = Lists.newArrayList();
            ArrayList orderByDirections = Lists.newArrayList();
            ArrayList orderByNullDirections = Lists.newArrayList();
            anAnalyticGroup.orderKeys.getFieldCollations().stream().forEach(fc -> {
                orderByKeys.add(fc.getFieldIndex());
                orderByDirections.add(fc.direction == RelFieldCollation.Direction.ASCENDING);
                orderByNullDirections.add(fc.nullDirection == RelFieldCollation.NullDirection.FIRST);
            });
            BigDecimal lowerB = null;
            BigDecimal upperB = null;
            if (anAnalyticGroup.lowerBound.isCurrentRow()) {
                lowerB = BigDecimal.ZERO;
            } else if (anAnalyticGroup.lowerBound.isPreceding()) {
                if (!anAnalyticGroup.lowerBound.isUnbounded()) {
                    lowerB = this.getLiteralValueConstants(anAnalyticGroup.lowerBound.getOffset());
                }
            } else if (anAnalyticGroup.lowerBound.isFollowing() && !anAnalyticGroup.lowerBound.isUnbounded()) {
                lowerB = this.getLiteralValueConstants(anAnalyticGroup.lowerBound.getOffset()).negate();
            }
            if (anAnalyticGroup.upperBound.isCurrentRow()) {
                upperB = BigDecimal.ZERO;
            } else if (anAnalyticGroup.upperBound.isPreceding()) {
                if (!anAnalyticGroup.upperBound.isUnbounded()) {
                    upperB = this.getLiteralValueConstants(anAnalyticGroup.upperBound.getOffset()).negate();
                }
            } else if (anAnalyticGroup.upperBound.isFollowing() && !anAnalyticGroup.upperBound.isUnbounded()) {
                upperB = this.getLiteralValueConstants(anAnalyticGroup.upperBound.getOffset());
            }
            BigDecimal lowerBFinal = lowerB;
            BigDecimal upperBFinal = upperB;
            List aggregateCalls = anAnalyticGroup.getAggregateCalls((Window)this);
            aggregateCalls.stream().forEach(anAggCall -> {
                List argList = anAggCall.getArgList();
                Schema.Field field = CalciteUtils.toField(anAggCall.getName(), anAggCall.getType());
                Combine.CombineFn<?, ?, ?> combineFn = AggregationCombineFnAdapter.createCombineFnAnalyticsFunctions(anAggCall, field, anAggCall.getAggregation().getName());
                FieldAggregation fieldAggregation = new FieldAggregation(partitionKeysDef, orderByKeys, orderByDirections, orderByNullDirections, lowerBFinal, upperBFinal, anAnalyticGroup.isRows, argList, combineFn, field);
                analyticFields.add(fieldAggregation);
            });
        });
        return new Transform(outputSchema, analyticFields);
    }

    private @UnknownKeyFor @NonNull @Initialized BigDecimal getLiteralValueConstants(@UnknownKeyFor @NonNull @Initialized RexNode n) {
        int idx = ((RexInputRef)n).getIndex() - this.input.getRowType().getFieldCount();
        return (BigDecimal)((RexLiteral)this.constants.get(idx)).getValue();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized NodeStats estimateNodeStats(@UnknownKeyFor @NonNull @Initialized BeamRelMetadataQuery mq) {
        NodeStats inputStat = BeamSqlRelUtils.getNodeStats(this.input, mq);
        return inputStat;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BeamCostModel beamComputeSelfCost(@UnknownKeyFor @NonNull @Initialized RelOptPlanner planner, @UnknownKeyFor @NonNull @Initialized BeamRelMetadataQuery mq) {
        NodeStats inputStat = BeamSqlRelUtils.getNodeStats(this.input, mq);
        float multiplier = 1.125f;
        return BeamCostModel.FACTORY.makeCost(inputStat.getRowCount() * (double)multiplier, inputStat.getRate() * (double)multiplier);
    }

    private static @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized Row> aggField(final @UnknownKeyFor @NonNull @Initialized Schema expectedSchema, final @UnknownKeyFor @NonNull @Initialized FieldAggregation fieldAgg) {
        return new DoFn<List<Row>, Row>(){

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Row> inputPartition, // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> out, /*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                List<Row> sortedRowsAsList = inputPartition;
                NavigableMap<BigDecimal, List<Row>> indexRange = null;
                if (!fieldAgg.rows) {
                    indexRange = this.indexRows(sortedRowsAsList);
                }
                for (int idx = 0; idx < sortedRowsAsList.size(); ++idx) {
                    List<Row> aggRange = null;
                    aggRange = fieldAgg.rows ? this.getRows(sortedRowsAsList, idx) : this.getRange(indexRange, sortedRowsAsList.get(idx));
                    Object accumulator = fieldAgg.combineFn.createAccumulator();
                    int aggFieldIndex = fieldAgg.inputFields.isEmpty() ? -1 : (Integer)fieldAgg.inputFields.get(0);
                    long count = 0L;
                    for (Row aggRow : aggRange) {
                        if (fieldAgg.combineFn instanceof BeamBuiltinAnalyticFunctions.PositionAwareCombineFn) {
                            BeamBuiltinAnalyticFunctions.PositionAwareCombineFn fn = (BeamBuiltinAnalyticFunctions.PositionAwareCombineFn)fieldAgg.combineFn;
                            accumulator = fn.addInput(accumulator, this.getOrderByValue(aggRow), count, Long.valueOf(idx), Long.valueOf(sortedRowsAsList.size()));
                        } else {
                            accumulator = fieldAgg.combineFn.addInput(accumulator, aggRow.getBaseValue(aggFieldIndex));
                        }
                        ++count;
                    }
                    Object result = fieldAgg.combineFn.extractOutput(accumulator);
                    Row processingRow = sortedRowsAsList.get(idx);
                    ArrayList fieldValues = Lists.newArrayListWithCapacity((int)processingRow.getFieldCount());
                    fieldValues.addAll(processingRow.getValues());
                    fieldValues.add(result);
                    Row build = Row.withSchema((Schema)expectedSchema).addValues((List)fieldValues).build();
                    out.output((Object)build);
                }
            }

            private @UnknownKeyFor @NonNull @Initialized NavigableMap<@UnknownKeyFor @NonNull @Initialized BigDecimal, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Row>> indexRows(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Row> input) {
                TreeMap<BigDecimal, List<Row>> map = new TreeMap<BigDecimal, List<Row>>();
                for (Row r : input) {
                    BigDecimal orderByValue = this.getOrderByValue(r);
                    if (orderByValue == null) {
                        orderByValue = BigDecimal.ZERO;
                    }
                    if (!map.containsKey(orderByValue)) {
                        map.put(orderByValue, Lists.newArrayList());
                    }
                    ((List)map.get(orderByValue)).add(r);
                }
                return map;
            }

            private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Row> getRange(@UnknownKeyFor @NonNull @Initialized NavigableMap<@UnknownKeyFor @NonNull @Initialized BigDecimal, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Row>> indexRanges, @UnknownKeyFor @NonNull @Initialized Row aRow) {
                NavigableMap<BigDecimal, List<Row>> subMap;
                BigDecimal ll;
                BigDecimal currentRowValue = this.getOrderByValue(aRow);
                if (currentRowValue != null && fieldAgg.lowerLimit != null && fieldAgg.upperLimit != null) {
                    ll = currentRowValue.subtract(fieldAgg.lowerLimit);
                    BigDecimal ul = currentRowValue.add(fieldAgg.upperLimit);
                    subMap = indexRanges.subMap(ll, true, ul, true);
                } else if (currentRowValue != null && fieldAgg.lowerLimit != null && fieldAgg.upperLimit == null) {
                    ll = currentRowValue.subtract(fieldAgg.lowerLimit);
                    subMap = indexRanges.tailMap(ll, true);
                } else if (currentRowValue != null && fieldAgg.lowerLimit == null && fieldAgg.upperLimit != null) {
                    BigDecimal ul = currentRowValue.add(fieldAgg.upperLimit);
                    subMap = indexRanges.headMap(ul, true);
                } else {
                    subMap = indexRanges;
                }
                ArrayList result = Lists.newArrayList();
                for (List partialList : subMap.values()) {
                    result.addAll(partialList);
                }
                return result;
            }

            private @UnknownKeyFor @NonNull @Initialized BigDecimal getOrderByValue(@UnknownKeyFor @NonNull @Initialized Row r) {
                if (fieldAgg.orderKeys.size() == 0) {
                    return null;
                }
                return new BigDecimal(((Number)r.getBaseValue(((Integer)fieldAgg.orderKeys.get(0)).intValue())).toString());
            }

            private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Row> getRows(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Row> input, @UnknownKeyFor @NonNull @Initialized int index) {
                Integer ll = fieldAgg.lowerLimit != null ? fieldAgg.lowerLimit.intValue() : Integer.MAX_VALUE;
                Integer ul = fieldAgg.upperLimit != null ? fieldAgg.upperLimit.intValue() : Integer.MAX_VALUE;
                int lowerIndex = ll == Integer.MAX_VALUE ? Integer.MIN_VALUE : index - ll;
                int upperIndex = ul == Integer.MAX_VALUE ? Integer.MAX_VALUE : index + ul + 1;
                lowerIndex = lowerIndex < 0 ? 0 : lowerIndex;
                upperIndex = upperIndex > input.size() ? input.size() : upperIndex;
                List<Row> out = input.subList(lowerIndex, upperIndex);
                return out;
            }
        };
    }

    private static @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Row>> sortPartition(final @UnknownKeyFor @NonNull @Initialized FieldAggregation fieldAgg) {
        return new DoFn<Iterable<Row>, List<Row>>(){

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Row> inputPartition, // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Row>> out, /*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                ArrayList partitionRows = Lists.newArrayList(inputPartition);
                BeamSortRel.BeamSqlRowComparator beamSqlRowComparator = new BeamSortRel.BeamSqlRowComparator(fieldAgg.orderKeys, fieldAgg.orderOrientations, fieldAgg.orderNulls);
                Collections.sort(partitionRows, beamSqlRowComparator);
                out.output((Object)partitionRows);
            }
        };
    }

    public @UnknownKeyFor @NonNull @Initialized RelNode copy(@UnknownKeyFor @NonNull @Initialized RelTraitSet traitSet, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RelNode> inputs) {
        return this.copy(traitSet, (RelNode)BeamWindowRel.sole(inputs), (List<RexLiteral>)this.constants, this.rowType, (List<Window.Group>)this.groups);
    }

    public @UnknownKeyFor @NonNull @Initialized Window copy(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RexLiteral> constants) {
        return this.copy(this.traitSet, this.input, constants, this.rowType, (List<Window.Group>)this.groups);
    }

    public @UnknownKeyFor @NonNull @Initialized BeamWindowRel copy(@UnknownKeyFor @NonNull @Initialized RelTraitSet traitSet, @UnknownKeyFor @NonNull @Initialized RelNode input, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RexLiteral> constants, @UnknownKeyFor @NonNull @Initialized RelDataType rowType, @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Window.Group> groups) {
        return new BeamWindowRel(this.getCluster(), traitSet, input, constants, rowType, groups);
    }

    static class SelectOnlyValues
    extends DoFn<KV<Row, Iterable<Row>>, Iterable<Row>> {
        SelectOnlyValues() {
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Row>> inputPartition, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Row>> out, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            out.output((Object)((Iterable)inputPartition.getValue()));
        }
    }

    private static class Transform
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private @UnknownKeyFor @NonNull @Initialized Schema outputSchema;
        private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldAggregation> aggFields;

        public Transform(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldAggregation> fieldAgg) {
            this.outputSchema = schema;
            this.aggFields = fieldAgg;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row> input) {
            PCollection inputData = input.get(0);
            Schema inputSchema = inputData.getSchema();
            int ids = 0;
            for (FieldAggregation af : this.aggFields) {
                String prefix = "transform_" + ++ids;
                Coder rowCoder = inputData.getCoder();
                PCollection partitioned = null;
                if (af.partitionKeys.isEmpty()) {
                    partitioned = (PCollection)inputData.apply(prefix + "globalPartition", (PTransform)Group.globally());
                } else {
                    Group.ByFields myg = Group.byFieldIds((Iterable)af.partitionKeys);
                    PCollection partitionBy = (PCollection)((PCollection)inputData.apply(prefix + "partitionByKV", (PTransform)myg.getToKV())).apply(prefix + "partitionByGK", (PTransform)GroupByKey.create());
                    partitioned = ((PCollection)partitionBy.apply(prefix + "selectOnlyValues", (PTransform)ParDo.of((DoFn)new SelectOnlyValues()))).setCoder((Coder)IterableCoder.of((Coder)rowCoder));
                }
                PCollection sortedPartition = ((PCollection)partitioned.apply(prefix + "orderBy", (PTransform)ParDo.of((DoFn)BeamWindowRel.sortPartition(af)))).setCoder((Coder)ListCoder.of((Coder)rowCoder));
                inputSchema = Schema.builder().addFields(inputSchema.getFields()).addFields(new Schema.Field[]{af.outputField}).build();
                inputData = ((PCollection)sortedPartition.apply(prefix + "aggCall", (PTransform)ParDo.of((DoFn)BeamWindowRel.aggField(inputSchema, af)))).setRowSchema(inputSchema);
            }
            return inputData.setRowSchema(this.outputSchema);
        }
    }

    private static class FieldAggregation
    implements Serializable {
        private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> partitionKeys;
        private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> orderKeys;
        private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> orderOrientations;
        private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> orderNulls;
        private @UnknownKeyFor @NonNull @Initialized BigDecimal lowerLimit = null;
        private @UnknownKeyFor @NonNull @Initialized BigDecimal upperLimit = null;
        private @UnknownKeyFor @NonNull @Initialized boolean rows = true;
        private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> inputFields;
        private // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Combine.CombineFn combineFn;
        private // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.Field outputField;

        public FieldAggregation(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> partitionKeys, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> orderKeys, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> orderOrientations, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> orderNulls, @UnknownKeyFor @NonNull @Initialized BigDecimal lowerLimit, @UnknownKeyFor @NonNull @Initialized BigDecimal upperLimit, @UnknownKeyFor @NonNull @Initialized boolean rows, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> inputFields, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Combine.CombineFn combineFn, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.Field outputField) {
            this.partitionKeys = partitionKeys;
            this.orderKeys = orderKeys;
            this.orderOrientations = orderOrientations;
            this.orderNulls = orderNulls;
            this.lowerLimit = lowerLimit;
            this.upperLimit = upperLimit;
            this.rows = rows;
            this.inputFields = inputFields;
            this.combineFn = combineFn;
            this.outputField = outputField;
        }
    }
}

