/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.parser;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteSchema;
import org.apache.beam.sdk.extensions.sql.impl.parser.BeamSqlParser;
import org.apache.beam.sdk.extensions.sql.impl.parser.SqlDdlNodes;
import org.apache.beam.sdk.extensions.sql.meta.catalog.CatalogManager;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.runtime.Resources;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Schema;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlCreate;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlNodeList;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlUtil;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.util.Pair;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.util.Static;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlCreateCatalog
extends SqlCreate
implements BeamSqlParser.ExecutableStatement {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SqlCreateCatalog.class);
    private final @UnknownKeyFor @NonNull @Initialized SqlIdentifier catalogName;
    private final @UnknownKeyFor @NonNull @Initialized SqlNode type;
    private final @UnknownKeyFor @NonNull @Initialized SqlNodeList properties;
    private static final @UnknownKeyFor @NonNull @Initialized SqlOperator OPERATOR = new SqlSpecialOperator("CREATE CATALOG", SqlKind.OTHER_DDL);

    public SqlCreateCatalog(@UnknownKeyFor @NonNull @Initialized SqlParserPos pos, @UnknownKeyFor @NonNull @Initialized boolean replace, @UnknownKeyFor @NonNull @Initialized boolean ifNotExists, @UnknownKeyFor @NonNull @Initialized SqlNode catalogName, @UnknownKeyFor @NonNull @Initialized SqlNode type, @UnknownKeyFor @NonNull @Initialized SqlNodeList properties) {
        super(OPERATOR, pos, replace, ifNotExists);
        this.catalogName = SqlDdlNodes.getIdentifier(catalogName, pos);
        this.type = (SqlNode)Preconditions.checkArgumentNotNull((Object)type, (String)"Need to specify a TYPE for catalog '%s'", (Object)catalogName);
        this.properties = properties;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SqlNode> getOperandList() {
        ImmutableList.Builder operands = ImmutableList.builder();
        operands.add((Object)this.catalogName);
        operands.add((Object)this.type);
        if (this.properties != null) {
            operands.add((Object)this.properties);
        }
        return operands.build();
    }

    public void unparse(@UnknownKeyFor @NonNull @Initialized SqlWriter writer, @UnknownKeyFor @NonNull @Initialized int leftPrec, @UnknownKeyFor @NonNull @Initialized int rightPrec) {
        writer.keyword("CREATE");
        if (this.getReplace()) {
            writer.keyword("OR REPLACE");
        }
        writer.keyword("CATALOG");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.catalogName.unparse(writer, leftPrec, rightPrec);
        writer.keyword("TYPE");
        this.type.unparse(writer, leftPrec, rightPrec);
        if (this.properties != null && !this.properties.isEmpty()) {
            writer.keyword("PROPERTIES");
            writer.keyword("(");
            for (int i = 0; i < this.properties.size(); ++i) {
                if (i > 0) {
                    writer.keyword(",");
                }
                SqlNode property = this.properties.get(i);
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((boolean)(property instanceof SqlNodeList), (Object)String.format("Unexpected properties entry '%s' of class '%s'", property, property.getClass()));
                SqlNodeList kv = (SqlNodeList)property;
                kv.get(0).unparse(writer, leftPrec, rightPrec);
                writer.keyword("=");
                kv.get(1).unparse(writer, leftPrec, rightPrec);
            }
            writer.keyword(")");
        }
    }

    @Override
    public void execute(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized CalcitePrepare.Context context) {
        Pair<CalciteSchema, String> pair = SqlDdlNodes.schema(context, true, this.catalogName);
        Schema schema = ((CalciteSchema)pair.left).schema;
        String name = (String)pair.right;
        String typeStr = (String)Preconditions.checkArgumentNotNull((Object)SqlDdlNodes.getString(this.type));
        if (!(schema instanceof BeamCalciteSchema)) {
            throw SqlUtil.newContextException((SqlParserPos)this.catalogName.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal("Schema is not of instance BeamCalciteSchema"));
        }
        @Nullable CatalogManager catalogManager = ((BeamCalciteSchema)schema).getCatalogManager();
        if (catalogManager == null) {
            throw SqlUtil.newContextException((SqlParserPos)this.catalogName.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal(String.format("Unexpected 'CREATE CATALOG' call for Schema '%s' that is not a Catalog.", name)));
        }
        if (catalogManager.getCatalog(name) != null) {
            if (this.getReplace()) {
                LOG.info("Replacing existing catalog '{}'", (Object)name);
                catalogManager.dropCatalog(name);
            } else {
                if (!this.ifNotExists) {
                    throw SqlUtil.newContextException((SqlParserPos)this.catalogName.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal(String.format("Catalog '%s' already exists.", name)));
                }
                return;
            }
        }
        catalogManager.createCatalog(name, typeStr, this.parseProperties());
        LOG.info("Catalog '{}' (type: {}) successfully created", (Object)name, (Object)typeStr);
    }

    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> parseProperties() {
        if (this.properties == null || this.properties.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> props = new HashMap<String, String>();
        for (SqlNode property : this.properties) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((boolean)(property instanceof SqlNodeList), (Object)String.format("Unexpected properties entry '%s' of class '%s'", property, property.getClass()));
            SqlNodeList kv = (SqlNodeList)property;
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((kv.size() == 2 ? 1 : 0) != 0, (Object)("Expected 2 items in properties entry, but got " + kv.size()));
            String key = (String)Preconditions.checkStateNotNull((Object)SqlDdlNodes.getString(kv.get(0)));
            String value = (String)Preconditions.checkStateNotNull((Object)SqlDdlNodes.getString(kv.get(1)));
            props.put(key, value);
        }
        return props;
    }
}

