/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.iceberg;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTableFilter;
import org.apache.beam.sdk.io.iceberg.FilterUtils;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexCall;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexInputRef;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.commons.lang3.tuple.Pair;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class IcebergFilter
implements BeamSqlTableFilter {
    private @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized RexNode> supported;
    private @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized RexNode> unsupported;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RexNode> predicateCNF;

    public IcebergFilter(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RexNode> predicateCNF) {
        this.predicateCNF = predicateCNF;
    }

    private void maybeInitialize() {
        if (this.supported != null && this.unsupported != null) {
            return;
        }
        ImmutableList.Builder supportedBuilder = ImmutableList.builder();
        ImmutableList.Builder unsupportedBuilder = ImmutableList.builder();
        for (RexNode node : this.predicateCNF) {
            if (!node.getType().getSqlTypeName().equals((Object)SqlTypeName.BOOLEAN)) {
                throw new IllegalArgumentException("Predicate node '" + node.getClass().getSimpleName() + "' should be a boolean expression, but was: " + node.getType().getSqlTypeName());
            }
            if (((Boolean)this.isSupported(node).getLeft()).booleanValue()) {
                supportedBuilder.add((Object)node);
                continue;
            }
            unsupportedBuilder.add((Object)node);
        }
        this.supported = supportedBuilder.build();
        this.unsupported = unsupportedBuilder.build();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RexNode> getNotSupported() {
        this.maybeInitialize();
        return (List)Preconditions.checkStateNotNull(this.unsupported);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int numSupported() {
        this.maybeInitialize();
        return BeamSqlTableFilter.expressionsInFilter((List)Preconditions.checkStateNotNull(this.supported));
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RexNode> getSupported() {
        this.maybeInitialize();
        return (List)Preconditions.checkStateNotNull(this.supported);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return MoreObjects.toStringHelper(IcebergFilter.class).add("supported", (Object)((List)Preconditions.checkStateNotNull(this.supported)).stream().map(RexNode::toString).collect(Collectors.joining())).add("unsupported", (Object)((List)Preconditions.checkStateNotNull(this.unsupported)).stream().map(RexNode::toString).collect(Collectors.joining())).toString();
    }

    private @UnknownKeyFor @NonNull @Initialized Pair<@UnknownKeyFor @NonNull @Initialized Boolean, @UnknownKeyFor @NonNull @Initialized Integer> isSupported(@UnknownKeyFor @NonNull @Initialized RexNode node) {
        int numberOfInputRefs = 0;
        boolean isSupported = true;
        if (node instanceof RexCall) {
            RexCall compositeNode = (RexCall)node;
            if (!FilterUtils.SUPPORTED_OPS.contains(node.getKind())) {
                isSupported = false;
            } else {
                for (RexNode operand : compositeNode.getOperands()) {
                    Pair<Boolean, Integer> childSupported = this.isSupported(operand);
                    if (!node.getKind().belongsTo((Collection)ImmutableSet.of((Object)SqlKind.AND, (Object)SqlKind.OR))) {
                        numberOfInputRefs += ((Integer)childSupported.getRight()).intValue();
                    }
                    isSupported = numberOfInputRefs < 2 && (Boolean)childSupported.getLeft() != false;
                }
            }
        } else if (node instanceof RexInputRef) {
            numberOfInputRefs = 1;
        } else if (!(node instanceof RexLiteral)) {
            throw new UnsupportedOperationException("Encountered an unexpected node type: " + node.getClass().getSimpleName());
        }
        return Pair.of((Object)isSupported, (Object)numberOfInputRefs);
    }
}

