/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator;

import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.runtime.SqlFunctions;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionEnvironment;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;

public class BeamSqlCastExpression
extends BeamSqlExpression {
    private static final int index = 0;
    private static final DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().append(null, new DateTimeParser[]{DateTimeFormat.forPattern((String)"yy-MM-dd").getParser(), DateTimeFormat.forPattern((String)"yy/MM/dd").getParser(), DateTimeFormat.forPattern((String)"yy.MM.dd").getParser(), DateTimeFormat.forPattern((String)"yyMMdd").getParser(), DateTimeFormat.forPattern((String)"yyyyMMdd").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd").getParser(), DateTimeFormat.forPattern((String)"yyyy/MM/dd").getParser(), DateTimeFormat.forPattern((String)"yyyy.MM.dd").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ssz").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss z").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSSSSSSSS").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSSSSSSSSz").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSSSSSSSS z").getParser()}).toFormatter().withPivotYear(2020);

    public BeamSqlCastExpression(List<BeamSqlExpression> operands, SqlTypeName castType) {
        super(operands, castType);
    }

    @Override
    public boolean accept() {
        return this.numberOfOperands() == 1;
    }

    @Override
    public BeamSqlPrimitive evaluate(Row inputRow, BoundedWindow window, BeamSqlExpressionEnvironment env) {
        SqlTypeName castOutputType = this.getOutputType();
        switch (castOutputType) {
            case BOOLEAN: {
                return BeamSqlPrimitive.of(SqlTypeName.BOOLEAN, SqlFunctions.toBoolean(this.opValueEvaluated(0, inputRow, window, env)));
            }
            case INTEGER: {
                return BeamSqlPrimitive.of(SqlTypeName.INTEGER, SqlFunctions.toInt(this.opValueEvaluated(0, inputRow, window, env)));
            }
            case DOUBLE: {
                return BeamSqlPrimitive.of(SqlTypeName.DOUBLE, SqlFunctions.toDouble(this.opValueEvaluated(0, inputRow, window, env)));
            }
            case SMALLINT: {
                return BeamSqlPrimitive.of(SqlTypeName.SMALLINT, SqlFunctions.toShort(this.opValueEvaluated(0, inputRow, window, env)));
            }
            case TINYINT: {
                return BeamSqlPrimitive.of(SqlTypeName.TINYINT, SqlFunctions.toByte(this.opValueEvaluated(0, inputRow, window, env)));
            }
            case BIGINT: {
                return BeamSqlPrimitive.of(SqlTypeName.BIGINT, SqlFunctions.toLong(this.opValueEvaluated(0, inputRow, window, env)));
            }
            case DECIMAL: {
                return BeamSqlPrimitive.of(SqlTypeName.DECIMAL, SqlFunctions.toBigDecimal(this.opValueEvaluated(0, inputRow, window, env)));
            }
            case FLOAT: {
                return BeamSqlPrimitive.of(SqlTypeName.FLOAT, Float.valueOf(SqlFunctions.toFloat(this.opValueEvaluated(0, inputRow, window, env))));
            }
            case CHAR: 
            case VARCHAR: {
                return BeamSqlPrimitive.of(SqlTypeName.VARCHAR, (String)this.opValueEvaluated(0, inputRow, window, env));
            }
            case DATE: {
                return BeamSqlPrimitive.of(SqlTypeName.DATE, this.toDate(this.opValueEvaluated(0, inputRow, window, env)));
            }
            case TIMESTAMP: {
                return BeamSqlPrimitive.of(SqlTypeName.TIMESTAMP, this.toTimeStamp(this.opValueEvaluated(0, inputRow, window, env)));
            }
        }
        throw new UnsupportedOperationException(String.format("Cast to type %s not supported", new Object[]{castOutputType}));
    }

    private ReadableInstant toDate(Object inputDate) {
        return dateTimeFormatter.parseLocalDate(inputDate.toString()).toDateTimeAtStartOfDay();
    }

    private ReadableInstant toTimeStamp(Object inputTimestamp) {
        return dateTimeFormatter.parseDateTime(inputTimestamp.toString()).secondOfMinute().roundCeilingCopy();
    }
}

