/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.dialect;

import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlAbstractDateTimeLiteral;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlCall;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlDialect;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlFunction;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlKind;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlLiteral;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlUtil;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.ReturnTypes;

public class MssqlSqlDialect
extends SqlDialect {
    public static final SqlDialect DEFAULT = new MssqlSqlDialect(EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.MSSQL).withIdentifierQuoteString("["));
    private static final SqlFunction MSSQL_SUBSTRING = new SqlFunction("SUBSTRING", SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0_NULLABLE_VARYING, null, null, SqlFunctionCategory.STRING);

    public MssqlSqlDialect(SqlDialect.Context context) {
        super(context);
    }

    @Override
    public void unparseDateTimeLiteral(SqlWriter writer, SqlAbstractDateTimeLiteral literal, int leftPrec, int rightPrec) {
        writer.literal("'" + literal.toFormattedString() + "'");
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        if (call.getOperator() == SqlStdOperatorTable.SUBSTRING) {
            if (call.operandCount() != 3) {
                throw new IllegalArgumentException("MSSQL SUBSTRING requires FROM and FOR arguments");
            }
            SqlUtil.unparseFunctionSyntax(MSSQL_SUBSTRING, writer, call);
        } else {
            switch (call.getKind()) {
                case FLOOR: {
                    if (call.operandCount() != 2) {
                        super.unparseCall(writer, call, leftPrec, rightPrec);
                        return;
                    }
                    this.unparseFloor(writer, call);
                    break;
                }
                default: {
                    super.unparseCall(writer, call, leftPrec, rightPrec);
                }
            }
        }
    }

    private void unparseFloor(SqlWriter writer, SqlCall call) {
        SqlLiteral node = (SqlLiteral)call.operand(1);
        TimeUnitRange unit = (TimeUnitRange)((Object)node.getValue());
        switch (unit) {
            case YEAR: {
                this.unparseFloorWithUnit(writer, call, 4, "-01-01");
                break;
            }
            case MONTH: {
                this.unparseFloorWithUnit(writer, call, 7, "-01");
                break;
            }
            case WEEK: {
                writer.print("CONVERT(DATETIME, CONVERT(VARCHAR(10), DATEADD(day, - (6 + DATEPART(weekday, ");
                ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
                writer.print(")) % 7, ");
                ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
                writer.print("), 126))");
                break;
            }
            case DAY: {
                this.unparseFloorWithUnit(writer, call, 10, "");
                break;
            }
            case HOUR: {
                this.unparseFloorWithUnit(writer, call, 13, ":00:00");
                break;
            }
            case MINUTE: {
                this.unparseFloorWithUnit(writer, call, 16, ":00");
                break;
            }
            case SECOND: {
                this.unparseFloorWithUnit(writer, call, 19, ":00");
                break;
            }
            default: {
                throw new IllegalArgumentException("MSSQL does not support FLOOR for time unit: " + (Object)((Object)unit));
            }
        }
    }

    private void unparseFloorWithUnit(SqlWriter writer, SqlCall call, int charLen, String offset) {
        writer.print("CONVERT");
        SqlWriter.Frame frame = writer.startList("(", ")");
        writer.print("DATETIME, CONVERT(VARCHAR(" + charLen + "), ");
        ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        writer.print(", 126)");
        if (offset.length() > 0) {
            writer.print("+'" + offset + "'");
        }
        writer.endList(frame);
    }
}

