/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.util.TimeUnit;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.StructKind;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlCollation;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.SqlValidatorUtil;

public interface RelDataTypeFactory {
    public RelDataTypeSystem getTypeSystem();

    public RelDataType createJavaType(Class var1);

    public RelDataType createJoinType(RelDataType ... var1);

    public RelDataType createStructType(StructKind var1, List<RelDataType> var2, List<String> var3);

    public RelDataType createStructType(List<RelDataType> var1, List<String> var2);

    @Deprecated
    public RelDataType createStructType(FieldInfo var1);

    public RelDataType createStructType(List<? extends Map.Entry<String, RelDataType>> var1);

    public RelDataType createArrayType(RelDataType var1, long var2);

    public RelDataType createMapType(RelDataType var1, RelDataType var2);

    public RelDataType createMultisetType(RelDataType var1, long var2);

    public RelDataType copyType(RelDataType var1);

    public RelDataType createTypeWithNullability(RelDataType var1, boolean var2);

    public RelDataType createTypeWithCharsetAndCollation(RelDataType var1, Charset var2, SqlCollation var3);

    public Charset getDefaultCharset();

    public RelDataType leastRestrictive(List<RelDataType> var1);

    public RelDataType createSqlType(SqlTypeName var1);

    public RelDataType createUnknownType();

    public RelDataType createSqlType(SqlTypeName var1, int var2);

    public RelDataType createSqlType(SqlTypeName var1, int var2, int var3);

    public RelDataType createSqlIntervalType(SqlIntervalQualifier var1);

    public RelDataType createDecimalProduct(RelDataType var1, RelDataType var2);

    public boolean useDoubleMultiplication(RelDataType var1, RelDataType var2);

    public RelDataType createDecimalQuotient(RelDataType var1, RelDataType var2);

    public FieldInfoBuilder builder();

    public static class Builder {
        private final List<String> names = new ArrayList<String>();
        private final List<RelDataType> types = new ArrayList<RelDataType>();
        private StructKind kind = StructKind.FULLY_QUALIFIED;
        private final RelDataTypeFactory typeFactory;

        public Builder(RelDataTypeFactory typeFactory) {
            this.typeFactory = Preconditions.checkNotNull(typeFactory);
        }

        public int getFieldCount() {
            return this.names.size();
        }

        public String getFieldName(int index) {
            return this.names.get(index);
        }

        public RelDataType getFieldType(int index) {
            return this.types.get(index);
        }

        public Builder add(String name, RelDataType type) {
            this.names.add(name);
            this.types.add(type);
            return this;
        }

        public Builder add(String name, SqlTypeName typeName) {
            this.add(name, this.typeFactory.createSqlType(typeName));
            return this;
        }

        public Builder add(String name, SqlTypeName typeName, int precision) {
            this.add(name, this.typeFactory.createSqlType(typeName, precision));
            return this;
        }

        public Builder add(String name, SqlTypeName typeName, int precision, int scale) {
            this.add(name, this.typeFactory.createSqlType(typeName, precision, scale));
            return this;
        }

        public Builder add(String name, TimeUnit startUnit, int startPrecision, TimeUnit endUnit, int fractionalSecondPrecision) {
            SqlIntervalQualifier q = new SqlIntervalQualifier(startUnit, startPrecision, endUnit, fractionalSecondPrecision, SqlParserPos.ZERO);
            this.add(name, this.typeFactory.createSqlIntervalType(q));
            return this;
        }

        public Builder nullable(boolean nullable) {
            RelDataType lastType = this.types.get(this.types.size() - 1);
            if (lastType.isNullable() != nullable) {
                RelDataType type = this.typeFactory.createTypeWithNullability(lastType, nullable);
                this.types.set(this.types.size() - 1, type);
            }
            return this;
        }

        public Builder add(RelDataTypeField field) {
            this.add(field.getName(), field.getType());
            return this;
        }

        public Builder addAll(Iterable<? extends Map.Entry<String, RelDataType>> fields) {
            for (Map.Entry<String, RelDataType> entry : fields) {
                this.add(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public Builder kind(StructKind kind) {
            this.kind = kind;
            return this;
        }

        public Builder uniquify() {
            List<String> uniqueNames = SqlValidatorUtil.uniquify(this.names, this.typeFactory.getTypeSystem().isSchemaCaseSensitive());
            if (uniqueNames != this.names) {
                this.names.clear();
                this.names.addAll(uniqueNames);
            }
            return this;
        }

        public RelDataType build() {
            return this.typeFactory.createStructType(this.kind, this.types, this.names);
        }

        public boolean nameExists(String name) {
            return this.names.contains(name);
        }
    }

    @Deprecated
    public static class FieldInfoBuilder
    extends Builder
    implements FieldInfo {
        public FieldInfoBuilder(RelDataTypeFactory typeFactory) {
            super(typeFactory);
        }

        @Override
        public FieldInfoBuilder add(String name, RelDataType type) {
            return (FieldInfoBuilder)super.add(name, type);
        }

        @Override
        public FieldInfoBuilder add(String name, SqlTypeName typeName) {
            return (FieldInfoBuilder)super.add(name, typeName);
        }

        @Override
        public FieldInfoBuilder add(String name, SqlTypeName typeName, int precision) {
            return (FieldInfoBuilder)super.add(name, typeName, precision);
        }

        @Override
        public FieldInfoBuilder add(String name, SqlTypeName typeName, int precision, int scale) {
            return (FieldInfoBuilder)super.add(name, typeName, precision, scale);
        }

        @Override
        public FieldInfoBuilder add(String name, TimeUnit startUnit, int startPrecision, TimeUnit endUnit, int fractionalSecondPrecision) {
            return (FieldInfoBuilder)super.add(name, startUnit, startPrecision, endUnit, fractionalSecondPrecision);
        }

        @Override
        public FieldInfoBuilder nullable(boolean nullable) {
            return (FieldInfoBuilder)super.nullable(nullable);
        }

        @Override
        public FieldInfoBuilder add(RelDataTypeField field) {
            return (FieldInfoBuilder)super.add(field);
        }

        @Override
        public FieldInfoBuilder addAll(Iterable<? extends Map.Entry<String, RelDataType>> fields) {
            return (FieldInfoBuilder)super.addAll(fields);
        }

        @Override
        public FieldInfoBuilder kind(StructKind kind) {
            return (FieldInfoBuilder)super.kind(kind);
        }

        @Override
        public FieldInfoBuilder uniquify() {
            return (FieldInfoBuilder)super.uniquify();
        }
    }

    @Deprecated
    public static interface FieldInfo {
        public int getFieldCount();

        public String getFieldName(int var1);

        public RelDataType getFieldType(int var1);
    }
}

