/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.text;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import java.io.Serializable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamTableUtils;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.InMemoryMetaTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.InvalidTableException;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.text.AutoValue_TextTableProvider_JsonToRow;
import org.apache.beam.sdk.extensions.sql.meta.provider.text.AutoValue_TextTableProvider_RowToJson;
import org.apache.beam.sdk.extensions.sql.meta.provider.text.TextJsonTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.text.TextTable;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.FlatMapElements;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.ToJson;
import org.apache.beam.sdk.util.RowJson;
import org.apache.beam.sdk.util.RowJsonUtils;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.apache.commons.csv.CSVFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={TableProvider.class})
public class TextTableProvider
extends InMemoryMetaTableProvider {
    @Override
    public @UnknownKeyFor @NonNull @Initialized String getTableType() {
        return "text";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BeamSqlTable buildBeamSqlTable(@UnknownKeyFor @NonNull @Initialized Table table) {
        Schema schema = table.getSchema();
        String filePattern = table.getLocation();
        JSONObject properties = table.getProperties();
        String format = (String)MoreObjects.firstNonNull((Object)properties.getString("format"), (Object)"csv");
        String deadLetterFile = properties.getString("deadLetterFile");
        String legacyCsvFormat = null;
        if (!ImmutableSet.of((Object)"csv", (Object)"lines", (Object)"json").contains((Object)format)) {
            legacyCsvFormat = format;
            format = "csv";
        }
        switch (format) {
            case "csv": {
                String specifiedCsvFormat = properties.getString("csvformat");
                CSVFormat csvFormat = specifiedCsvFormat != null ? CSVFormat.valueOf((String)specifiedCsvFormat) : (legacyCsvFormat != null ? CSVFormat.valueOf((String)legacyCsvFormat) : CSVFormat.DEFAULT);
                return new TextTable(schema, filePattern, new CsvToRow(schema, csvFormat), new RowToCsv(csvFormat));
            }
            case "json": {
                return new TextJsonTable(schema, filePattern, JsonToRow.create(schema, deadLetterFile), RowToJson.create());
            }
            case "lines": {
                if (schema.getFieldCount() != 1 || !schema.getField(0).getType().getTypeName().equals((Object)Schema.TypeName.STRING)) {
                    throw new InvalidTableException("Table with type 'text' and format 'lines' must have exactly one STRING/VARCHAR/CHAR column ");
                }
                return new TextTable(schema, filePattern, new LinesReadConverter(), new LinesWriteConverter());
            }
        }
        throw new InvalidTableException("Table with type 'text' must have format 'csv' or 'lines' or 'json'");
    }

    @VisibleForTesting
    public static class CsvToRow
    extends PTransform<PCollection<String>, PCollection<Row>>
    implements Serializable {
        private @UnknownKeyFor @NonNull @Initialized Schema schema;
        private @UnknownKeyFor @NonNull @Initialized CSVFormat csvFormat;

        @VisibleForTesting
        public @UnknownKeyFor @NonNull @Initialized CSVFormat getCsvFormat() {
            return this.csvFormat;
        }

        public CsvToRow(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized CSVFormat csvFormat) {
            this.schema = schema;
            this.csvFormat = csvFormat;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> input) {
            return ((PCollection)input.apply("csvToRow", (PTransform)FlatMapElements.into((TypeDescriptor)TypeDescriptors.rows()).via((SerializableFunction & Serializable)s -> BeamTableUtils.csvLines2BeamRows(this.csvFormat, s, this.schema)))).setRowSchema(this.schema);
        }
    }

    @VisibleForTesting
    static class RowToCsv
    extends PTransform<PCollection<Row>, PCollection<String>>
    implements Serializable {
        private @UnknownKeyFor @NonNull @Initialized CSVFormat csvFormat;

        public RowToCsv(@UnknownKeyFor @NonNull @Initialized CSVFormat csvFormat) {
            this.csvFormat = csvFormat;
        }

        @VisibleForTesting
        public @UnknownKeyFor @NonNull @Initialized CSVFormat getCsvFormat() {
            return this.csvFormat;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
            return (PCollection)input.apply("rowToCsv", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)row -> BeamTableUtils.beamRow2CsvLine(row, this.csvFormat)));
        }
    }

    @AutoValue
    @Internal
    static abstract class RowToJson
    extends PTransform<PCollection<Row>, PCollection<String>>
    implements Serializable {
        RowToJson() {
        }

        public static @UnknownKeyFor @NonNull @Initialized RowToJson create() {
            return new AutoValue_TextTableProvider_RowToJson();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
            return (PCollection)input.apply((PTransform)ToJson.of());
        }
    }

    @AutoValue
    @Internal
    static abstract class JsonToRow
    extends PTransform<PCollection<String>, PCollection<Row>>
    implements Serializable {
        protected static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized String> DLF_TAG = new TupleTag();
        protected static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Row> MAIN_TAG = new TupleTag();

        JsonToRow() {
        }

        public abstract @UnknownKeyFor @NonNull @Initialized Schema schema();

        public abstract @Nullable @UnknownKeyFor @Initialized String deadLetterFile();

        public static @UnknownKeyFor @NonNull @Initialized JsonToRow create(@UnknownKeyFor @NonNull @Initialized Schema schema, @Nullable @UnknownKeyFor @Initialized String deadLetterFile) {
            return new AutoValue_TextTableProvider_JsonToRow(schema, deadLetterFile);
        }

        public static @UnknownKeyFor @NonNull @Initialized JsonToRow create(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            return JsonToRow.create(schema, null);
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> input) {
            PCollectionTuple rows = (PCollectionTuple)input.apply((PTransform)ParDo.of((DoFn)new DoFn<String, Row>(){

                @DoFn.ProcessElement
                public void processElement(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) {
                    try {
                        context.output((Object)RowJsonUtils.jsonToRow((ObjectMapper)this.getObjectMapper(), (String)((String)context.element())));
                    }
                    catch (RowJson.UnsupportedRowJsonException jsonException) {
                        if (this.deadLetterFile() != null) {
                            context.output(DLF_TAG, (Object)((String)context.element()));
                        }
                        throw new RuntimeException("Error parsing JSON", jsonException);
                    }
                }
            }).withOutputTags(MAIN_TAG, this.deadLetterFile() != null ? TupleTagList.of(DLF_TAG) : TupleTagList.empty()));
            if (this.deadLetterFile() != null) {
                rows.get(DLF_TAG).setCoder((Coder)StringUtf8Coder.of()).apply((PTransform)this.writeJsonToDlf());
            }
            return rows.get(MAIN_TAG).setRowSchema(this.schema());
        }

        private // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized TextIO.Write writeJsonToDlf() {
            return TextIO.write().withDelimiter(new char[0]).to(this.deadLetterFile());
        }

        private @UnknownKeyFor @NonNull @Initialized ObjectMapper getObjectMapper() {
            return RowJsonUtils.newObjectMapperWith((RowJson.RowJsonDeserializer)RowJson.RowJsonDeserializer.forSchema((Schema)this.schema()));
        }
    }

    public static class LinesReadConverter
    extends PTransform<PCollection<String>, PCollection<Row>>
    implements Serializable {
        private static final @UnknownKeyFor @NonNull @Initialized Schema SCHEMA = Schema.builder().addStringField("line").build();

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> input) {
            return ((PCollection)input.apply("linesToRows", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.rows()).via((SerializableFunction & Serializable)s -> Row.withSchema((Schema)SCHEMA).addValue(s).build()))).setRowSchema(SCHEMA);
        }
    }

    public static class LinesWriteConverter
    extends PTransform<PCollection<Row>, PCollection<String>>
    implements Serializable {
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
            return (PCollection)input.apply("rowsToLines", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)row -> row.getString(0) + "\n"));
        }
    }
}

