/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.transform;

import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableMap;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionExecutor;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;

public class BeamSqlFilterFn
extends DoFn<Row, Row> {
    private String stepName;
    private BeamSqlExpressionExecutor executor;

    public BeamSqlFilterFn(String stepName, BeamSqlExpressionExecutor executor) {
        this.stepName = stepName;
        this.executor = executor;
    }

    @DoFn.Setup
    public void setup() {
        this.executor.prepare();
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext c, BoundedWindow window) {
        Row in = (Row)c.element();
        List<Object> result = this.executor.execute(in, window, ImmutableMap.of());
        if (((Boolean)result.get(0)).booleanValue()) {
            c.output((Object)in);
        }
    }

    @DoFn.Teardown
    public void close() {
        this.executor.close();
    }
}

