/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.string;

import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableMap;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;

public class BeamSqlConcatExpression
extends BeamSqlExpression {
    protected BeamSqlConcatExpression(List<BeamSqlExpression> operands, SqlTypeName outputType) {
        super(operands, outputType);
    }

    public BeamSqlConcatExpression(List<BeamSqlExpression> operands) {
        super(operands, SqlTypeName.VARCHAR);
    }

    @Override
    public boolean accept() {
        if (this.operands.size() != 2) {
            return false;
        }
        for (BeamSqlExpression exp : this.getOperands()) {
            if (SqlTypeName.CHAR_TYPES.contains((Object)exp.getOutputType())) continue;
            return false;
        }
        return true;
    }

    @Override
    public BeamSqlPrimitive evaluate(Row inputRow, BoundedWindow window, ImmutableMap<Integer, Object> correlateEnv) {
        String left = (String)this.opValueEvaluated(0, inputRow, window, correlateEnv);
        String right = (String)this.opValueEvaluated(1, inputRow, window, correlateEnv);
        return BeamSqlPrimitive.of(SqlTypeName.VARCHAR, new StringBuilder(left.length() + right.length()).append(left).append(right).toString());
    }
}

