/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.map;

import java.util.HashMap;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableMap;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;

public class BeamSqlMapExpression
extends BeamSqlExpression {
    public BeamSqlMapExpression(List<BeamSqlExpression> operands) {
        super(operands, SqlTypeName.MAP);
    }

    @Override
    public boolean accept() {
        return this.operands.stream().map(BeamSqlExpression::getOutputType).distinct().count() == 1L;
    }

    @Override
    public BeamSqlPrimitive evaluate(Row inputRow, BoundedWindow window, ImmutableMap<Integer, Object> correlateEnv) {
        HashMap elements = new HashMap();
        for (int idx = 0; idx < this.operands.size() / 2; ++idx) {
            elements.put(((BeamSqlExpression)this.operands.get(idx * 2)).evaluate(inputRow, window, correlateEnv).getValue(), ((BeamSqlExpression)this.operands.get(idx * 2 + 1)).evaluate(inputRow, window, correlateEnv).getValue());
        }
        return BeamSqlPrimitive.of(this.outputType, elements);
    }
}

