/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date;

import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableMap;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class BeamSqlDateCeilExpression
extends BeamSqlExpression {
    public BeamSqlDateCeilExpression(List<BeamSqlExpression> operands) {
        super(operands, SqlTypeName.TIMESTAMP);
    }

    @Override
    public boolean accept() {
        return this.operands.size() == 2 && this.opType(1) == SqlTypeName.SYMBOL;
    }

    @Override
    public BeamSqlPrimitive evaluate(Row inputRow, BoundedWindow window, ImmutableMap<Integer, Object> correlateEnv) {
        ReadableInstant date = (ReadableInstant)this.opValueEvaluated(0, inputRow, window, correlateEnv);
        long time = date.getMillis();
        TimeUnitRange unit = (TimeUnitRange)((Object)((BeamSqlPrimitive)this.op(1)).getValue());
        long newTime = DateTimeUtils.unixTimestampCeil(unit, time);
        DateTime newDate = new DateTime(newTime, date.getZone());
        return BeamSqlPrimitive.of(this.outputType, newDate);
    }
}

