/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.ConnectionProperty;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.config.Lex;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.jdbc.CalciteConnection;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.jdbc.Driver;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteSchema;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteSchemaFactory;
import org.apache.beam.sdk.extensions.sql.impl.parser.impl.BeamSqlParserImpl;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelDataTypeSystem;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.commons.compiler.CompilerFactoryFactory;

public class JdbcDriver
extends Driver {
    public static final JdbcDriver INSTANCE = new JdbcDriver();
    public static final String CONNECT_STRING_PREFIX = "jdbc:beam:";
    private static final String BEAM_CALCITE_SCHEMA = "beamCalciteSchema";

    @Override
    protected String getConnectStringPrefix() {
        return CONNECT_STRING_PREFIX;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        SchemaPlus defaultSchema;
        BeamCalciteSchema beamCalciteSchema = (BeamCalciteSchema)info.get(BEAM_CALCITE_SCHEMA);
        Properties info2 = new Properties(info);
        JdbcDriver.setDefault(info2, CalciteConnectionProperty.LEX, Lex.JAVA.name());
        JdbcDriver.setDefault(info2, CalciteConnectionProperty.PARSER_FACTORY, BeamSqlParserImpl.class.getName() + "#FACTORY");
        JdbcDriver.setDefault(info2, CalciteConnectionProperty.TYPE_SYSTEM, BeamRelDataTypeSystem.class.getName());
        JdbcDriver.setDefault(info2, CalciteConnectionProperty.SCHEMA, "beam");
        JdbcDriver.setDefault(info2, CalciteConnectionProperty.SCHEMA_FACTORY, BeamCalciteSchemaFactory.class.getName());
        CalciteConnection connection = (CalciteConnection)super.connect(url, info2);
        if (beamCalciteSchema != null) {
            defaultSchema = connection.getRootSchema().add(connection.config().schema(), beamCalciteSchema);
            connection.setSchema(defaultSchema.getName());
        } else {
            defaultSchema = JdbcDriver.getDefaultSchema(connection);
        }
        defaultSchema.setCacheEnabled(false);
        return connection;
    }

    private static void setDefault(Properties info, ConnectionProperty key, String value) {
        if (info.getProperty(key.camelName()) == null) {
            info.setProperty(key.camelName(), value);
        }
    }

    static CalciteConnection connect(TableProvider tableProvider) {
        try {
            Properties info = new Properties();
            info.put(BEAM_CALCITE_SCHEMA, new BeamCalciteSchema(tableProvider));
            return (CalciteConnection)INSTANCE.connect(CONNECT_STRING_PREFIX, info);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static SchemaPlus getDefaultSchema(CalciteConnection connection) {
        try {
            String defaultSchemaName = connection.getSchema();
            return connection.getRootSchema().getSubSchema(defaultSchemaName);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(JdbcDriver.class.getClassLoader());
            CompilerFactoryFactory.getDefaultCompilerFactory();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(origLoader);
        }
        INSTANCE.register();
    }
}

