/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.base.Supplier;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelCompositeTrait;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelMultipleTrait;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelTrait;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelTraitDef;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.runtime.FlatLists;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.Pair;

public final class RelTraitSet
extends AbstractList<RelTrait> {
    private static final RelTrait[] EMPTY_TRAITS = new RelTrait[0];
    private final Cache cache;
    private final RelTrait[] traits;
    private final String string;

    private RelTraitSet(Cache cache, RelTrait[] traits) {
        this.cache = cache;
        this.traits = traits;
        this.string = this.computeString();
    }

    public static RelTraitSet createEmpty() {
        return new RelTraitSet(new Cache(), EMPTY_TRAITS);
    }

    public RelTrait getTrait(int index) {
        return this.traits[index];
    }

    public <E extends RelMultipleTrait> List<E> getTraits(int index) {
        RelTrait trait = this.traits[index];
        if (trait instanceof RelCompositeTrait) {
            return ((RelCompositeTrait)trait).traitList();
        }
        return ImmutableList.of((RelMultipleTrait)trait);
    }

    @Override
    public RelTrait get(int index) {
        return this.getTrait(index);
    }

    public <T extends RelTrait> boolean isEnabled(RelTraitDef<T> traitDef) {
        return this.getTrait(traitDef) != null;
    }

    public <T extends RelTrait> T getTrait(RelTraitDef<T> traitDef) {
        int index = this.findIndex(traitDef);
        if (index >= 0) {
            return (T)this.getTrait(index);
        }
        return null;
    }

    public <T extends RelMultipleTrait> List<T> getTraits(RelTraitDef<T> traitDef) {
        int index = this.findIndex(traitDef);
        if (index >= 0) {
            return this.getTraits(index);
        }
        return null;
    }

    public RelTraitSet replace(int index, RelTrait trait) {
        assert (this.traits[index].getTraitDef() == trait.getTraitDef()) : "RelTrait has different RelTraitDef than replacement";
        RelTrait canonizedTrait = this.canonize(trait);
        if (this.traits[index] == canonizedTrait) {
            return this;
        }
        RelTrait[] newTraits = (RelTrait[])this.traits.clone();
        newTraits[index] = canonizedTrait;
        return this.cache.getOrAdd(new RelTraitSet(this.cache, newTraits));
    }

    public RelTraitSet replace(RelTrait trait) {
        if (RelTraitSet.containsShallow(this.traits, trait)) {
            return this;
        }
        RelTraitDef traitDef = trait.getTraitDef();
        int index = this.findIndex(traitDef);
        if (index < 0) {
            return this;
        }
        return this.replace(index, trait);
    }

    private static <T> boolean containsShallow(T[] ts, RelTrait seek) {
        for (T t : ts) {
            if (t != seek) continue;
            return true;
        }
        return false;
    }

    public <T extends RelMultipleTrait> RelTraitSet replace(List<T> traits) {
        assert (!traits.isEmpty());
        RelTraitDef def = ((RelMultipleTrait)traits.get(0)).getTraitDef();
        return this.replace(RelCompositeTrait.of(def, traits));
    }

    public <T extends RelMultipleTrait> RelTraitSet replace(RelTraitDef<T> def, List<T> traits) {
        return this.replace(RelCompositeTrait.of(def, traits));
    }

    public <T extends RelMultipleTrait> RelTraitSet replaceIfs(RelTraitDef<T> def, Supplier<List<T>> traitSupplier) {
        int index = this.findIndex(def);
        if (index < 0) {
            return this;
        }
        List<T> traitList = traitSupplier.get();
        return this.replace(index, RelCompositeTrait.of(def, traitList));
    }

    public <T extends RelTrait> RelTraitSet replaceIf(RelTraitDef<T> def, Supplier<T> traitSupplier) {
        int index = this.findIndex(def);
        if (index < 0) {
            return this;
        }
        RelTrait traitList = (RelTrait)traitSupplier.get();
        return this.replace(index, traitList);
    }

    @Override
    public int size() {
        return this.traits.length;
    }

    public <T extends RelTrait> T canonize(T trait) {
        if (trait == null) {
            return null;
        }
        if (trait instanceof RelCompositeTrait) {
            return trait;
        }
        return trait.getTraitDef().canonize(trait);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof RelTraitSet && Arrays.equals(this.traits, ((RelTraitSet)obj).traits);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.traits);
    }

    public boolean satisfies(RelTraitSet that) {
        for (Pair<RelTrait, RelTrait> pair : Pair.zip(this.traits, that.traits)) {
            if (((RelTrait)pair.left).satisfies((RelTrait)pair.right)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(RelTraitSet that) {
        int n = Math.min(this.size(), that.size());
        for (int i = 0; i < n; ++i) {
            RelTrait thisTrait = this.traits[i];
            RelTrait thatTrait = that.traits[i];
            if (thisTrait == null || thatTrait == null || thisTrait == thatTrait) continue;
            return false;
        }
        return true;
    }

    public boolean contains(RelTrait trait) {
        for (RelTrait relTrait : this.traits) {
            if (trait != relTrait) continue;
            return true;
        }
        return false;
    }

    public boolean containsIfApplicable(RelTrait trait) {
        Object trait1 = this.getTrait(trait.getTraitDef());
        return trait1 == null || trait1 == trait;
    }

    public boolean comprises(RelTrait ... relTraits) {
        return Arrays.equals(this.traits, relTraits);
    }

    @Override
    public String toString() {
        return this.string;
    }

    protected String computeString() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.traits.length; ++i) {
            RelTrait trait = this.traits[i];
            if (i > 0) {
                s.append('.');
            }
            if (trait == null && this.traits.length == 1) {
                s.append("{null}");
                continue;
            }
            s.append(trait);
        }
        return s.toString();
    }

    private int findIndex(RelTraitDef traitDef) {
        for (int i = 0; i < this.traits.length; ++i) {
            RelTrait trait = this.traits[i];
            if (trait == null || trait.getTraitDef() != traitDef) continue;
            return i;
        }
        return -1;
    }

    public RelTraitSet plus(RelTrait trait) {
        Collection<RelTrait> newTraits;
        if (this.contains(trait)) {
            return this;
        }
        int i = this.findIndex(trait.getTraitDef());
        if (i >= 0) {
            return this.replace(i, trait);
        }
        RelTrait canonizedTrait = this.canonize(trait);
        assert (canonizedTrait != null);
        switch (this.traits.length) {
            case 0: {
                newTraits = ImmutableList.of(canonizedTrait);
                break;
            }
            case 1: {
                newTraits = FlatLists.of(this.traits[0], canonizedTrait);
                break;
            }
            case 2: {
                newTraits = FlatLists.of(this.traits[0], this.traits[1], canonizedTrait);
                break;
            }
            default: {
                newTraits = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(this.traits)).add(canonizedTrait)).build();
            }
        }
        return this.cache.getOrAdd((List<RelTrait>)newTraits);
    }

    public RelTraitSet plusAll(RelTrait[] traits) {
        RelTraitSet t = this;
        for (RelTrait trait : traits) {
            t = t.plus(trait);
        }
        return t;
    }

    public RelTraitSet merge(RelTraitSet additionalTraits) {
        return this.plusAll(additionalTraits.traits);
    }

    public ImmutableList<RelTrait> difference(RelTraitSet traitSet) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Pair<RelTrait, RelTrait> pair : Pair.zip(this.traits, traitSet.traits)) {
            if (pair.left == pair.right) continue;
            builder.add(pair.right);
        }
        return builder.build();
    }

    public boolean allSimple() {
        for (RelTrait trait : this.traits) {
            if (!(trait instanceof RelCompositeTrait)) continue;
            return false;
        }
        return true;
    }

    public RelTraitSet simplify() {
        RelTraitSet x = this;
        for (int i = 0; i < this.traits.length; ++i) {
            RelTrait trait = this.traits[i];
            if (!(trait instanceof RelCompositeTrait)) continue;
            x = x.replace(i, (RelTrait)(((RelCompositeTrait)trait).size() == 1 ? ((RelCompositeTrait)trait).trait(0) : trait.getTraitDef().getDefault()));
        }
        return x;
    }

    private static class Cache {
        final Map<List<RelTrait>, RelTraitSet> map = new HashMap<List<RelTrait>, RelTraitSet>();

        Cache() {
        }

        RelTraitSet getOrAdd(List<RelTrait> traits) {
            RelTraitSet traitSet1 = this.map.get(traits);
            if (traitSet1 != null) {
                return traitSet1;
            }
            RelTraitSet traitSet = new RelTraitSet(this, traits.toArray(new RelTrait[traits.size()]));
            this.map.put(traits, traitSet);
            return traitSet;
        }
    }
}

