/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.test;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.impl.BeamTableStatistics;
import org.apache.beam.sdk.extensions.sql.meta.BaseBeamTable;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTableFilter;
import org.apache.beam.sdk.extensions.sql.meta.DefaultTableFilter;
import org.apache.beam.sdk.extensions.sql.meta.ProjectSupport;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.InMemoryMetaTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestTableFilter;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.FieldTypeDescriptors;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.Filter;
import org.apache.beam.sdk.schemas.transforms.Select;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexCall;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexInputRef;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={TableProvider.class})
public class TestTableProvider
extends InMemoryMetaTableProvider {
    static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TableWithRows>> GLOBAL_TABLES = new ConcurrentHashMap<Long, Map<String, TableWithRows>>();
    public static final @UnknownKeyFor @NonNull @Initialized String PUSH_DOWN_OPTION = "push_down";
    private static final @UnknownKeyFor @NonNull @Initialized AtomicLong INSTANCES = new AtomicLong(0L);
    private final @UnknownKeyFor @NonNull @Initialized long instanceId = INSTANCES.getAndIncrement();

    public TestTableProvider() {
        GLOBAL_TABLES.put(this.instanceId, new ConcurrentHashMap());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getTableType() {
        return "test";
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TableWithRows> tables() {
        return GLOBAL_TABLES.get(this.instanceId);
    }

    @Override
    public void createTable(@UnknownKeyFor @NonNull @Initialized Table table) {
        this.tables().put(table.getName(), new TableWithRows(this.instanceId, table));
    }

    @Override
    public void dropTable(@UnknownKeyFor @NonNull @Initialized String tableName) {
        this.tables().remove(tableName);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Table> getTables() {
        return this.tables().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((TableWithRows)e.getValue()).table));
    }

    @Override
    public synchronized @UnknownKeyFor @NonNull @Initialized BeamSqlTable buildBeamSqlTable(@UnknownKeyFor @NonNull @Initialized Table table) {
        return new InMemoryTable(this.tables().get(table.getName()));
    }

    public void addRows(@UnknownKeyFor @NonNull @Initialized String tableName, Row ... rows) {
        Preconditions.checkArgument((boolean)this.tables().containsKey(tableName), (Object)("Table not found: " + tableName));
        this.tables().get(tableName).rows.addAll(Arrays.asList(rows));
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Row> tableRows(@UnknownKeyFor @NonNull @Initialized String tableName) {
        return this.tables().get(tableName).rows;
    }

    public static enum PushDownOptions {
        NONE,
        PROJECT,
        FILTER,
        BOTH;

    }

    private static final class CollectorFn
    extends DoFn<Row, Row> {
        private @UnknownKeyFor @NonNull @Initialized TableWithRows tableWithRows;

        CollectorFn(@UnknownKeyFor @NonNull @Initialized TableWithRows tableWithRows) {
            this.tableWithRows = tableWithRows;
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Row element, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> o) {
            long instanceId = this.tableWithRows.tableProviderInstanceId;
            String tableName = this.tableWithRows.table.getName();
            GLOBAL_TABLES.get(instanceId).get(tableName).rows.add(element);
            o.output((Object)element);
        }
    }

    private static class InMemoryTable
    extends BaseBeamTable {
        private @UnknownKeyFor @NonNull @Initialized TableWithRows tableWithRows;
        private @UnknownKeyFor @NonNull @Initialized PushDownOptions options;

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PCollection.IsBounded isBounded() {
            return PCollection.IsBounded.BOUNDED;
        }

        public InMemoryTable(@UnknownKeyFor @NonNull @Initialized TableWithRows tableWithRows) {
            this.tableWithRows = tableWithRows;
            this.options = tableWithRows.table.getProperties().containsKey((Object)TestTableProvider.PUSH_DOWN_OPTION) ? PushDownOptions.valueOf(tableWithRows.table.getProperties().getString(TestTableProvider.PUSH_DOWN_OPTION).toUpperCase()) : PushDownOptions.NONE;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BeamTableStatistics getTableStatistics(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            return BeamTableStatistics.createBoundedTableStatistics(Double.valueOf(this.tableWithRows.getRows().size()));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> buildIOReader(@UnknownKeyFor @NonNull @Initialized PBegin begin) {
            TableWithRows tableWithRows = GLOBAL_TABLES.get(this.tableWithRows.tableProviderInstanceId).get(this.tableWithRows.table.getName());
            return (PCollection)begin.apply((PTransform)Create.of((Iterable)tableWithRows.rows).withRowSchema(this.getSchema()));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> buildIOReader(@UnknownKeyFor @NonNull @Initialized PBegin begin, @UnknownKeyFor @NonNull @Initialized BeamSqlTableFilter filters, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> fieldNames) {
            if (!(filters instanceof DefaultTableFilter || this.options != PushDownOptions.NONE && this.options != PushDownOptions.PROJECT)) {
                throw new UnsupportedOperationException("Filter push-down is not supported, yet non-default filter was passed.");
            }
            if (!(fieldNames.isEmpty() || fieldNames.size() >= this.getSchema().getFieldCount() || this.options != PushDownOptions.NONE && this.options != PushDownOptions.FILTER)) {
                throw new UnsupportedOperationException("Project push-down is not supported, yet a list of fieldNames was passed.");
            }
            PCollection withAllFields = this.buildIOReader(begin);
            if (this.options == PushDownOptions.NONE) {
                return withAllFields;
            }
            PCollection result = withAllFields;
            if (this.options == PushDownOptions.FILTER || this.options == PushDownOptions.BOTH) {
                if (filters instanceof TestTableFilter) {
                    for (RexNode node : ((TestTableFilter)filters).getSupported()) {
                        result = (PCollection)result.apply("IOPushDownFilter_" + node.toString(), this.filterFromNode(node));
                    }
                } else {
                    throw new UnsupportedOperationException("Was expecting a filter of type TestTableFilter, but received: " + filters.getClass().getSimpleName());
                }
            }
            if (!(this.options != PushDownOptions.PROJECT && this.options != PushDownOptions.BOTH || fieldNames.isEmpty())) {
                result = (PCollection)result.apply("IOPushDownProject", (PTransform)Select.fieldAccess((FieldAccessDescriptor)FieldAccessDescriptor.withFieldNames(fieldNames)));
            }
            return result;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized POutput buildIOWriter(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
            ((PCollection)input.apply((PTransform)ParDo.of((DoFn)new CollectorFn(this.tableWithRows)))).setRowSchema(input.getSchema());
            return PDone.in((Pipeline)input.getPipeline());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BeamSqlTableFilter constructFilter(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RexNode> filter) {
            if (this.options == PushDownOptions.FILTER || this.options == PushDownOptions.BOTH) {
                return new TestTableFilter(filter);
            }
            return super.constructFilter(filter);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized ProjectSupport supportsProjects() {
            return this.options == PushDownOptions.BOTH || this.options == PushDownOptions.PROJECT ? ProjectSupport.WITH_FIELD_REORDERING : ProjectSupport.NONE;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Schema getSchema() {
            return this.tableWithRows.table.getSchema();
        }

        private @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> filterFromNode(@UnknownKeyFor @NonNull @Initialized RexNode node) {
            SerializableFunction & Serializable comparison;
            ArrayList<RexNode> operands = new ArrayList<RexNode>();
            ArrayList<Integer> fieldIds = new ArrayList<Integer>();
            ArrayList<RexLiteral> literals = new ArrayList<RexLiteral>();
            ArrayList<RexInputRef> inputRefs = new ArrayList<RexInputRef>();
            if (node instanceof RexCall) {
                operands.addAll(((RexCall)node).getOperands());
            } else if (node instanceof RexInputRef) {
                operands.add(node);
                operands.add((RexNode)RexLiteral.fromJdbcString((RelDataType)node.getType(), (SqlTypeName)SqlTypeName.BOOLEAN, (String)"true"));
            } else {
                throw new UnsupportedOperationException("Was expecting a RexCall or a boolean RexInputRef, but received: " + node.getClass().getSimpleName());
            }
            for (RexNode operand : operands) {
                if (operand instanceof RexInputRef) {
                    RexInputRef inputRef = (RexInputRef)operand;
                    fieldIds.add(inputRef.getIndex());
                    inputRefs.add(inputRef);
                    continue;
                }
                if (operand instanceof RexLiteral) {
                    RexLiteral literal = (RexLiteral)operand;
                    literals.add(literal);
                    continue;
                }
                throw new UnsupportedOperationException("Encountered an unexpected operand: " + operand.getClass().getSimpleName());
            }
            switch (node.getKind()) {
                case LESS_THAN: {
                    comparison = (SerializableFunction & Serializable)i -> i < 0;
                    break;
                }
                case GREATER_THAN: {
                    comparison = (SerializableFunction & Serializable)i -> i > 0;
                    break;
                }
                case LESS_THAN_OR_EQUAL: {
                    comparison = (SerializableFunction & Serializable)i -> i <= 0;
                    break;
                }
                case GREATER_THAN_OR_EQUAL: {
                    comparison = (SerializableFunction & Serializable)i -> i >= 0;
                    break;
                }
                case EQUALS: 
                case INPUT_REF: {
                    comparison = (SerializableFunction & Serializable)i -> i == 0;
                    break;
                }
                case NOT_EQUALS: {
                    comparison = (SerializableFunction & Serializable)i -> i != 0;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported node kind: " + node.getKind().toString());
                }
            }
            return Filter.create().whereFieldIds(fieldIds, this.createFilter(operands, fieldIds, inputRefs, literals, (SerializableFunction<Integer, Boolean>)comparison));
        }

        private @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Boolean> createFilter(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RexNode> operands, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> fieldIds, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RexInputRef> inputRefs, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RexLiteral> literals, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized Boolean> comparison) {
            assert (operands.size() == 2);
            assert (inputRefs.size() <= 2);
            assert (literals.size() < 2);
            if (inputRefs.size() == 2) {
                int op0 = fieldIds.indexOf(inputRefs.get(0).getIndex());
                int op1 = fieldIds.indexOf(inputRefs.get(1).getIndex());
                return (SerializableFunction & Serializable)row -> (Boolean)comparison.apply((Object)((Comparable)row.getValue(op0)).compareTo(op1));
            }
            int fieldSchemaIndex = inputRefs.get(0).getIndex();
            Schema.FieldType beamFieldType = this.getSchema().getField(fieldSchemaIndex).getType();
            int op0 = fieldIds.indexOf(fieldSchemaIndex);
            Comparable op1 = (Comparable)literals.get(0).getValueAs(FieldTypeDescriptors.javaTypeForFieldType((Schema.FieldType)beamFieldType).getRawType());
            if (operands.get(0) instanceof RexLiteral) {
                return (SerializableFunction & Serializable)row -> (Boolean)comparison.apply((Object)op1.compareTo(row.getValue(op0)));
            }
            if (operands.get(0) instanceof RexInputRef) {
                return (SerializableFunction & Serializable)row -> (Boolean)comparison.apply((Object)((Comparable)row.getValue(op0)).compareTo(op1));
            }
            throw new UnsupportedOperationException("Was expecting a RexLiteral and a RexInputRef, but received: " + operands.stream().map(o -> o.getClass().getSimpleName()).collect(Collectors.joining(", ")));
        }
    }

    public static class TableWithRows
    implements Serializable {
        private @UnknownKeyFor @NonNull @Initialized Table table;
        private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Row> rows;
        private @UnknownKeyFor @NonNull @Initialized long tableProviderInstanceId;

        public TableWithRows(@UnknownKeyFor @NonNull @Initialized long tableProviderInstanceId, @UnknownKeyFor @NonNull @Initialized Table table) {
            this.tableProviderInstanceId = tableProviderInstanceId;
            this.table = table;
            this.rows = new CopyOnWriteArrayList<Row>();
        }

        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Row> getRows() {
            return this.rows;
        }
    }
}

