/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.transform;

import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSetOperatorRelBase;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public abstract class BeamSetOperatorsTransforms {

    public static class SetOperatorFilteringDoFn
    extends DoFn<Row, Row> {
        private final @UnknownKeyFor @NonNull @Initialized String leftTag;
        private final @UnknownKeyFor @NonNull @Initialized String rightTag;
        private final @UnknownKeyFor @NonNull @Initialized BeamSetOperatorRelBase.OpType opType;
        private final @UnknownKeyFor @NonNull @Initialized boolean all;

        public SetOperatorFilteringDoFn(@UnknownKeyFor @NonNull @Initialized String leftTag, @UnknownKeyFor @NonNull @Initialized String rightTag, @UnknownKeyFor @NonNull @Initialized BeamSetOperatorRelBase.OpType opType, @UnknownKeyFor @NonNull @Initialized boolean all) {
            this.leftTag = leftTag;
            this.rightTag = rightTag;
            this.opType = opType;
            this.all = all;
        }

        /*
         * Enabled aggressive block sorting
         */
        @DoFn.ProcessElement
        public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Row element, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> o) {
            Row key = element.getRow("key");
            long numLeftRows = 0L;
            long numRightRows = 0L;
            if (!Iterables.isEmpty((Iterable)element.getIterable(this.leftTag))) {
                numLeftRows = Iterables.size((Iterable)element.getIterable(this.leftTag));
            }
            if (!Iterables.isEmpty((Iterable)element.getIterable(this.rightTag))) {
                numRightRows = Iterables.size((Iterable)element.getIterable(this.rightTag));
            }
            switch (this.opType) {
                case UNION: {
                    if (!this.all) {
                        o.output((Object)key);
                        return;
                    }
                    int i = 0;
                    while ((long)i < numLeftRows + numRightRows) {
                        o.output((Object)key);
                        ++i;
                    }
                    return;
                }
                case INTERSECT: {
                    if (numLeftRows <= 0L) return;
                    if (numRightRows <= 0L) return;
                    if (!this.all) {
                        o.output((Object)key);
                        return;
                    }
                    int i = 0;
                    while ((long)i < Math.min(numLeftRows, numRightRows)) {
                        o.output((Object)key);
                        ++i;
                    }
                    return;
                }
                case MINUS: {
                    if (numLeftRows > 0L && numRightRows == 0L) {
                        if (!this.all) {
                            o.output((Object)key);
                            return;
                        }
                        int i = 0;
                        while ((long)i < numLeftRows) {
                            o.output((Object)key);
                            ++i;
                        }
                        return;
                    }
                    if (numLeftRows <= 0L) return;
                    if (numRightRows <= 0L) return;
                    long outputCount = numLeftRows - numRightRows;
                    if (outputCount <= 0L) return;
                    if (!this.all) return;
                    while (outputCount > 0L) {
                        --outputCount;
                        o.output((Object)key);
                    }
                    return;
                }
            }
        }
    }

    public static class BeamSqlRow2KvFn
    extends SimpleFunction<Row, KV<Row, Row>> {
        public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Row> apply(@UnknownKeyFor @NonNull @Initialized Row input) {
            return KV.of((Object)input, (Object)input);
        }
    }
}

