/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelMetadataQuery;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.volcano.RelSubset;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BeamSqlRelUtils {
    public static final @UnknownKeyFor @NonNull @Initialized String ROW = "row";
    public static final @UnknownKeyFor @NonNull @Initialized String ERROR = "error";

    public static @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> toPCollection(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized BeamRelNode node) {
        return BeamSqlRelUtils.toPCollection(pipeline, node, null, new HashMap<Integer, PCollection<Row>>());
    }

    public static @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> toPCollection(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized BeamRelNode node, @Nullable @UnknownKeyFor @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized POutput> errorTransformer) {
        return BeamSqlRelUtils.toPCollection(pipeline, node, errorTransformer, new HashMap<Integer, PCollection<Row>>());
    }

    private static @UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row> buildPCollectionList(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RelNode> inputRels, @UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @Nullable @UnknownKeyFor @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized POutput> errorTransformer, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> cache) {
        if (inputRels.isEmpty()) {
            return PCollectionList.empty((Pipeline)pipeline);
        }
        return PCollectionList.of((Iterable)inputRels.stream().map(input -> {
            BeamRelNode beamRel = input instanceof RelSubset ? (BeamRelNode)Preconditions.checkArgumentNotNull((Object)((BeamRelNode)((RelSubset)input).getBest()), (Object)"Attempted to build PCollection from unoptimized RelSubset (best is null).") : (BeamRelNode)input;
            return BeamSqlRelUtils.toPCollection(pipeline, beamRel, errorTransformer, cache);
        }).collect(Collectors.toList()));
    }

    static @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> toPCollection(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized BeamRelNode node, @Nullable @UnknownKeyFor @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized POutput> errorTransformer, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> cache) {
        PCollection output = cache.get(node.getId());
        if (output != null) {
            return output;
        }
        String name = node.getClass().getSimpleName() + "_" + node.getId();
        PCollectionList<Row> input = BeamSqlRelUtils.buildPCollectionList(node.getPCollectionInputs(), pipeline, errorTransformer, cache);
        PTransform<PCollectionList<Row>, PCollection<Row>> transform = node.buildPTransform(errorTransformer);
        output = (PCollection)Pipeline.applyTransform((String)name, input, transform);
        cache.put(node.getId(), (PCollection<Row>)output);
        return output;
    }

    public static @UnknownKeyFor @NonNull @Initialized BeamRelNode getBeamRelInput(@UnknownKeyFor @NonNull @Initialized RelNode input) {
        if (input instanceof RelSubset) {
            input = (RelNode)Preconditions.checkArgumentNotNull((Object)((RelSubset)input).getBest(), (Object)"input RelSubset has no best.");
        }
        return (BeamRelNode)input;
    }

    public static @UnknownKeyFor @NonNull @Initialized RelNode getInput(@UnknownKeyFor @NonNull @Initialized RelNode input) {
        RelNode result = input;
        if (input instanceof RelSubset && (result = ((RelSubset)input).getBest()) == null) {
            result = (RelNode)Preconditions.checkArgumentNotNull((Object)((RelSubset)input).getOriginal(), (Object)"best and original nodes are both null for input RelSubset.");
        }
        return result;
    }

    public static @UnknownKeyFor @NonNull @Initialized NodeStats getNodeStats(@UnknownKeyFor @NonNull @Initialized RelNode input, @UnknownKeyFor @NonNull @Initialized BeamRelMetadataQuery mq) {
        input = BeamSqlRelUtils.getInput(input);
        return mq.getNodeStats(input);
    }

    public static @UnknownKeyFor @NonNull @Initialized Schema getErrorRowSchema(@UnknownKeyFor @NonNull @Initialized Schema upstreamSchema) {
        return Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)ROW, (Schema.FieldType)Schema.FieldType.row((Schema)upstreamSchema)), Schema.Field.of((String)ERROR, (Schema.FieldType)Schema.FieldType.STRING)});
    }
}

