/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.ParseException;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamEnumerableConverter;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.meta.store.MetaStore;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Experimental
public class BeamSqlCli {
    private @UnknownKeyFor @NonNull @Initialized BeamSqlEnv env;
    private @UnknownKeyFor @NonNull @Initialized MetaStore metaStore;

    public @UnknownKeyFor @NonNull @Initialized BeamSqlCli metaStore(@UnknownKeyFor @NonNull @Initialized MetaStore metaStore) {
        return this.metaStore(metaStore, false, PipelineOptionsFactory.create());
    }

    public @UnknownKeyFor @NonNull @Initialized BeamSqlCli metaStore(@UnknownKeyFor @NonNull @Initialized MetaStore metaStore, @UnknownKeyFor @NonNull @Initialized boolean autoLoadUdfUdaf, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
        this.metaStore = metaStore;
        BeamSqlEnv.BeamSqlEnvBuilder builder = BeamSqlEnv.builder(metaStore);
        if (autoLoadUdfUdaf) {
            builder.autoLoadUserDefinedFunctions();
        }
        builder.setPipelineOptions(pipelineOptions);
        this.env = builder.build();
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized MetaStore getMetaStore() {
        return this.metaStore;
    }

    public @UnknownKeyFor @NonNull @Initialized String explainQuery(@UnknownKeyFor @NonNull @Initialized String sqlString) throws @UnknownKeyFor @NonNull @Initialized ParseException {
        return this.env.explain(sqlString);
    }

    public void execute(@UnknownKeyFor @NonNull @Initialized String sqlString) throws @UnknownKeyFor @NonNull @Initialized ParseException {
        if (this.env.isDdl(sqlString)) {
            this.env.executeDdl(sqlString);
        } else {
            PipelineOptions options = BeamEnumerableConverter.createPipelineOptions(this.env.getPipelineOptions());
            options.setJobName("BeamPlanCreator");
            Pipeline pipeline = Pipeline.create((PipelineOptions)options);
            BeamSqlRelUtils.toPCollection(pipeline, this.env.parseQuery(sqlString));
            pipeline.run();
        }
    }
}

