/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.parser;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.beam.sdk.extensions.sql.impl.JavaUdfLoader;
import org.apache.beam.sdk.extensions.sql.impl.LazyAggregateCombineFn;
import org.apache.beam.sdk.extensions.sql.impl.ScalarFnReflector;
import org.apache.beam.sdk.extensions.sql.impl.ScalarFunctionImpl;
import org.apache.beam.sdk.extensions.sql.impl.parser.BeamSqlParser;
import org.apache.beam.sdk.extensions.sql.impl.parser.SqlDdlNodes;
import org.apache.beam.sdk.extensions.sql.udf.ScalarFn;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.runtime.Resources;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.Function;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlCreate;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlUtil;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.util.Pair;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.util.Static;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;

public class SqlCreateFunction
extends SqlCreate
implements BeamSqlParser.ExecutableStatement {
    private final boolean isAggregate;
    private final SqlIdentifier functionName;
    private final SqlNode jarPath;
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE FUNCTION", SqlKind.CREATE_FUNCTION);

    public SqlCreateFunction(SqlParserPos pos, boolean replace, SqlIdentifier functionName, SqlNode jarPath, boolean isAggregate) {
        super((SqlOperator)OPERATOR, pos, replace, false);
        this.functionName = Objects.requireNonNull(functionName, "functionName");
        this.jarPath = Objects.requireNonNull(jarPath, "jarPath");
        this.isAggregate = isAggregate;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        if (this.isAggregate) {
            writer.keyword("AGGREGATE");
        }
        writer.keyword("FUNCTION");
        this.functionName.unparse(writer, 0, 0);
        writer.keyword("USING JAR");
        this.jarPath.unparse(writer, 0, 0);
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public List<SqlNode> getOperandList() {
        return Arrays.asList(this.functionName, this.jarPath);
    }

    @Override
    public void execute(CalcitePrepare.Context context) {
        String lastName;
        Pair<CalciteSchema, String> pair = SqlDdlNodes.schema(context, true, this.functionName);
        SchemaPlus schema = ((CalciteSchema)pair.left).plus();
        if (!schema.getFunctions(lastName = (String)pair.right).isEmpty()) {
            throw SqlUtil.newContextException((SqlParserPos)this.functionName.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal(String.format("Function %s is already defined.", lastName)));
        }
        JavaUdfLoader udfLoader = new JavaUdfLoader();
        ImmutableList functionPath = ImmutableList.of((Object)lastName);
        if (!(this.jarPath instanceof SqlCharStringLiteral)) {
            throw SqlUtil.newContextException((SqlParserPos)this.jarPath.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal("Jar path is not instanceof SqlCharStringLiteral."));
        }
        String unquotedJarPath = ((SqlCharStringLiteral)this.jarPath).getNlsString().getValue();
        if (this.isAggregate) {
            udfLoader.loadAggregateFunction((List<String>)functionPath, unquotedJarPath);
            LazyAggregateCombineFn combineFn = new LazyAggregateCombineFn((List<String>)functionPath, unquotedJarPath);
            schema.add(lastName, (Function)combineFn.getUdafImpl());
        } else {
            ScalarFn scalarFn = udfLoader.loadScalarFunction((List<String>)functionPath, unquotedJarPath);
            Method method = ScalarFnReflector.getApplyMethod(scalarFn);
            Function function = ScalarFunctionImpl.create(method, unquotedJarPath);
            schema.add(lastName, function);
        }
    }
}

