/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import org.apache.beam.sdk.extensions.sql.udf.ScalarFn;
import org.apache.beam.sdk.util.common.ReflectHelpers;

public class ScalarFnReflector {
    public static Method getApplyMethod(ScalarFn scalarFn) {
        Class<?> clazz = scalarFn.getClass();
        Collection matches = ReflectHelpers.declaredMethodsWithAnnotation(ScalarFn.ApplyMethod.class, clazz, ScalarFn.class);
        if (matches.isEmpty()) {
            throw new IllegalArgumentException(String.format("No method annotated with @%s found in class %s.", ScalarFn.ApplyMethod.class.getSimpleName(), clazz.getName()));
        }
        Method first = (Method)matches.iterator().next();
        for (Method other : matches) {
            if (first.getName().equals(other.getName()) && Arrays.equals(first.getParameterTypes(), other.getParameterTypes())) continue;
            throw new IllegalArgumentException(String.format("Found multiple methods annotated with @%s. [%s] and [%s]", ScalarFn.ApplyMethod.class.getSimpleName(), ReflectHelpers.formatMethod((Method)first), ReflectHelpers.formatMethod((Method)other)));
        }
        if ((first.getModifiers() & 1) == 0) {
            throw new IllegalArgumentException(String.format("Method %s is not public.", ReflectHelpers.formatMethod((Method)first)));
        }
        return first;
    }
}

