/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.validate;

import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlJoin;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.validate.AbstractNamespace;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.validate.SqlValidatorImpl;

class JoinNamespace
extends AbstractNamespace {
    private final SqlJoin join;

    JoinNamespace(SqlValidatorImpl validator, SqlJoin join) {
        super(validator, null);
        this.join = join;
    }

    @Override
    protected RelDataType validateImpl(RelDataType targetRowType) {
        RelDataType leftType = this.validator.getNamespace(this.join.getLeft()).getRowType();
        RelDataType rightType = this.validator.getNamespace(this.join.getRight()).getRowType();
        RelDataTypeFactory typeFactory = this.validator.getTypeFactory();
        switch (this.join.getJoinType()) {
            case LEFT: {
                rightType = typeFactory.createTypeWithNullability(rightType, true);
                break;
            }
            case RIGHT: {
                leftType = typeFactory.createTypeWithNullability(leftType, true);
                break;
            }
            case FULL: {
                leftType = typeFactory.createTypeWithNullability(leftType, true);
                rightType = typeFactory.createTypeWithNullability(rightType, true);
            }
        }
        return typeFactory.createJoinType(leftType, rightType);
    }

    @Override
    public SqlNode getNode() {
        return this.join;
    }
}

