/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql;

import java.util.List;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.base.Function;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.Lists;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlAbstractStringLiteral;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlLiteral;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.BitString;

public class SqlBinaryStringLiteral
extends SqlAbstractStringLiteral {
    private static final Function<SqlLiteral, BitString> F = new Function<SqlLiteral, BitString>(){

        @Override
        public BitString apply(SqlLiteral literal) {
            return ((SqlBinaryStringLiteral)literal).getBitString();
        }
    };

    protected SqlBinaryStringLiteral(BitString val, SqlParserPos pos) {
        super(val, SqlTypeName.BINARY, pos);
    }

    public BitString getBitString() {
        return (BitString)this.value;
    }

    @Override
    public SqlBinaryStringLiteral clone(SqlParserPos pos) {
        return new SqlBinaryStringLiteral((BitString)this.value, pos);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        assert (this.value instanceof BitString);
        writer.literal("X'" + ((BitString)this.value).toHexString() + "'");
    }

    @Override
    protected SqlAbstractStringLiteral concat1(List<SqlLiteral> literals) {
        return new SqlBinaryStringLiteral(BitString.concat(Lists.transform(literals, F)), literals.get(0).getParserPosition());
    }
}

