/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.AvaticaConnection;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.AvaticaStatement;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.AvaticaUtils;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.ColumnMetaData;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.ConnectionPropertiesImpl;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.Meta;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.MissingResultsException;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.NoSuchStatementException;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.QueryState;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.remote.TypedValue;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.util.AbstractCursor;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.util.ArrayIteratorCursor;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.util.Cursor;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.util.IteratorCursor;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.util.ListIteratorCursor;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.util.MapIteratorCursor;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.util.PositionedCursor;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.util.RecordIteratorCursor;

public abstract class MetaImpl
implements Meta {
    protected final AvaticaConnection connection;
    protected final ConnectionPropertiesImpl connProps;

    public MetaImpl(AvaticaConnection connection) {
        this.connection = connection;
        this.connProps = new ConnectionPropertiesImpl();
    }

    public static Cursor createCursor(Meta.CursorFactory cursorFactory, Iterable<Object> iterable) {
        switch (cursorFactory.style) {
            case OBJECT: {
                return new IteratorCursor<Object>(iterable.iterator()){

                    @Override
                    protected AbstractCursor.Getter createGetter(int ordinal) {
                        return new PositionedCursor.ObjectGetter(this, ordinal);
                    }
                };
            }
            case ARRAY: {
                Iterable<Object> iterable1 = iterable;
                return new ArrayIteratorCursor((Iterator<Object[]>)iterable1.iterator());
            }
            case RECORD: {
                Class clazz = cursorFactory.clazz;
                return new RecordIteratorCursor<Object>(iterable.iterator(), clazz);
            }
            case RECORD_PROJECTION: {
                Class clazz2 = cursorFactory.clazz;
                return new RecordIteratorCursor<Object>(iterable.iterator(), clazz2, cursorFactory.fields);
            }
            case LIST: {
                Iterable<Object> iterable2 = iterable;
                return new ListIteratorCursor((Iterator<List<Object>>)iterable2.iterator());
            }
            case MAP: {
                Iterable<Object> iterable3 = iterable;
                return new MapIteratorCursor(iterable3.iterator(), cursorFactory.fieldNames);
            }
        }
        throw new AssertionError((Object)("unknown style: " + (Object)((Object)cursorFactory.style)));
    }

    public static List<List<Object>> collect(Meta.CursorFactory cursorFactory, final Iterator<Object> iterator, List<List<Object>> list) {
        Iterable<Object> iterable = new Iterable<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return iterator;
            }
        };
        return MetaImpl.collect(cursorFactory, iterable, list);
    }

    public static List<List<Object>> collect(Meta.CursorFactory cursorFactory, Iterable<Object> iterable, List<List<Object>> list) {
        switch (cursorFactory.style) {
            case OBJECT: {
                for (Object o : iterable) {
                    list.add(Collections.singletonList(o));
                }
                return list;
            }
            case ARRAY: {
                Iterable<Object> iterable1 = iterable;
                for (Object[] objectArray : iterable1) {
                    list.add(Arrays.asList(objectArray));
                }
                return list;
            }
            case RECORD: 
            case RECORD_PROJECTION: {
                Field[] fields;
                switch (cursorFactory.style) {
                    case RECORD: {
                        fields = cursorFactory.clazz.getFields();
                        break;
                    }
                    default: {
                        fields = cursorFactory.fields.toArray(new Field[cursorFactory.fields.size()]);
                    }
                }
                for (Object o : iterable) {
                    Object[] objectArray = new Object[fields.length];
                    for (int i = 0; i < fields.length; ++i) {
                        Field field = fields[i];
                        try {
                            objectArray[i] = field.get(o);
                            continue;
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    list.add(Arrays.asList(objectArray));
                }
                return list;
            }
            case LIST: {
                Iterable<Object> iterable2 = iterable;
                for (List list2 : iterable2) {
                    list.add(list2);
                }
                return list;
            }
            case MAP: {
                Iterable<Object> iterable3 = iterable;
                for (Map map : iterable3) {
                    ArrayList objects = new ArrayList();
                    for (String fieldName : cursorFactory.fieldNames) {
                        objects.add(map.get(fieldName));
                    }
                    list.add(objects);
                }
                return list;
            }
        }
        throw new AssertionError((Object)("unknown style: " + (Object)((Object)cursorFactory.style)));
    }

    @Override
    public void openConnection(Meta.ConnectionHandle ch, Map<String, String> info) {
    }

    @Override
    public void closeConnection(Meta.ConnectionHandle ch) {
    }

    @Override
    public Meta.ConnectionProperties connectionSync(Meta.ConnectionHandle ch, Meta.ConnectionProperties connProps) {
        this.connProps.merge(connProps);
        this.connProps.setDirty(false);
        return this.connProps;
    }

    @Override
    public Meta.StatementHandle createStatement(Meta.ConnectionHandle ch) {
        return new Meta.StatementHandle(ch.id, this.connection.statementCount++, null);
    }

    protected <E> Meta.MetaResultSet createEmptyResultSet(Class<E> clazz) {
        return this.createResultSet(Collections.emptyMap(), MetaImpl.fieldMetaData(clazz).columns, Meta.CursorFactory.deduce(MetaImpl.fieldMetaData(clazz).columns, null), Meta.Frame.EMPTY);
    }

    private static int intForColumnNullable(boolean nullable) {
        return nullable ? 1 : 0;
    }

    public static ColumnMetaData columnMetaData(String name, int index, Class<?> type, boolean columnNullable) {
        return MetaImpl.columnMetaData(name, index, type, MetaImpl.intForColumnNullable(columnNullable));
    }

    public static ColumnMetaData columnMetaData(String name, int index, ColumnMetaData.AvaticaType type, boolean columnNullable) {
        return MetaImpl.columnMetaData(name, index, type, MetaImpl.intForColumnNullable(columnNullable));
    }

    public static ColumnMetaData columnMetaData(String name, int index, Class<?> type, int columnNullable) {
        TypeInfo pair = (TypeInfo)TypeInfo.m.get(type);
        ColumnMetaData.Rep rep = ColumnMetaData.Rep.VALUE_MAP.get(type);
        ColumnMetaData.ScalarType scalarType = ColumnMetaData.scalar(pair.sqlType, pair.sqlTypeName, rep);
        return MetaImpl.columnMetaData(name, index, (ColumnMetaData.AvaticaType)scalarType, columnNullable);
    }

    public static ColumnMetaData columnMetaData(String name, int index, ColumnMetaData.AvaticaType type, int columnNullable) {
        return new ColumnMetaData(index, false, true, false, false, columnNullable, true, -1, name, name, null, 0, 0, null, null, type, true, false, false, type.columnClassName());
    }

    protected static ColumnMetaData.StructType fieldMetaData(Class<?> clazz) {
        ArrayList<ColumnMetaData> list = new ArrayList<ColumnMetaData>();
        for (Field field : clazz.getFields()) {
            if (!Modifier.isPublic(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
            int columnNullable = MetaImpl.getColumnNullability(field);
            list.add(MetaImpl.columnMetaData(AvaticaUtils.camelToUpper(field.getName()), list.size(), field.getType(), columnNullable));
        }
        return ColumnMetaData.struct(list);
    }

    protected static int getColumnNullability(Field field) {
        if (field.isAnnotationPresent(ColumnNoNulls.class)) {
            return 0;
        }
        if (field.isAnnotationPresent(ColumnNullable.class)) {
            return 1;
        }
        if (field.isAnnotationPresent(ColumnNullableUnknown.class)) {
            return 2;
        }
        if (field.getType().isPrimitive()) {
            return 0;
        }
        return 1;
    }

    protected Meta.MetaResultSet createResultSet(Map<String, Object> internalParameters, List<ColumnMetaData> columns, Meta.CursorFactory cursorFactory, Meta.Frame firstFrame) {
        try {
            AvaticaStatement statement = this.connection.createStatement();
            Meta.Signature signature = new Meta.Signature(columns, "", Collections.emptyList(), internalParameters, cursorFactory, Meta.StatementType.SELECT);
            return Meta.MetaResultSet.create(this.connection.id, statement.getId(), true, signature, firstFrame);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<Meta.DatabaseProperty, Object> getDatabaseProperties(Meta.ConnectionHandle ch) {
        return Collections.emptyMap();
    }

    @Override
    public Meta.MetaResultSet getTables(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, List<String> typeList) {
        return this.createEmptyResultSet(MetaTable.class);
    }

    @Override
    public Meta.MetaResultSet getColumns(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, Meta.Pat columnNamePattern) {
        return this.createEmptyResultSet(MetaColumn.class);
    }

    @Override
    public Meta.MetaResultSet getSchemas(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern) {
        return this.createEmptyResultSet(MetaSchema.class);
    }

    @Override
    public Meta.MetaResultSet getCatalogs(Meta.ConnectionHandle ch) {
        return this.createEmptyResultSet(MetaCatalog.class);
    }

    @Override
    public Meta.MetaResultSet getTableTypes(Meta.ConnectionHandle ch) {
        return this.createEmptyResultSet(MetaTableType.class);
    }

    @Override
    public Meta.MetaResultSet getProcedures(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat procedureNamePattern) {
        return this.createEmptyResultSet(MetaProcedure.class);
    }

    @Override
    public Meta.MetaResultSet getProcedureColumns(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat procedureNamePattern, Meta.Pat columnNamePattern) {
        return this.createEmptyResultSet(MetaProcedureColumn.class);
    }

    @Override
    public Meta.MetaResultSet getColumnPrivileges(Meta.ConnectionHandle ch, String catalog, String schema, String table, Meta.Pat columnNamePattern) {
        return this.createEmptyResultSet(MetaColumnPrivilege.class);
    }

    @Override
    public Meta.MetaResultSet getTablePrivileges(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern) {
        return this.createEmptyResultSet(MetaTablePrivilege.class);
    }

    @Override
    public Meta.MetaResultSet getBestRowIdentifier(Meta.ConnectionHandle ch, String catalog, String schema, String table, int scope, boolean nullable) {
        return this.createEmptyResultSet(MetaBestRowIdentifier.class);
    }

    @Override
    public Meta.MetaResultSet getVersionColumns(Meta.ConnectionHandle ch, String catalog, String schema, String table) {
        return this.createEmptyResultSet(MetaVersionColumn.class);
    }

    @Override
    public Meta.MetaResultSet getPrimaryKeys(Meta.ConnectionHandle ch, String catalog, String schema, String table) {
        return this.createEmptyResultSet(MetaPrimaryKey.class);
    }

    @Override
    public Meta.MetaResultSet getImportedKeys(Meta.ConnectionHandle ch, String catalog, String schema, String table) {
        return this.createEmptyResultSet(MetaImportedKey.class);
    }

    @Override
    public Meta.MetaResultSet getExportedKeys(Meta.ConnectionHandle ch, String catalog, String schema, String table) {
        return this.createEmptyResultSet(MetaExportedKey.class);
    }

    @Override
    public Meta.MetaResultSet getCrossReference(Meta.ConnectionHandle ch, String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) {
        return this.createEmptyResultSet(MetaCrossReference.class);
    }

    @Override
    public Meta.MetaResultSet getTypeInfo(Meta.ConnectionHandle ch) {
        return this.createEmptyResultSet(MetaTypeInfo.class);
    }

    @Override
    public Meta.MetaResultSet getIndexInfo(Meta.ConnectionHandle ch, String catalog, String schema, String table, boolean unique, boolean approximate) {
        return this.createEmptyResultSet(MetaIndexInfo.class);
    }

    @Override
    public Meta.MetaResultSet getUDTs(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat typeNamePattern, int[] types) {
        return this.createEmptyResultSet(MetaUdt.class);
    }

    @Override
    public Meta.MetaResultSet getSuperTypes(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat typeNamePattern) {
        return this.createEmptyResultSet(MetaSuperType.class);
    }

    @Override
    public Meta.MetaResultSet getSuperTables(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern) {
        return this.createEmptyResultSet(MetaSuperTable.class);
    }

    @Override
    public Meta.MetaResultSet getAttributes(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat typeNamePattern, Meta.Pat attributeNamePattern) {
        return this.createEmptyResultSet(MetaAttribute.class);
    }

    @Override
    public Meta.MetaResultSet getClientInfoProperties(Meta.ConnectionHandle ch) {
        return this.createEmptyResultSet(MetaClientInfoProperty.class);
    }

    @Override
    public Meta.MetaResultSet getFunctions(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat functionNamePattern) {
        return this.createEmptyResultSet(MetaFunction.class);
    }

    @Override
    public Meta.MetaResultSet getFunctionColumns(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat functionNamePattern, Meta.Pat columnNamePattern) {
        return this.createEmptyResultSet(MetaFunctionColumn.class);
    }

    @Override
    public Meta.MetaResultSet getPseudoColumns(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, Meta.Pat columnNamePattern) {
        return this.createEmptyResultSet(MetaPseudoColumn.class);
    }

    @Override
    public Iterable<Object> createIterable(Meta.StatementHandle handle, QueryState state, Meta.Signature signature, List<TypedValue> parameterValues, Meta.Frame firstFrame) {
        AvaticaStatement stmt;
        if (firstFrame != null && firstFrame.done) {
            return firstFrame.rows;
        }
        try {
            stmt = this.connection.lookupStatement(handle);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return new FetchIterable(stmt, state, firstFrame);
    }

    public Meta.Frame fetch(AvaticaStatement stmt, List<TypedValue> parameterValues, long offset, int fetchMaxRowCount) throws NoSuchStatementException, MissingResultsException {
        return null;
    }

    public static boolean checkParameterValueHasNull(List<TypedValue> parameterValues) {
        for (TypedValue x : parameterValues) {
            if (x != null) continue;
            return true;
        }
        return false;
    }

    private class FetchIterator
    implements Iterator<Object> {
        private final AvaticaStatement stmt;
        private final QueryState state;
        private Meta.Frame frame;
        private Iterator<Object> rows;
        private long currentOffset = 0L;

        public FetchIterator(AvaticaStatement stmt, QueryState state, Meta.Frame firstFrame) {
            this.stmt = stmt;
            this.state = state;
            if (firstFrame == null) {
                this.frame = Meta.Frame.MORE;
                this.rows = EmptyIterator.INSTANCE;
            } else {
                this.frame = firstFrame;
                this.rows = firstFrame.rows.iterator();
            }
            this.moveNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public boolean hasNext() {
            return this.rows != null;
        }

        @Override
        public Object next() {
            if (this.rows == null) {
                throw new NoSuchElementException();
            }
            Object o = this.rows.next();
            ++this.currentOffset;
            this.moveNext();
            return o;
        }

        private void moveNext() {
            while (!this.rows.hasNext()) {
                if (this.frame.done) {
                    this.rows = null;
                    break;
                }
                try {
                    this.frame = MetaImpl.this.fetch(this.stmt.handle, this.currentOffset, 100);
                }
                catch (NoSuchStatementException e) {
                    this.resetStatement();
                    continue;
                }
                catch (MissingResultsException e) {
                    try {
                        if (this.stmt.syncResults(this.state, this.currentOffset)) continue;
                        this.frame = null;
                        this.rows = null;
                        break;
                    }
                    catch (NoSuchStatementException e1) {
                        this.resetStatement();
                        continue;
                    }
                }
                if (this.frame == null) {
                    this.rows = null;
                    break;
                }
                this.rows = this.frame.rows.iterator();
            }
        }

        private void resetStatement() {
            this.stmt.resetStatement();
        }
    }

    private class FetchIterable
    implements Iterable<Object> {
        private final AvaticaStatement stmt;
        private final QueryState state;
        private final Meta.Frame firstFrame;

        public FetchIterable(AvaticaStatement stmt, QueryState state, Meta.Frame firstFrame) {
            this.stmt = stmt;
            this.state = state;
            this.firstFrame = firstFrame;
        }

        @Override
        public Iterator<Object> iterator() {
            return new FetchIterator(this.stmt, this.state, this.firstFrame);
        }
    }

    private static class EmptyIterator
    implements Iterator<Object> {
        public static final Iterator<Object> INSTANCE = new EmptyIterator();

        private EmptyIterator() {
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }
    }

    private static class TypeInfo {
        private static Map<Class<?>, TypeInfo> m = new HashMap();
        private final int sqlType;
        private final String sqlTypeName;

        public TypeInfo(int sqlType, String sqlTypeName) {
            this.sqlType = sqlType;
            this.sqlTypeName = sqlTypeName;
        }

        static void put(Class<?> clazz, int sqlType, String sqlTypeName) {
            m.put(clazz, new TypeInfo(sqlType, sqlTypeName));
        }

        static {
            TypeInfo.put(Boolean.TYPE, 16, "BOOLEAN");
            TypeInfo.put(Boolean.class, 16, "BOOLEAN");
            TypeInfo.put(Byte.TYPE, -6, "TINYINT");
            TypeInfo.put(Byte.class, -6, "TINYINT");
            TypeInfo.put(Short.TYPE, 5, "SMALLINT");
            TypeInfo.put(Short.class, 5, "SMALLINT");
            TypeInfo.put(Integer.TYPE, 4, "INTEGER");
            TypeInfo.put(Integer.class, 4, "INTEGER");
            TypeInfo.put(Long.TYPE, -5, "BIGINT");
            TypeInfo.put(Long.class, -5, "BIGINT");
            TypeInfo.put(Float.TYPE, 6, "FLOAT");
            TypeInfo.put(Float.class, 6, "FLOAT");
            TypeInfo.put(Double.TYPE, 8, "DOUBLE");
            TypeInfo.put(Double.class, 8, "DOUBLE");
            TypeInfo.put(String.class, 12, "VARCHAR");
            TypeInfo.put(Date.class, 91, "DATE");
            TypeInfo.put(Time.class, 92, "TIME");
            TypeInfo.put(Timestamp.class, 93, "TIMESTAMP");
        }
    }

    public static class MetaSuperTable {
        public final String tableCat;
        public final String tableSchem;
        @ColumnNoNulls
        public final String tableName;
        @ColumnNoNulls
        public final String supertableName;

        public MetaSuperTable(String tableCat, String tableSchem, String tableName, String supertableName) {
            this.tableCat = tableCat;
            this.tableSchem = tableSchem;
            this.tableName = tableName;
            this.supertableName = supertableName;
        }
    }

    public static class MetaPseudoColumn {
        public final String tableCat;
        public final String tableSchem;
        @ColumnNoNulls
        public final String tableName;
        @ColumnNoNulls
        public final String columnName;
        public final int dataType;
        public final Integer columnSize;
        public final Integer decimalDigits;
        public final Integer numPrecRadix;
        @ColumnNoNulls
        public final String columnUsage;
        public final String remarks;
        public final Integer charOctetLength;
        @ColumnNoNulls
        public final String isNullable;

        public MetaPseudoColumn(String tableCat, String tableSchem, String tableName, String columnName, int dataType, Integer columnSize, Integer decimalDigits, Integer numPrecRadix, String columnUsage, Integer charOctetLength, String isNullable) {
            this.remarks = null;
            this.tableCat = tableCat;
            this.tableSchem = tableSchem;
            this.tableName = tableName;
            this.columnName = columnName;
            this.dataType = dataType;
            this.columnSize = columnSize;
            this.decimalDigits = decimalDigits;
            this.numPrecRadix = numPrecRadix;
            this.columnUsage = columnUsage;
            this.charOctetLength = charOctetLength;
            this.isNullable = isNullable;
        }
    }

    public static class MetaFunctionColumn {
        public final String functionCat;
        public final String functionSchem;
        @ColumnNoNulls
        public final String functionName;
        @ColumnNoNulls
        public final String columnName;
        public final short columnType;
        public final int dataType;
        @ColumnNoNulls
        public final String typeName;
        public final Integer precision;
        public final Integer length;
        public final Short scale;
        public final Short radix;
        public final short nullable;
        public final String remarks;
        public final Integer charOctetLength;
        public final int ordinalPosition;
        @ColumnNoNulls
        public final String isNullable;
        public final String specificName;

        public MetaFunctionColumn(String functionCat, String functionSchem, String functionName, String columnName, short columnType, int dataType, String typeName, Integer precision, Integer length, Short scale, Short radix, short nullable, Integer charOctetLength, int ordinalPosition, String isNullable, String specificName) {
            this.remarks = null;
            this.functionCat = functionCat;
            this.functionSchem = functionSchem;
            this.functionName = functionName;
            this.columnName = columnName;
            this.columnType = columnType;
            this.dataType = dataType;
            this.typeName = typeName;
            this.precision = precision;
            this.length = length;
            this.scale = scale;
            this.radix = radix;
            this.nullable = nullable;
            this.charOctetLength = charOctetLength;
            this.ordinalPosition = ordinalPosition;
            this.isNullable = isNullable;
            this.specificName = specificName;
        }
    }

    public static class MetaFunction {
        public final String functionCat;
        public final String functionSchem;
        @ColumnNoNulls
        public final String functionName;
        public final String remarks;
        public final short functionType;
        public final String specificName;

        public MetaFunction(String functionCat, String functionSchem, String functionName, short functionType, String specificName) {
            this.remarks = null;
            this.functionCat = functionCat;
            this.functionSchem = functionSchem;
            this.functionName = functionName;
            this.functionType = functionType;
            this.specificName = specificName;
        }
    }

    public static class MetaClientInfoProperty {
        @ColumnNoNulls
        public final String name;
        public final int maxLen;
        public final String defaultValue;
        public final String description;

        public MetaClientInfoProperty(String name, int maxLen, String defaultValue, String description) {
            this.name = name;
            this.maxLen = maxLen;
            this.defaultValue = defaultValue;
            this.description = description;
        }
    }

    public static class MetaAttribute {
        public final String typeCat;
        public final String typeSchem;
        @ColumnNoNulls
        public final String typeName;
        @ColumnNoNulls
        public final String attrName;
        public final int dataType;
        @ColumnNoNulls
        public String attrTypeName;
        public final Integer attrSize;
        public final Integer decimalDigits;
        public final Integer numPrecRadix;
        public final int nullable;
        public final String remarks;
        public final String attrDef;
        @ColumnNullableUnknown
        public final Integer sqlDataType = null;
        @ColumnNullableUnknown
        public final Integer sqlDatetimeSub = null;
        public final Integer charOctetLength;
        public final int ordinalPosition;
        @ColumnNoNulls
        public final String isNullable;
        public final String scopeCatalog;
        public final String scopeSchema;
        public final String scopeTable;
        public final Short sourceDataType = null;

        public MetaAttribute(String typeCat, String typeSchem, String typeName, String attrName, int dataType, String attrTypeName, Integer attrSize, Integer decimalDigits, Integer numPrecRadix, int nullable, Integer charOctetLength, int ordinalPosition, String isNullable) {
            this.remarks = null;
            this.attrDef = null;
            this.scopeCatalog = null;
            this.scopeSchema = null;
            this.scopeTable = null;
            this.typeCat = typeCat;
            this.typeSchem = typeSchem;
            this.typeName = typeName;
            this.attrName = attrName;
            this.dataType = dataType;
            this.attrTypeName = attrTypeName;
            this.attrSize = attrSize;
            this.decimalDigits = decimalDigits;
            this.numPrecRadix = numPrecRadix;
            this.nullable = nullable;
            this.charOctetLength = charOctetLength;
            this.ordinalPosition = ordinalPosition;
            this.isNullable = isNullable;
        }
    }

    public static class MetaSuperType {
        public final String typeCat;
        public final String typeSchem;
        @ColumnNoNulls
        public final String typeName;
        public final String supertypeCat;
        public final String supertypeSchem;
        @ColumnNoNulls
        public final String supertypeName;

        public MetaSuperType(String typeCat, String typeSchem, String typeName, String supertypeCat, String supertypeSchem, String supertypeName) {
            this.typeCat = typeCat;
            this.typeSchem = typeSchem;
            this.typeName = typeName;
            this.supertypeCat = supertypeCat;
            this.supertypeSchem = supertypeSchem;
            this.supertypeName = supertypeName;
        }
    }

    public static class MetaUdt {
        public final String typeCat;
        public final String typeSchem;
        @ColumnNoNulls
        public final String typeName;
        @ColumnNoNulls
        public final String className;
        public final int dataType;
        public final String remarks;
        public final Short baseType;

        public MetaUdt(String typeCat, String typeSchem, String typeName, String className, int dataType, Short baseType) {
            this.remarks = null;
            this.typeCat = typeCat;
            this.typeSchem = typeSchem;
            this.typeName = typeName;
            this.className = className;
            this.dataType = dataType;
            this.baseType = baseType;
        }
    }

    public static class MetaIndexInfo {
        public final String tableCat;
        public final String tableSchem;
        @ColumnNoNulls
        public final String tableName;
        public final boolean nonUnique;
        public final String indexQualifier;
        public final String indexName;
        public final short type;
        public final short ordinalPosition;
        public final String columnName;
        public final String ascOrDesc;
        public final long cardinality;
        public final long pages;
        public final String filterCondition;

        public MetaIndexInfo(String tableCat, String tableSchem, String tableName, boolean nonUnique, String indexQualifier, String indexName, short type, short ordinalPosition, String columnName, String ascOrDesc, long cardinality, long pages, String filterCondition) {
            this.tableCat = tableCat;
            this.tableSchem = tableSchem;
            this.tableName = tableName;
            this.nonUnique = nonUnique;
            this.indexQualifier = indexQualifier;
            this.indexName = indexName;
            this.type = type;
            this.ordinalPosition = ordinalPosition;
            this.columnName = columnName;
            this.ascOrDesc = ascOrDesc;
            this.cardinality = cardinality;
            this.pages = pages;
            this.filterCondition = filterCondition;
        }
    }

    public static class MetaTypeInfo
    implements Named {
        @ColumnNoNulls
        public final String typeName;
        public final int dataType;
        public final Integer precision;
        public final String literalPrefix;
        public final String literalSuffix;
        public final String createParams;
        public final short nullable;
        public final boolean caseSensitive;
        public final short searchable;
        public final boolean unsignedAttribute;
        public final boolean fixedPrecScale;
        public final boolean autoIncrement;
        public final String localTypeName;
        public final Short minimumScale;
        public final Short maximumScale;
        @ColumnNullableUnknown
        public final Integer sqlDataType = null;
        @ColumnNullableUnknown
        public final Integer sqlDatetimeSub = null;
        public final Integer numPrecRadix;

        public MetaTypeInfo(String typeName, int dataType, Integer precision, String literalPrefix, String literalSuffix, short nullable, boolean caseSensitive, short searchable, boolean unsignedAttribute, boolean fixedPrecScale, boolean autoIncrement, Short minimumScale, Short maximumScale, Integer numPrecRadix) {
            this.createParams = null;
            this.typeName = typeName;
            this.dataType = dataType;
            this.precision = precision;
            this.literalPrefix = literalPrefix;
            this.literalSuffix = literalSuffix;
            this.nullable = nullable;
            this.caseSensitive = caseSensitive;
            this.searchable = searchable;
            this.unsignedAttribute = unsignedAttribute;
            this.fixedPrecScale = fixedPrecScale;
            this.autoIncrement = autoIncrement;
            this.localTypeName = typeName;
            this.minimumScale = minimumScale;
            this.maximumScale = maximumScale;
            this.numPrecRadix = numPrecRadix == 0 ? null : numPrecRadix;
        }

        @Override
        public String getName() {
            return this.typeName;
        }
    }

    public static class MetaCrossReference {
        public final String pktableCat;
        public final String pktableSchem;
        @ColumnNoNulls
        public final String pktableName;
        @ColumnNoNulls
        public final String pkcolumnName;
        public final String fktableCat;
        public final String fktableSchem;
        @ColumnNoNulls
        public final String fktableName;
        @ColumnNoNulls
        public final String fkcolumnName;
        public final short keySeq;
        public final short updateRule;
        public final short deleteRule;
        public final String fkName;
        public final String pkName;
        public final short deferability;

        public MetaCrossReference(String pktableCat, String pktableSchem, String pktableName, String pkcolumnName, String fktableCat, String fktableSchem, String fktableName, String fkcolumnName, short keySeq, short updateRule, short deleteRule, String fkName, String pkName, short deferability) {
            this.pktableCat = pktableCat;
            this.pktableSchem = pktableSchem;
            this.pktableName = pktableName;
            this.pkcolumnName = pkcolumnName;
            this.fktableCat = fktableCat;
            this.fktableSchem = fktableSchem;
            this.fktableName = fktableName;
            this.fkcolumnName = fkcolumnName;
            this.keySeq = keySeq;
            this.updateRule = updateRule;
            this.deleteRule = deleteRule;
            this.fkName = fkName;
            this.pkName = pkName;
            this.deferability = deferability;
        }
    }

    public static class MetaExportedKey {
        public final String pktableCat;
        public final String pktableSchem;
        @ColumnNoNulls
        public final String pktableName;
        @ColumnNoNulls
        public final String pkcolumnName;
        public final String fktableCat;
        public final String fktableSchem;
        @ColumnNoNulls
        public final String fktableName;
        @ColumnNoNulls
        public final String fkcolumnName;
        public final short keySeq;
        public final short updateRule;
        public final short deleteRule;
        public final String fkName;
        public final String pkName;
        public final short deferability;

        public MetaExportedKey(String pktableCat, String pktableSchem, String pktableName, String pkcolumnName, String fktableCat, String fktableSchem, String fktableName, String fkcolumnName, short keySeq, short updateRule, short deleteRule, String fkName, String pkName, short deferability) {
            this.pktableCat = pktableCat;
            this.pktableSchem = pktableSchem;
            this.pktableName = pktableName;
            this.pkcolumnName = pkcolumnName;
            this.fktableCat = fktableCat;
            this.fktableSchem = fktableSchem;
            this.fktableName = fktableName;
            this.fkcolumnName = fkcolumnName;
            this.keySeq = keySeq;
            this.updateRule = updateRule;
            this.deleteRule = deleteRule;
            this.fkName = fkName;
            this.pkName = pkName;
            this.deferability = deferability;
        }
    }

    public static class MetaImportedKey {
        public final String pktableCat;
        public final String pktableSchem;
        @ColumnNoNulls
        public final String pktableName;
        @ColumnNoNulls
        public final String pkcolumnName;
        public final String fktableCat;
        public final String fktableSchem;
        @ColumnNoNulls
        public final String fktableName;
        @ColumnNoNulls
        public final String fkcolumnName;
        public final short keySeq;
        public final short updateRule;
        public final short deleteRule;
        public final String fkName;
        public final String pkName;
        public final short deferability;

        public MetaImportedKey(String pktableCat, String pktableSchem, String pktableName, String pkcolumnName, String fktableCat, String fktableSchem, String fktableName, String fkcolumnName, short keySeq, short updateRule, short deleteRule, String fkName, String pkName, short deferability) {
            this.pktableCat = pktableCat;
            this.pktableSchem = pktableSchem;
            this.pktableName = pktableName;
            this.pkcolumnName = pkcolumnName;
            this.fktableCat = fktableCat;
            this.fktableSchem = fktableSchem;
            this.fktableName = fktableName;
            this.fkcolumnName = fkcolumnName;
            this.keySeq = keySeq;
            this.updateRule = updateRule;
            this.deleteRule = deleteRule;
            this.fkName = fkName;
            this.pkName = pkName;
            this.deferability = deferability;
        }
    }

    public static class MetaPrimaryKey {
        public final String tableCat;
        public final String tableSchem;
        @ColumnNoNulls
        public final String tableName;
        @ColumnNoNulls
        public final String columnName;
        public final short keySeq;
        public final String pkName;

        MetaPrimaryKey(String tableCat, String tableSchem, String tableName, String columnName, short keySeq, String pkName) {
            this.tableCat = tableCat;
            this.tableSchem = tableSchem;
            this.tableName = tableName;
            this.columnName = columnName;
            this.keySeq = keySeq;
            this.pkName = pkName;
        }
    }

    public static class MetaVersionColumn {
        @ColumnNullableUnknown
        public final Short scope;
        @ColumnNoNulls
        public final String columnName;
        public final int dataType;
        @ColumnNoNulls
        public final String typeName;
        public final Integer columnSize;
        public final Integer bufferLength;
        public final Short decimalDigits;
        public final short pseudoColumn;

        MetaVersionColumn(Short scope, String columnName, int dataType, String typeName, Integer columnSize, Integer bufferLength, Short decimalDigits, short pseudoColumn) {
            this.scope = scope;
            this.columnName = columnName;
            this.dataType = dataType;
            this.typeName = typeName;
            this.columnSize = columnSize;
            this.bufferLength = bufferLength;
            this.decimalDigits = decimalDigits;
            this.pseudoColumn = pseudoColumn;
        }
    }

    public static class MetaBestRowIdentifier {
        public final short scope;
        @ColumnNoNulls
        public final String columnName;
        public final int dataType;
        @ColumnNoNulls
        public final String typeName;
        public final Integer columnSize;
        @ColumnNullableUnknown
        public final Integer bufferLength = null;
        public final Short decimalDigits;
        public short pseudoColumn;

        public MetaBestRowIdentifier(short scope, String columnName, int dataType, String typeName, Integer columnSize, Short decimalDigits, short pseudoColumn) {
            this.scope = scope;
            this.columnName = columnName;
            this.dataType = dataType;
            this.typeName = typeName;
            this.columnSize = columnSize;
            this.decimalDigits = decimalDigits;
            this.pseudoColumn = pseudoColumn;
        }
    }

    public static class MetaTablePrivilege {
        public final String tableCat;
        public final String tableSchem;
        @ColumnNoNulls
        public final String tableName;
        public final String grantor;
        @ColumnNoNulls
        public final String grantee;
        @ColumnNoNulls
        public final String privilege;
        public final String isGrantable;

        public MetaTablePrivilege(String tableCat, String tableSchem, String tableName, String grantor, String grantee, String privilege, String isGrantable) {
            this.tableCat = tableCat;
            this.tableSchem = tableSchem;
            this.tableName = tableName;
            this.grantor = grantor;
            this.grantee = grantee;
            this.privilege = privilege;
            this.isGrantable = isGrantable;
        }
    }

    public static class MetaColumnPrivilege {
        public final String tableCat;
        public final String tableSchem;
        @ColumnNoNulls
        public final String tableName;
        @ColumnNoNulls
        public final String columnName;
        public final String grantor;
        @ColumnNoNulls
        public final String grantee;
        @ColumnNoNulls
        public final String privilege;
        public final String isGrantable;

        public MetaColumnPrivilege(String tableCat, String tableSchem, String tableName, String columnName, String grantor, String grantee, String privilege, String isGrantable) {
            this.tableCat = tableCat;
            this.tableSchem = tableSchem;
            this.tableName = tableName;
            this.columnName = columnName;
            this.grantor = grantor;
            this.grantee = grantee;
            this.privilege = privilege;
            this.isGrantable = isGrantable;
        }
    }

    public static class MetaProcedureColumn {
        public final String procedureCat;
        public final String procedureSchem;
        @ColumnNoNulls
        public final String procedureName;
        @ColumnNoNulls
        public final String columnName;
        public final short columnType;
        public final int dataType;
        @ColumnNoNulls
        public final String typeName;
        public final Integer precision;
        public final Integer length;
        public final Short scale;
        public final Short radix;
        public final short nullable;
        public final String remarks;
        public final String columnDef;
        @ColumnNullableUnknown
        public final Integer sqlDataType = null;
        @ColumnNullableUnknown
        public final Integer sqlDatetimeSub = null;
        public final Integer charOctetLength;
        public final int ordinalPosition;
        @ColumnNoNulls
        public final String isNullable;
        public final String specificName;

        public MetaProcedureColumn(String procedureCat, String procedureSchem, String procedureName, String columnName, short columnType, int dataType, String typeName, Integer precision, Integer length, Short scale, Short radix, short nullable, String columnDef, Integer charOctetLength, int ordinalPosition, String isNullable, String specificName) {
            this.remarks = null;
            this.procedureCat = procedureCat;
            this.procedureSchem = procedureSchem;
            this.procedureName = procedureName;
            this.columnName = columnName;
            this.columnType = columnType;
            this.dataType = dataType;
            this.typeName = typeName;
            this.precision = precision;
            this.length = length;
            this.scale = scale;
            this.radix = radix;
            this.nullable = nullable;
            this.columnDef = columnDef;
            this.charOctetLength = charOctetLength;
            this.ordinalPosition = ordinalPosition;
            this.isNullable = isNullable;
            this.specificName = specificName;
        }
    }

    public static class MetaProcedure {
        public final String procedureCat;
        public final String procedureSchem;
        @ColumnNoNulls
        public final String procedureName;
        public final String futureUse1;
        public final String futureUse2;
        public final String futureUse3;
        public final String remarks;
        public final short procedureType;
        public final String specificName;

        public MetaProcedure(String procedureCat, String procedureSchem, String procedureName, short procedureType, String specificName) {
            this.futureUse1 = null;
            this.futureUse2 = null;
            this.futureUse3 = null;
            this.remarks = null;
            this.procedureCat = procedureCat;
            this.procedureSchem = procedureSchem;
            this.procedureName = procedureName;
            this.procedureType = procedureType;
            this.specificName = specificName;
        }
    }

    public static class MetaTableType {
        @ColumnNoNulls
        public final String tableType;

        public MetaTableType(String tableType) {
            this.tableType = tableType;
        }
    }

    public static class MetaCatalog
    implements Named {
        @ColumnNoNulls
        public final String tableCat;

        public MetaCatalog(String tableCatalog) {
            this.tableCat = tableCatalog;
        }

        @Override
        public String getName() {
            return this.tableCat;
        }
    }

    public static class MetaSchema
    implements Named {
        @ColumnNoNulls
        public final String tableSchem;
        public final String tableCatalog;

        public MetaSchema(String tableCatalog, String tableSchem) {
            this.tableCatalog = tableCatalog;
            this.tableSchem = tableSchem;
        }

        @Override
        public String getName() {
            return this.tableSchem;
        }
    }

    public static class MetaTable
    implements Named {
        public final String tableCat;
        public final String tableSchem;
        @ColumnNoNulls
        public final String tableName;
        @ColumnNoNulls
        public final String tableType;
        public final String remarks;
        public final String typeCat;
        public final String typeSchem;
        public final String typeName;
        public final String selfReferencingColName;
        public final String refGeneration;

        public MetaTable(String tableCat, String tableSchem, String tableName, String tableType) {
            this.remarks = null;
            this.typeCat = null;
            this.typeSchem = null;
            this.typeName = null;
            this.selfReferencingColName = null;
            this.refGeneration = null;
            this.tableCat = tableCat;
            this.tableSchem = tableSchem;
            this.tableName = tableName;
            this.tableType = tableType;
        }

        @Override
        public String getName() {
            return this.tableName;
        }
    }

    public static class MetaColumn
    implements Named {
        public final String tableCat;
        public final String tableSchem;
        @ColumnNoNulls
        public final String tableName;
        @ColumnNoNulls
        public final String columnName;
        public final int dataType;
        @ColumnNoNulls
        public final String typeName;
        public final Integer columnSize;
        @ColumnNullableUnknown
        public final Integer bufferLength = null;
        public final Integer decimalDigits;
        public final Integer numPrecRadix;
        public final int nullable;
        public final String remarks;
        public final String columnDef;
        @ColumnNullableUnknown
        public final Integer sqlDataType = null;
        @ColumnNullableUnknown
        public final Integer sqlDatetimeSub = null;
        public final Integer charOctetLength;
        public final int ordinalPosition;
        @ColumnNoNulls
        public final String isNullable;
        public final String scopeCatalog;
        public final String scopeSchema;
        public final String scopeTable;
        public final Short sourceDataType = null;
        @ColumnNoNulls
        public final String isAutoincrement = "";
        @ColumnNoNulls
        public final String isGeneratedcolumn = "";

        public MetaColumn(String tableCat, String tableSchem, String tableName, String columnName, int dataType, String typeName, Integer columnSize, Integer decimalDigits, Integer numPrecRadix, int nullable, Integer charOctetLength, int ordinalPosition, String isNullable) {
            this.remarks = null;
            this.columnDef = null;
            this.scopeCatalog = null;
            this.scopeSchema = null;
            this.scopeTable = null;
            this.tableCat = tableCat;
            this.tableSchem = tableSchem;
            this.tableName = tableName;
            this.columnName = columnName;
            this.dataType = dataType;
            this.typeName = typeName;
            this.columnSize = columnSize;
            this.decimalDigits = decimalDigits;
            this.numPrecRadix = numPrecRadix;
            this.nullable = nullable;
            this.charOctetLength = charOctetLength;
            this.ordinalPosition = ordinalPosition;
            this.isNullable = isNullable;
        }

        @Override
        public String getName() {
            return this.columnName;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ColumnNoNulls {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ColumnNullableUnknown {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ColumnNullable {
    }

    public static interface Named {
        @JsonIgnore
        public String getName();
    }
}

