/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.elasticsearch;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.elasticsearch.ElasticsearchFilter;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.elasticsearch.ElasticsearchProject;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.elasticsearch.ElasticsearchRel;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.elasticsearch.ElasticsearchSort;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.Convention;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptRule;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelTrait;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.RelCollations;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.RelNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.convert.ConverterRule;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.Sort;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.logical.LogicalProject;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexCall;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexInputRef;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexVisitorImpl;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlKind;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.validate.SqlValidatorUtil;

class ElasticsearchRules {
    static final RelOptRule[] RULES = new RelOptRule[]{ElasticsearchSortRule.access$000(), ElasticsearchFilterRule.access$100(), ElasticsearchProjectRule.access$200()};

    private ElasticsearchRules() {
    }

    static String isItem(RexCall call) {
        if (call.getOperator() != SqlStdOperatorTable.ITEM) {
            return null;
        }
        RexNode op0 = call.getOperands().get(0);
        RexNode op1 = call.getOperands().get(1);
        if (op0 instanceof RexInputRef && ((RexInputRef)op0).getIndex() == 0 && op1 instanceof RexLiteral && ((RexLiteral)op1).getValue2() instanceof String) {
            return (String)((RexLiteral)op1).getValue2();
        }
        return null;
    }

    static List<String> elasticsearchFieldNames(final RelDataType rowType) {
        return SqlValidatorUtil.uniquify((List<String>)new AbstractList<String>(){

            @Override
            public String get(int index) {
                String name = rowType.getFieldList().get(index).getName();
                return name.startsWith("$") ? "_" + name.substring(2) : name;
            }

            @Override
            public int size() {
                return rowType.getFieldCount();
            }
        }, SqlValidatorUtil.EXPR_SUGGESTER, true);
    }

    static String quote(String s) {
        return "\"" + s + "\"";
    }

    private static class ElasticsearchProjectRule
    extends ElasticsearchConverterRule {
        private static final ElasticsearchProjectRule INSTANCE = new ElasticsearchProjectRule();

        private ElasticsearchProjectRule() {
            super(LogicalProject.class, (RelTrait)Convention.NONE, ElasticsearchRel.CONVENTION, "ElasticsearchProjectRule");
        }

        @Override
        public RelNode convert(RelNode relNode) {
            LogicalProject project = (LogicalProject)relNode;
            RelTraitSet traitSet = project.getTraitSet().replace(this.out);
            return new ElasticsearchProject(project.getCluster(), traitSet, ElasticsearchProjectRule.convert(project.getInput(), this.out), project.getProjects(), project.getRowType());
        }

        static /* synthetic */ ElasticsearchProjectRule access$200() {
            return INSTANCE;
        }
    }

    private static class ElasticsearchFilterRule
    extends ElasticsearchConverterRule {
        private static final ElasticsearchFilterRule INSTANCE = new ElasticsearchFilterRule();

        private ElasticsearchFilterRule() {
            super(LogicalFilter.class, (RelTrait)Convention.NONE, ElasticsearchRel.CONVENTION, "ElasticsearchFilterRule");
        }

        @Override
        public RelNode convert(RelNode relNode) {
            LogicalFilter filter = (LogicalFilter)relNode;
            RelTraitSet traitSet = filter.getTraitSet().replace(this.out);
            return new ElasticsearchFilter(relNode.getCluster(), traitSet, ElasticsearchFilterRule.convert(filter.getInput(), this.out), filter.getCondition());
        }

        static /* synthetic */ ElasticsearchFilterRule access$100() {
            return INSTANCE;
        }
    }

    private static class ElasticsearchSortRule
    extends ElasticsearchConverterRule {
        private static final ElasticsearchSortRule INSTANCE = new ElasticsearchSortRule();

        private ElasticsearchSortRule() {
            super(Sort.class, (RelTrait)Convention.NONE, ElasticsearchRel.CONVENTION, "ElasticsearchSortRule");
        }

        @Override
        public RelNode convert(RelNode relNode) {
            Sort sort = (Sort)relNode;
            RelTraitSet traitSet = sort.getTraitSet().replace(this.out).replace(sort.getCollation());
            return new ElasticsearchSort(relNode.getCluster(), traitSet, ElasticsearchSortRule.convert(sort.getInput(), traitSet.replace(RelCollations.EMPTY)), sort.getCollation(), sort.offset, sort.fetch);
        }

        static /* synthetic */ ElasticsearchSortRule access$000() {
            return INSTANCE;
        }
    }

    static abstract class ElasticsearchConverterRule
    extends ConverterRule {
        final Convention out;

        ElasticsearchConverterRule(Class<? extends RelNode> clazz, RelTrait in, Convention out, String description) {
            super(clazz, in, out, description);
            this.out = out;
        }
    }

    static class RexToElasticsearchTranslator
    extends RexVisitorImpl<String> {
        private final JavaTypeFactory typeFactory;
        private final List<String> inFields;

        RexToElasticsearchTranslator(JavaTypeFactory typeFactory, List<String> inFields) {
            super(true);
            this.typeFactory = typeFactory;
            this.inFields = inFields;
        }

        @Override
        public String visitLiteral(RexLiteral literal) {
            if (literal.getValue() == null) {
                return "null";
            }
            return "\"literal\":\"" + RexToLixTranslator.translateLiteral(literal, literal.getType(), this.typeFactory, RexImpTable.NullAs.NOT_POSSIBLE) + "\"";
        }

        @Override
        public String visitInputRef(RexInputRef inputRef) {
            return ElasticsearchRules.quote(this.inFields.get(inputRef.getIndex()));
        }

        @Override
        public String visitCall(RexCall call) {
            RexNode op1;
            String name = ElasticsearchRules.isItem(call);
            if (name != null) {
                return "\"" + name + "\"";
            }
            List<String> strings = this.visitList(call.operands);
            if (call.getKind() == SqlKind.CAST) {
                return strings.get(0).startsWith("$") ? strings.get(0).substring(1) : strings.get(0);
            }
            if (call.getOperator() == SqlStdOperatorTable.ITEM && (op1 = call.getOperands().get(1)) instanceof RexLiteral && op1.getType().getSqlTypeName() == SqlTypeName.INTEGER) {
                return this.stripQuotes(strings.get(0)) + "[" + ((RexLiteral)op1).getValue2() + "]";
            }
            throw new IllegalArgumentException("Translation of " + call.toString() + "is not supported by ElasticsearchProject");
        }

        private String stripQuotes(String s) {
            return s.startsWith("'") && s.endsWith("'") ? s.substring(1, s.length() - 1) : s;
        }

        List<String> visitList(List<RexNode> list) {
            ArrayList<String> strings = new ArrayList<String>();
            for (RexNode node : list) {
                strings.add(node.accept(this));
            }
            return strings;
        }
    }
}

