/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.elasticsearch;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.elasticsearch.ElasticsearchRel;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.elasticsearch.ElasticsearchRules;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptCost;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.RelNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.Project;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.Pair;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.Util;

public class ElasticsearchProject
extends Project
implements ElasticsearchRel {
    public ElasticsearchProject(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<? extends RexNode> projects, RelDataType rowType) {
        super(cluster, traitSet, input, projects, rowType);
        assert (this.getConvention() == ElasticsearchRel.CONVENTION);
        assert (this.getConvention() == input.getConvention());
    }

    @Override
    public Project copy(RelTraitSet relTraitSet, RelNode input, List<RexNode> projects, RelDataType relDataType) {
        return new ElasticsearchProject(this.getCluster(), this.traitSet, input, projects, relDataType);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.1);
    }

    @Override
    public void implement(ElasticsearchRel.Implementor implementor) {
        implementor.visitChild(0, this.getInput());
        List<String> inFields = ElasticsearchRules.elasticsearchFieldNames(this.getInput().getRowType());
        ElasticsearchRules.RexToElasticsearchTranslator translator = new ElasticsearchRules.RexToElasticsearchTranslator((JavaTypeFactory)this.getCluster().getTypeFactory(), inFields);
        ArrayList<String> findItems = new ArrayList<String>();
        ArrayList<String> scriptFieldItems = new ArrayList<String>();
        for (Pair<RexNode, String> pair : this.getNamedProjects()) {
            String name = (String)pair.right;
            String expr = ((RexNode)pair.left).accept(translator);
            if (expr.equals("\"" + name + "\"")) {
                findItems.add(ElasticsearchRules.quote(name));
                continue;
            }
            if (expr.matches("\"literal\":.+")) {
                scriptFieldItems.add(ElasticsearchRules.quote(name) + ":{\"script\": " + expr.split(":")[1] + "}");
                continue;
            }
            scriptFieldItems.add(ElasticsearchRules.quote(name) + ":{\"script\":\"params._source." + expr.replaceAll("\"", "") + "\"}");
        }
        String findString = Util.toString(findItems, "", ", ", "");
        String scriptFieldString = "\"script_fields\": {" + Util.toString(scriptFieldItems, "", ", ", "") + "}";
        String fieldString = "\"_source\" : [" + findString + "], " + scriptFieldString;
        for (String opfield : implementor.list) {
            if (!opfield.startsWith("\"_source\"")) continue;
            implementor.list.remove(opfield);
        }
        implementor.add(fieldString);
    }
}

