/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.store;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.store.MetaStore;

public class InMemoryMetaStore
implements MetaStore {
    private Map<String, Table> tables = new HashMap<String, Table>();
    private Map<String, TableProvider> providers = new HashMap<String, TableProvider>();

    @Override
    public void createTable(Table table) {
        this.validateTableType(table);
        if (this.tables.containsKey(table.getName())) {
            throw new IllegalArgumentException("Duplicate table name: " + table.getName());
        }
        this.providers.get(table.getType()).createTable(table);
        this.tables.put(table.getName(), table);
    }

    @Override
    public void dropTable(String tableName) {
        if (!this.tables.containsKey(tableName)) {
            throw new IllegalArgumentException("No such table: " + tableName);
        }
        Table table = this.tables.get(tableName);
        this.providers.get(table.getType()).dropTable(tableName);
        this.tables.remove(tableName);
    }

    @Override
    public Table getTable(String tableName) {
        if (tableName == null) {
            return null;
        }
        return this.tables.get(tableName.toLowerCase());
    }

    @Override
    public List<Table> listTables() {
        return new ArrayList<Table>(this.tables.values());
    }

    @Override
    public BeamSqlTable buildBeamSqlTable(String tableName) {
        Table table = this.getTable(tableName);
        if (table == null) {
            throw new IllegalArgumentException("The specified table: " + tableName + " does not exists!");
        }
        TableProvider provider = this.providers.get(table.getType());
        return provider.buildBeamSqlTable(table);
    }

    private void validateTableType(Table table) {
        if (!this.providers.containsKey(table.getType())) {
            throw new IllegalArgumentException("Table type: " + table.getType() + " not supported!");
        }
    }

    @Override
    public void registerProvider(TableProvider provider) {
        if (this.providers.containsKey(provider.getTableType())) {
            throw new IllegalArgumentException("Provider is already registered for table type: " + provider.getTableType());
        }
        this.providers.put(provider.getTableType(), provider);
        this.initTablesFromProvider(provider);
    }

    private void initTablesFromProvider(TableProvider provider) {
        List<Table> tables = provider.listTables();
        for (Table table : tables) {
            if (this.tables.containsKey(table.getName())) {
                throw new IllegalStateException("Duplicate table: " + table.getName() + " from provider: " + provider);
            }
            this.tables.put(table.getName(), table);
        }
    }

    Map<String, TableProvider> getProviders() {
        return this.providers;
    }
}

