/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.text;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.MetaUtils;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.text.BeamTextCSVTable;
import org.apache.beam.sdk.values.RowType;
import org.apache.commons.csv.CSVFormat;

public class TextTableProvider
implements TableProvider {
    @Override
    public String getTableType() {
        return "text";
    }

    @Override
    public BeamSqlTable buildBeamSqlTable(Table table) {
        RowType rowType = MetaUtils.getRowTypeFromTable(table);
        String filePattern = table.getLocationAsString();
        CSVFormat format = CSVFormat.DEFAULT;
        JSONObject properties = table.getProperties();
        String csvFormatStr = properties.getString("format");
        if (csvFormatStr != null && !csvFormatStr.isEmpty()) {
            format = CSVFormat.valueOf((String)csvFormatStr);
        }
        BeamTextCSVTable txtTable = new BeamTextCSVTable(rowType, filePattern, format);
        return txtTable;
    }

    @Override
    public void createTable(Table table) {
    }

    @Override
    public void dropTable(String tableName) {
    }

    @Override
    public List<Table> listTables() {
        return Collections.emptyList();
    }

    @Override
    public void init() {
    }

    @Override
    public void close() {
    }
}

