/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.kafka;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.MetaUtils;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.kafka.BeamKafkaCSVTable;
import org.apache.beam.sdk.values.RowType;

public class KafkaTableProvider
implements TableProvider {
    @Override
    public BeamSqlTable buildBeamSqlTable(Table table) {
        RowType rowType = MetaUtils.getRowTypeFromTable(table);
        JSONObject properties = table.getProperties();
        String bootstrapServers = properties.getString("bootstrap.servers");
        JSONArray topicsArr = properties.getJSONArray("topics");
        ArrayList<String> topics = new ArrayList<String>(topicsArr.size());
        for (Object topic : topicsArr) {
            topics.add(topic.toString());
        }
        BeamKafkaCSVTable txtTable = new BeamKafkaCSVTable(rowType, bootstrapServers, topics);
        return txtTable;
    }

    @Override
    public String getTableType() {
        return "kafka";
    }

    @Override
    public void createTable(Table table) {
    }

    @Override
    public void dropTable(String tableName) {
    }

    @Override
    public List<Table> listTables() {
        return Collections.emptyList();
    }

    @Override
    public void init() {
    }

    @Override
    public void close() {
    }
}

