/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.parser;

import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlNodeList;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlWriter;

class UnparseUtil {
    private final SqlWriter writer;
    private final int leftPrec;
    private final int rightPrec;

    UnparseUtil(SqlWriter writer, int leftPrec, int rightPrec) {
        this.writer = writer;
        this.leftPrec = leftPrec;
        this.rightPrec = rightPrec;
    }

    UnparseUtil keyword(String ... keywords) {
        for (String k : keywords) {
            this.writer.keyword(k);
        }
        return this;
    }

    UnparseUtil node(SqlNode n) {
        n.unparse(this.writer, this.leftPrec, this.rightPrec);
        return this;
    }

    UnparseUtil nodeList(SqlNodeList l) {
        this.writer.keyword("(");
        if (l.size() > 0) {
            l.get(0).unparse(this.writer, this.leftPrec, this.rightPrec);
            for (int i = 1; i < l.size(); ++i) {
                this.writer.keyword(",");
                l.get(i).unparse(this.writer, this.leftPrec, this.rightPrec);
            }
        }
        this.writer.keyword(")");
        return this;
    }
}

