/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.string;

import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;

public class BeamSqlOverlayExpression
extends BeamSqlExpression {
    public BeamSqlOverlayExpression(List<BeamSqlExpression> operands) {
        super(operands, SqlTypeName.VARCHAR);
    }

    @Override
    public boolean accept() {
        if (this.operands.size() < 3 || this.operands.size() > 4) {
            return false;
        }
        if (!(SqlTypeName.CHAR_TYPES.contains((Object)this.opType(0)) && SqlTypeName.CHAR_TYPES.contains((Object)this.opType(1)) && SqlTypeName.INT_TYPES.contains((Object)this.opType(2)))) {
            return false;
        }
        return this.operands.size() != 4 || SqlTypeName.INT_TYPES.contains((Object)this.opType(3));
    }

    @Override
    public BeamSqlPrimitive evaluate(Row inputRow, BoundedWindow window) {
        String str = (String)this.opValueEvaluated(0, inputRow, window);
        String replaceStr = (String)this.opValueEvaluated(1, inputRow, window);
        int idx = (Integer)this.opValueEvaluated(2, inputRow, window);
        --idx;
        int length = replaceStr.length();
        if (this.operands.size() == 4) {
            length = (Integer)this.opValueEvaluated(3, inputRow, window);
        }
        StringBuilder result = new StringBuilder(str.length() + replaceStr.length() - length);
        result.append(str.substring(0, idx)).append(replaceStr).append(str.substring(idx + length));
        return BeamSqlPrimitive.of(SqlTypeName.VARCHAR, result.toString());
    }
}

