/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.arithmetic;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;

public abstract class BeamSqlArithmeticExpression
extends BeamSqlExpression {
    private static final List<SqlTypeName> ORDERED_APPROX_TYPES = new ArrayList<SqlTypeName>();

    protected BeamSqlArithmeticExpression(List<BeamSqlExpression> operands) {
        super(operands, BeamSqlArithmeticExpression.deduceOutputType(operands.get(0).getOutputType(), operands.get(1).getOutputType()));
    }

    protected BeamSqlArithmeticExpression(List<BeamSqlExpression> operands, SqlTypeName outputType) {
        super(operands, outputType);
    }

    @Override
    public BeamSqlPrimitive<? extends Number> evaluate(Row inputRow, BoundedWindow window) {
        BigDecimal left = BigDecimal.valueOf(Double.valueOf(this.opValueEvaluated(0, inputRow, window).toString()));
        BigDecimal right = BigDecimal.valueOf(Double.valueOf(this.opValueEvaluated(1, inputRow, window).toString()));
        BigDecimal result = this.calc(left, right);
        return this.getCorrectlyTypedResult(result);
    }

    protected abstract BigDecimal calc(BigDecimal var1, BigDecimal var2);

    protected static SqlTypeName deduceOutputType(SqlTypeName left, SqlTypeName right) {
        int leftIndex = ORDERED_APPROX_TYPES.indexOf((Object)left);
        int rightIndex = ORDERED_APPROX_TYPES.indexOf((Object)right);
        if (!(left != SqlTypeName.FLOAT && right != SqlTypeName.FLOAT || left != SqlTypeName.DECIMAL && right != SqlTypeName.DECIMAL)) {
            return SqlTypeName.DOUBLE;
        }
        if (leftIndex < rightIndex) {
            return right;
        }
        if (leftIndex > rightIndex) {
            return left;
        }
        return left;
    }

    @Override
    public boolean accept() {
        if (this.operands.size() != 2) {
            return false;
        }
        for (BeamSqlExpression operand : this.operands) {
            if (SqlTypeName.NUMERIC_TYPES.contains((Object)operand.getOutputType())) continue;
            return false;
        }
        return true;
    }

    protected BeamSqlPrimitive<? extends Number> getCorrectlyTypedResult(BigDecimal rawResult) {
        Number actualValue;
        switch (this.outputType) {
            case TINYINT: {
                actualValue = rawResult.byteValue();
                break;
            }
            case SMALLINT: {
                actualValue = rawResult.shortValue();
                break;
            }
            case INTEGER: {
                actualValue = rawResult.intValue();
                break;
            }
            case BIGINT: {
                actualValue = rawResult.longValue();
                break;
            }
            case FLOAT: {
                actualValue = Float.valueOf(rawResult.floatValue());
                break;
            }
            case DOUBLE: {
                actualValue = rawResult.doubleValue();
                break;
            }
            default: {
                actualValue = rawResult;
            }
        }
        return BeamSqlPrimitive.of(this.outputType, actualValue);
    }

    static {
        ORDERED_APPROX_TYPES.add(SqlTypeName.TINYINT);
        ORDERED_APPROX_TYPES.add(SqlTypeName.SMALLINT);
        ORDERED_APPROX_TYPES.add(SqlTypeName.INTEGER);
        ORDERED_APPROX_TYPES.add(SqlTypeName.BIGINT);
        ORDERED_APPROX_TYPES.add(SqlTypeName.FLOAT);
        ORDERED_APPROX_TYPES.add(SqlTypeName.DOUBLE);
        ORDERED_APPROX_TYPES.add(SqlTypeName.DECIMAL);
    }
}

