/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.BigDecimalCoder;
import org.apache.beam.sdk.coders.BigEndianIntegerCoder;
import org.apache.beam.sdk.coders.BigEndianLongCoder;
import org.apache.beam.sdk.coders.ByteCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.extensions.sql.RowHelper;

public abstract class SqlTypeCoder
extends CustomCoder<Object> {
    public void encode(Object value, OutputStream outStream) throws CoderException, IOException {
        this.delegateCoder().encode(value, outStream);
    }

    public Object decode(InputStream inStream) throws CoderException, IOException {
        return this.delegateCoder().decode(inStream);
    }

    public void verifyDeterministic() throws Coder.NonDeterministicException {
        this.delegateCoder().verifyDeterministic();
    }

    protected abstract Coder delegateCoder();

    public boolean equals(Object other) {
        return other != null && ((Object)((Object)this)).getClass().equals(other.getClass());
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    static class SqlTimestampCoder
    extends SqlTypeCoder {
        SqlTimestampCoder() {
        }

        @Override
        protected Coder delegateCoder() {
            return RowHelper.DateCoder.of();
        }
    }

    static class SqlDateCoder
    extends SqlTypeCoder {
        SqlDateCoder() {
        }

        @Override
        protected Coder delegateCoder() {
            return RowHelper.DateCoder.of();
        }
    }

    static class SqlTimeCoder
    extends SqlTypeCoder {
        SqlTimeCoder() {
        }

        @Override
        protected Coder delegateCoder() {
            return RowHelper.TimeCoder.of();
        }
    }

    static class SqlVarCharCoder
    extends SqlTypeCoder {
        SqlVarCharCoder() {
        }

        @Override
        protected Coder delegateCoder() {
            return StringUtf8Coder.of();
        }
    }

    static class SqlCharCoder
    extends SqlTypeCoder {
        SqlCharCoder() {
        }

        @Override
        protected Coder delegateCoder() {
            return StringUtf8Coder.of();
        }
    }

    static class SqlBooleanCoder
    extends SqlTypeCoder {
        SqlBooleanCoder() {
        }

        @Override
        protected Coder delegateCoder() {
            return RowHelper.BooleanCoder.of();
        }
    }

    static class SqlDecimalCoder
    extends SqlTypeCoder {
        SqlDecimalCoder() {
        }

        @Override
        protected Coder delegateCoder() {
            return BigDecimalCoder.of();
        }
    }

    static class SqlDoubleCoder
    extends SqlTypeCoder {
        SqlDoubleCoder() {
        }

        @Override
        protected Coder delegateCoder() {
            return RowHelper.DoubleCoder.of();
        }
    }

    static class SqlFloatCoder
    extends SqlTypeCoder {
        SqlFloatCoder() {
        }

        @Override
        protected Coder delegateCoder() {
            return RowHelper.FloatCoder.of();
        }
    }

    static class SqlBigIntCoder
    extends SqlTypeCoder {
        SqlBigIntCoder() {
        }

        @Override
        protected Coder delegateCoder() {
            return BigEndianLongCoder.of();
        }
    }

    static class SqlIntegerCoder
    extends SqlTypeCoder {
        SqlIntegerCoder() {
        }

        @Override
        protected Coder delegateCoder() {
            return BigEndianIntegerCoder.of();
        }
    }

    static class SqlSmallIntCoder
    extends SqlTypeCoder {
        SqlSmallIntCoder() {
        }

        @Override
        protected Coder delegateCoder() {
            return RowHelper.ShortCoder.of();
        }
    }

    static class SqlTinyIntCoder
    extends SqlTypeCoder {
        SqlTinyIntCoder() {
        }

        @Override
        protected Coder delegateCoder() {
            return ByteCoder.of();
        }
    }
}

