/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.udaf;

import java.nio.charset.StandardCharsets;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.transforms.Combine;

@Experimental
public class StringAgg {

    public static class StringAggByte
    extends Combine.CombineFn<byte[], String, byte[]> {
        private final String delimiter;

        public StringAggByte(byte[] delimiter) {
            this.delimiter = new String(delimiter, StandardCharsets.UTF_8);
        }

        public String createAccumulator() {
            return "";
        }

        public String addInput(String mutableAccumulator, byte[] input) {
            if (input != null) {
                mutableAccumulator = !mutableAccumulator.isEmpty() ? mutableAccumulator + this.delimiter + new String(input, StandardCharsets.UTF_8) : new String(input, StandardCharsets.UTF_8);
            }
            return mutableAccumulator;
        }

        public String mergeAccumulators(Iterable<String> accumList) {
            String mergeString = "";
            for (String stringAccum : accumList) {
                if (stringAccum.isEmpty()) continue;
                if (!mergeString.isEmpty()) {
                    mergeString = mergeString + this.delimiter + stringAccum;
                    continue;
                }
                mergeString = stringAccum;
            }
            return mergeString;
        }

        public byte[] extractOutput(String output) {
            return output.getBytes(StandardCharsets.UTF_8);
        }
    }

    public static class StringAggString
    extends Combine.CombineFn<String, String, String> {
        private final String delimiter;

        public StringAggString(String delimiter) {
            this.delimiter = delimiter;
        }

        public String createAccumulator() {
            return "";
        }

        public String addInput(String curString, String nextString) {
            if (!nextString.isEmpty()) {
                curString = !curString.isEmpty() ? curString + this.delimiter + nextString : nextString;
            }
            return curString;
        }

        public String mergeAccumulators(Iterable<String> accumList) {
            String mergeString = "";
            for (String stringAccum : accumList) {
                if (stringAccum.isEmpty()) continue;
                if (!mergeString.isEmpty()) {
                    mergeString = mergeString + this.delimiter + stringAccum;
                    continue;
                }
                mergeString = stringAccum;
            }
            return mergeString;
        }

        public String extractOutput(String output) {
            return output;
        }
    }
}

