/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.transform;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Map;
import java.util.function.Function;
import org.apache.beam.sdk.coders.BigDecimalCoder;
import org.apache.beam.sdk.coders.BigEndianIntegerCoder;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.extensions.sql.impl.transform.agg.CountIf;
import org.apache.beam.sdk.extensions.sql.impl.transform.agg.CovarianceFn;
import org.apache.beam.sdk.extensions.sql.impl.transform.agg.VarianceFn;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Max;
import org.apache.beam.sdk.transforms.Min;
import org.apache.beam.sdk.transforms.Sample;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BeamBuiltinAggregations {
    public static final Map<String, Function<Schema.FieldType, Combine.CombineFn<?, ?, ?>>> BUILTIN_AGGREGATOR_FACTORIES = ImmutableMap.builder().put((Object)"ANY_VALUE", typeName -> Sample.anyValueCombineFn()).put((Object)"COUNT", typeName -> new DropNullFn(Count.combineFn())).put((Object)"MAX", typeName -> new DropNullFn(BeamBuiltinAggregations.createMax(typeName))).put((Object)"MIN", typeName -> new DropNullFn(BeamBuiltinAggregations.createMin(typeName))).put((Object)"SUM", typeName -> new DropNullFn(BeamBuiltinAggregations.createSum(typeName))).put((Object)"$SUM0", typeName -> new DropNullFn(BeamBuiltinAggregations.createSum0(typeName))).put((Object)"AVG", typeName -> new DropNullFn(BeamBuiltinAggregations.createAvg(typeName))).put((Object)"BIT_OR", typeName -> new DropNullFn(BeamBuiltinAggregations.createBitOr(typeName))).put((Object)"BIT_XOR", typeName -> new DropNullFn(BeamBuiltinAggregations.createBitXOr(typeName))).put((Object)"BIT_AND", typeName -> new DropNullFn(BeamBuiltinAggregations.createBitAnd(typeName))).put((Object)"VAR_POP", t -> VarianceFn.newPopulation(t.getTypeName())).put((Object)"VAR_SAMP", t -> VarianceFn.newSample(t.getTypeName())).put((Object)"COVAR_POP", t -> CovarianceFn.newPopulation(t.getTypeName())).put((Object)"COVAR_SAMP", t -> CovarianceFn.newSample(t.getTypeName())).put((Object)"COUNTIF", typeName -> CountIf.combineFn()).build();
    private static MathContext mc = new MathContext(10, RoundingMode.HALF_UP);

    public static Combine.CombineFn<?, ?, ?> create(String functionName, Schema.FieldType fieldType) {
        Function<Schema.FieldType, Combine.CombineFn<?, ?, ?>> aggregatorFactory = BUILTIN_AGGREGATOR_FACTORIES.get(functionName);
        if (aggregatorFactory != null) {
            return aggregatorFactory.apply(fieldType);
        }
        throw new UnsupportedOperationException(String.format("Aggregator [%s] is not supported", functionName));
    }

    static Combine.CombineFn createMax(Schema.FieldType fieldType) {
        if (CalciteUtils.isDateTimeType(fieldType)) {
            return new CustMax();
        }
        switch (fieldType.getTypeName()) {
            case BOOLEAN: 
            case INT16: 
            case BYTE: 
            case FLOAT: 
            case DATETIME: 
            case DECIMAL: 
            case STRING: {
                return new CustMax();
            }
            case INT32: {
                return Max.ofIntegers();
            }
            case INT64: {
                return Max.ofLongs();
            }
            case DOUBLE: {
                return Max.ofDoubles();
            }
        }
        throw new UnsupportedOperationException(String.format("[%s] is not supported in MAX", fieldType));
    }

    static Combine.CombineFn createMin(Schema.FieldType fieldType) {
        if (CalciteUtils.isDateTimeType(fieldType)) {
            return new CustMin();
        }
        switch (fieldType.getTypeName()) {
            case BOOLEAN: 
            case INT16: 
            case BYTE: 
            case FLOAT: 
            case DATETIME: 
            case DECIMAL: 
            case STRING: {
                return new CustMin();
            }
            case INT32: {
                return Min.ofIntegers();
            }
            case INT64: {
                return Min.ofLongs();
            }
            case DOUBLE: {
                return Min.ofDoubles();
            }
        }
        throw new UnsupportedOperationException(String.format("[%s] is not supported in MIN", fieldType));
    }

    static Combine.CombineFn createSum(Schema.FieldType fieldType) {
        switch (fieldType.getTypeName()) {
            case INT32: {
                return Sum.ofIntegers();
            }
            case INT16: {
                return new ShortSum();
            }
            case BYTE: {
                return new ByteSum();
            }
            case INT64: {
                return new LongSum();
            }
            case FLOAT: {
                return new FloatSum();
            }
            case DOUBLE: {
                return Sum.ofDoubles();
            }
            case DECIMAL: {
                return new BigDecimalSum();
            }
        }
        throw new UnsupportedOperationException(String.format("[%s] is not supported in SUM", fieldType));
    }

    static Combine.CombineFn createSum0(Schema.FieldType fieldType) {
        switch (fieldType.getTypeName()) {
            case INT32: {
                return new IntegerSum0();
            }
            case INT16: {
                return new ShortSum0();
            }
            case BYTE: {
                return new ByteSum0();
            }
            case INT64: {
                return new LongSum0();
            }
            case FLOAT: {
                return new FloatSum0();
            }
            case DOUBLE: {
                return new DoubleSum0();
            }
            case DECIMAL: {
                return new BigDecimalSum0();
            }
        }
        throw new UnsupportedOperationException(String.format("[%s] is not supported in SUM0", fieldType));
    }

    static Combine.CombineFn createAvg(Schema.FieldType fieldType) {
        switch (fieldType.getTypeName()) {
            case INT32: {
                return new IntegerAvg();
            }
            case INT16: {
                return new ShortAvg();
            }
            case BYTE: {
                return new ByteAvg();
            }
            case INT64: {
                return new LongAvg();
            }
            case FLOAT: {
                return new FloatAvg();
            }
            case DOUBLE: {
                return new DoubleAvg();
            }
            case DECIMAL: {
                return new BigDecimalAvg();
            }
        }
        throw new UnsupportedOperationException(String.format("[%s] is not supported in AVG", fieldType));
    }

    static Combine.CombineFn createBitOr(Schema.FieldType fieldType) {
        if (fieldType.getTypeName() == Schema.TypeName.INT64) {
            return new BitOr();
        }
        throw new UnsupportedOperationException(String.format("[%s] is not supported in BIT_OR", fieldType));
    }

    static Combine.CombineFn createBitAnd(Schema.FieldType fieldType) {
        if (fieldType.getTypeName() == Schema.TypeName.INT64) {
            return new BitAnd();
        }
        throw new UnsupportedOperationException(String.format("[%s] is not supported in BIT_AND", fieldType));
    }

    public static Combine.CombineFn createBitXOr(Schema.FieldType fieldType) {
        if (fieldType.getTypeName() == Schema.TypeName.INT64) {
            return new BitXOr();
        }
        throw new UnsupportedOperationException(String.format("[%s] is not supported in BIT_XOR", fieldType));
    }

    public static class BitXOr<T extends Number>
    extends Combine.CombineFn<T, Accum, Long> {
        public Accum createAccumulator() {
            return new Accum();
        }

        public Accum addInput(Accum mutableAccumulator, T input) {
            if (input != null) {
                mutableAccumulator.isEmpty = false;
                mutableAccumulator.bitXOr ^= ((Number)input).longValue();
            }
            return mutableAccumulator;
        }

        public Accum mergeAccumulators(Iterable<Accum> accumulators) {
            Accum merged = this.createAccumulator();
            for (Accum accum : accumulators) {
                if (accum.isEmpty) continue;
                merged.isEmpty = false;
                merged.bitXOr ^= accum.bitXOr;
            }
            return merged;
        }

        public Long extractOutput(Accum accumulator) {
            if (accumulator.isEmpty) {
                return null;
            }
            return accumulator.bitXOr;
        }

        static class Accum
        implements Serializable {
            boolean isEmpty = true;
            long bitXOr = 0L;

            Accum() {
            }
        }
    }

    static class BitAnd<T extends Number>
    extends Combine.CombineFn<T, Accum, Long> {
        BitAnd() {
        }

        public Accum createAccumulator() {
            return new Accum();
        }

        public Accum addInput(Accum accum, T input) {
            accum.isEmpty = false;
            accum.bitAnd &= ((Number)input).longValue();
            return accum;
        }

        public Accum mergeAccumulators(Iterable<Accum> accums) {
            Accum merged = this.createAccumulator();
            for (Accum accum : accums) {
                if (accum.isEmpty) continue;
                merged.isEmpty = false;
                merged.bitAnd &= accum.bitAnd;
            }
            return merged;
        }

        public Long extractOutput(Accum accum) {
            if (accum.isEmpty) {
                return null;
            }
            return accum.bitAnd;
        }

        static class Accum
        implements Serializable {
            boolean isEmpty = true;
            long bitAnd = -1L;

            Accum() {
            }
        }
    }

    static class BitOr<T extends Number>
    extends Combine.CombineFn<T, Accum, Long> {
        BitOr() {
        }

        public Accum createAccumulator() {
            return new Accum();
        }

        public Accum addInput(Accum accum, T input) {
            accum.isEmpty = false;
            accum.bitOr |= ((Number)input).longValue();
            return accum;
        }

        public Accum mergeAccumulators(Iterable<Accum> accums) {
            Accum merged = this.createAccumulator();
            for (Accum accum : accums) {
                if (accum.isEmpty) continue;
                merged.isEmpty = false;
                merged.bitOr |= accum.bitOr;
            }
            return merged;
        }

        public Long extractOutput(Accum accum) {
            if (accum.isEmpty) {
                return null;
            }
            return accum.bitOr;
        }

        static class Accum
        implements Serializable {
            boolean isEmpty = true;
            long bitOr = 0L;

            Accum() {
            }
        }
    }

    static class BigDecimalAvg
    extends Avg<BigDecimal> {
        BigDecimalAvg() {
        }

        @Override
        public @Nullable BigDecimal extractOutput(KV<Integer, BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : this.prepareOutput(accumulator);
        }

        @Override
        public BigDecimal toBigDecimal(BigDecimal record) {
            return record;
        }
    }

    static class DoubleAvg
    extends Avg<Double> {
        DoubleAvg() {
        }

        @Override
        public @Nullable Double extractOutput(KV<Integer, BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : Double.valueOf(this.prepareOutput(accumulator).doubleValue());
        }

        @Override
        public BigDecimal toBigDecimal(Double record) {
            return new BigDecimal(record);
        }
    }

    static class FloatAvg
    extends Avg<Float> {
        FloatAvg() {
        }

        @Override
        public @Nullable Float extractOutput(KV<Integer, BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : Float.valueOf(this.prepareOutput(accumulator).floatValue());
        }

        @Override
        public BigDecimal toBigDecimal(Float record) {
            return new BigDecimal(record.floatValue());
        }
    }

    static class ByteAvg
    extends Avg<Byte> {
        ByteAvg() {
        }

        @Override
        public @Nullable Byte extractOutput(KV<Integer, BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : Byte.valueOf(this.prepareOutput(accumulator).byteValue());
        }

        @Override
        public BigDecimal toBigDecimal(Byte record) {
            return new BigDecimal(record.byteValue());
        }
    }

    static class ShortAvg
    extends Avg<Short> {
        ShortAvg() {
        }

        @Override
        public @Nullable Short extractOutput(KV<Integer, BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : Short.valueOf(this.prepareOutput(accumulator).shortValue());
        }

        @Override
        public BigDecimal toBigDecimal(Short record) {
            return new BigDecimal(record.shortValue());
        }
    }

    static class LongAvg
    extends Avg<Long> {
        LongAvg() {
        }

        @Override
        public @Nullable Long extractOutput(KV<Integer, BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : Long.valueOf(this.prepareOutput(accumulator).longValue());
        }

        @Override
        public BigDecimal toBigDecimal(Long record) {
            return new BigDecimal(record);
        }
    }

    static class IntegerAvg
    extends Avg<Integer> {
        IntegerAvg() {
        }

        @Override
        public @Nullable Integer extractOutput(KV<Integer, BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : Integer.valueOf(this.prepareOutput(accumulator).intValue());
        }

        @Override
        public BigDecimal toBigDecimal(Integer record) {
            return new BigDecimal(record);
        }
    }

    static abstract class Avg<T extends Number>
    extends Combine.CombineFn<T, KV<Integer, BigDecimal>, T> {
        Avg() {
        }

        public KV<Integer, BigDecimal> createAccumulator() {
            return KV.of((Object)0, (Object)BigDecimal.ZERO);
        }

        public KV<Integer, BigDecimal> addInput(KV<Integer, BigDecimal> accumulator, T input) {
            return KV.of((Object)((Integer)accumulator.getKey() + 1), (Object)((BigDecimal)accumulator.getValue()).add(this.toBigDecimal(input)));
        }

        public KV<Integer, BigDecimal> mergeAccumulators(Iterable<KV<Integer, BigDecimal>> accumulators) {
            int size = 0;
            BigDecimal acc = BigDecimal.ZERO;
            for (KV<Integer, BigDecimal> ele : accumulators) {
                size += ((Integer)ele.getKey()).intValue();
                acc = acc.add((BigDecimal)ele.getValue());
            }
            return KV.of((Object)size, (Object)acc);
        }

        public Coder<KV<Integer, BigDecimal>> getAccumulatorCoder(CoderRegistry registry, Coder<T> inputCoder) {
            return KvCoder.of((Coder)BigEndianIntegerCoder.of(), (Coder)BigDecimalCoder.of());
        }

        protected BigDecimal prepareOutput(KV<Integer, BigDecimal> accumulator) {
            return ((BigDecimal)accumulator.getValue()).divide(new BigDecimal((Integer)accumulator.getKey()), mc);
        }

        public abstract T extractOutput(KV<Integer, BigDecimal> var1);

        public abstract BigDecimal toBigDecimal(T var1);
    }

    private static class DropNullFn<InputT, AccumT, OutputT>
    extends Combine.CombineFn<InputT, AccumT, OutputT> {
        private final Combine.CombineFn<InputT, AccumT, OutputT> combineFn;

        DropNullFn(Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
            this.combineFn = combineFn;
        }

        public AccumT createAccumulator() {
            return (AccumT)this.combineFn.createAccumulator();
        }

        public AccumT addInput(AccumT accumulator, InputT input) {
            return (AccumT)(input == null ? accumulator : this.combineFn.addInput(accumulator, input));
        }

        public AccumT mergeAccumulators(Iterable<AccumT> accumulators) {
            return (AccumT)this.combineFn.mergeAccumulators(accumulators);
        }

        public OutputT extractOutput(AccumT accumulator) {
            return (OutputT)this.combineFn.extractOutput(accumulator);
        }

        public Coder<AccumT> getAccumulatorCoder(CoderRegistry registry, Coder<InputT> inputCoder) throws CannotProvideCoderException {
            return this.combineFn.getAccumulatorCoder(registry, inputCoder);
        }
    }

    static class BigDecimalSum0
    extends BigDecimalSum {
        BigDecimalSum0() {
        }

        public @Nullable BigDecimal identity() {
            return BigDecimal.ZERO;
        }
    }

    static class LongSum0
    extends LongSum {
        LongSum0() {
        }

        public @Nullable Long identity() {
            return 0L;
        }
    }

    static class DoubleSum0
    extends DoubleSum {
        DoubleSum0() {
        }

        public @Nullable Double identity() {
            return 0.0;
        }
    }

    static class FloatSum0
    extends FloatSum {
        FloatSum0() {
        }

        public @Nullable Float identity() {
            return Float.valueOf(0.0f);
        }
    }

    static class ByteSum0
    extends ByteSum {
        ByteSum0() {
        }

        public @Nullable Byte identity() {
            return (byte)0;
        }
    }

    static class ShortSum0
    extends ShortSum {
        ShortSum0() {
        }

        public @Nullable Short identity() {
            return (short)0;
        }
    }

    static class IntegerSum0
    extends IntegerSum {
        IntegerSum0() {
        }

        public @Nullable Integer identity() {
            return 0;
        }
    }

    static class BigDecimalSum
    extends Combine.BinaryCombineFn<BigDecimal> {
        BigDecimalSum() {
        }

        public BigDecimal apply(BigDecimal left, BigDecimal right) {
            return left.add(right);
        }
    }

    static class LongSum
    extends Combine.BinaryCombineFn<Long> {
        LongSum() {
        }

        public Long apply(Long left, Long right) {
            return Math.addExact(left, right);
        }
    }

    static class DoubleSum
    extends Combine.BinaryCombineFn<Double> {
        DoubleSum() {
        }

        public Double apply(Double left, Double right) {
            return left + right;
        }
    }

    static class FloatSum
    extends Combine.BinaryCombineFn<Float> {
        FloatSum() {
        }

        public Float apply(Float left, Float right) {
            return Float.valueOf(left.floatValue() + right.floatValue());
        }
    }

    static class ByteSum
    extends Combine.BinaryCombineFn<Byte> {
        ByteSum() {
        }

        public Byte apply(Byte left, Byte right) {
            return (byte)(left + right);
        }
    }

    static class ShortSum
    extends Combine.BinaryCombineFn<Short> {
        ShortSum() {
        }

        public Short apply(Short left, Short right) {
            return (short)(left + right);
        }
    }

    static class IntegerSum
    extends Combine.BinaryCombineFn<Integer> {
        IntegerSum() {
        }

        public Integer apply(Integer left, Integer right) {
            return left + right;
        }
    }

    static class CustMin<T extends Comparable<T>>
    extends Combine.BinaryCombineFn<T> {
        CustMin() {
        }

        public T apply(T left, T right) {
            return left == null || left.compareTo(right) < 0 ? left : right;
        }
    }

    static class CustMax<T extends Comparable<T>>
    extends Combine.BinaryCombineFn<T> {
        CustMax() {
        }

        public T apply(T left, T right) {
            return right == null || right.compareTo(left) < 0 ? left : right;
        }
    }
}

