/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.bigtable;

import com.google.bigtable.v2.RowFilter;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTableFilter;
import org.apache.beam.sdk.io.gcp.bigtable.RowUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rex.RexCall;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rex.RexInputRef;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

class BigtableFilter
implements BeamSqlTableFilter {
    private final List<RexNode> supported;
    private final List<RexNode> unsupported;
    private final Schema schema;

    BigtableFilter(List<RexNode> predicateCNF, Schema schema) {
        this.supported = predicateCNF.stream().filter(BigtableFilter::isSupported).collect(Collectors.toList());
        this.unsupported = predicateCNF.stream().filter(predicate -> !BigtableFilter.isSupported(predicate)).collect(Collectors.toList());
        this.schema = schema;
    }

    @Override
    public List<RexNode> getNotSupported() {
        return this.unsupported;
    }

    @Override
    public int numSupported() {
        return BeamSqlTableFilter.expressionsInFilter(this.supported);
    }

    public List<RexNode> getSupported() {
        return this.supported;
    }

    public String toString() {
        String supStr = this.supported.stream().map(RexNode::toString).collect(Collectors.joining());
        String unsupStr = this.unsupported.stream().map(RexNode::toString).collect(Collectors.joining());
        return String.format("[supported{%s}, unsupported{%s}]", supStr, unsupStr);
    }

    RowFilter getFilters() {
        Preconditions.checkArgument((this.supported.size() == 1 ? 1 : 0) != 0, (Object)String.format("Only one LIKE operation is allowed. Got %s operations", this.supported.size()));
        return this.translateRexNodeToRowFilter(this.supported.get(0));
    }

    private RowFilter translateRexNodeToRowFilter(RexNode node) {
        BigtableFilter.checkNodeIsCoposite(node);
        Preconditions.checkArgument((boolean)SqlKind.LIKE.equals((Object)node.getKind()), (Object)"Only LIKE operation is supported.");
        List<RexLiteral> literals = this.filterOperands((RexCall)node, RexLiteral.class);
        List<RexInputRef> inputRefs = this.filterOperands((RexCall)node, RexInputRef.class);
        Preconditions.checkArgument((literals.size() == 1 ? 1 : 0) != 0);
        Preconditions.checkArgument((inputRefs.size() == 1 ? 1 : 0) != 0);
        this.checkFieldIsKey(inputRefs.get(0));
        String literal = (String)literals.get(0).getValueAs(String.class);
        return RowFilter.newBuilder().setRowKeyRegexFilter(RowUtils.byteStringUtf8((String)literal)).build();
    }

    private void checkFieldIsKey(RexInputRef inputRef) {
        String inputFieldName = this.schema.getField(inputRef.getIndex()).getName();
        Preconditions.checkArgument((boolean)"key".equals(inputFieldName), (Object)("Only 'key' queries are supported. Got field " + inputFieldName));
    }

    private static boolean isSupported(RexNode node) {
        BigtableFilter.checkNodeIsCoposite(node);
        if (!SqlKind.LIKE.equals((Object)node.getKind())) {
            return false;
        }
        long literalsCount = BigtableFilter.countOperands((RexCall)node, RexLiteral.class);
        long fieldsCount = BigtableFilter.countOperands((RexCall)node, RexInputRef.class);
        return literalsCount == 1L && fieldsCount == 1L;
    }

    private <T extends RexNode> List<T> filterOperands(RexCall compositeNode, Class<T> clazz) {
        return compositeNode.getOperands().stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }

    private static <T extends RexNode> long countOperands(RexCall compositeNode, Class<T> clazz) {
        return compositeNode.getOperands().stream().filter(clazz::isInstance).count();
    }

    private static void checkNodeIsCoposite(RexNode node) {
        Preconditions.checkArgument((boolean)(node instanceof RexCall), (Object)String.format("Encountered an unexpected node type: %s. Should be %s", node.getClass().getSimpleName(), RexCall.class.getSimpleName()));
    }
}

