/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.adapter.enumerable.AggImplementor;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.schema.AggregateFunction;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.schema.FunctionParameter;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.schema.ImplementableAggFunction;

@Experimental
@Internal
public class UdafImpl<InputT, AccumT, OutputT>
implements AggregateFunction,
ImplementableAggFunction,
Serializable {
    private Combine.CombineFn<InputT, AccumT, OutputT> combineFn;

    public UdafImpl(Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
        this.combineFn = combineFn;
    }

    public Combine.CombineFn<InputT, AccumT, OutputT> getCombineFn() {
        return this.combineFn;
    }

    public List<FunctionParameter> getParameters() {
        ArrayList<FunctionParameter> para = new ArrayList<FunctionParameter>();
        para.add(new FunctionParameter(){

            public int getOrdinal() {
                return 0;
            }

            public String getName() {
                return null;
            }

            public RelDataType getType(RelDataTypeFactory typeFactory) {
                Type inputType = UdafImpl.this.getInputType();
                if (inputType instanceof TypeVariable) {
                    throw new IllegalArgumentException("Unable to infer SQL type from type variable " + inputType + ". This usually means you are trying to use a generic type whose type information is not known at runtime. You can wrap your CombineFn into typed subclass by 'new TypedCombineFnDelegate<...>(combineFn) {}'");
                }
                return CalciteUtils.sqlTypeWithAutoCast(typeFactory, inputType);
            }

            public boolean isOptional() {
                return false;
            }
        });
        return para;
    }

    public AggImplementor getImplementor(boolean windowContext) {
        return null;
    }

    public RelDataType getReturnType(RelDataTypeFactory typeFactory) {
        return CalciteUtils.sqlTypeWithAutoCast(typeFactory, this.getOutputType());
    }

    protected Type getInputType() {
        Type inputType = this.combineFn.getInputType().getType();
        if (inputType != null && !(inputType instanceof TypeVariable)) {
            return inputType;
        }
        ParameterizedType parameterizedType = this.findCombineFnSuperClass();
        return parameterizedType.getActualTypeArguments()[0];
    }

    protected Type getOutputType() {
        return this.combineFn.getOutputType().getType();
    }

    private ParameterizedType findCombineFnSuperClass() {
        Class<?> clazz = this.combineFn.getClass();
        while (!clazz.getSuperclass().equals(Combine.CombineFn.class)) {
            clazz = clazz.getSuperclass();
        }
        if (!(clazz.getGenericSuperclass() instanceof ParameterizedType)) {
            throw new IllegalStateException("Subclass of " + Combine.CombineFn.class + " must be parameterized to be used as a UDAF");
        }
        return (ParameterizedType)clazz.getGenericSuperclass();
    }
}

